/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.lang;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;

public class MathUtil {
    private static final String[] HAN_DIGISTR_UPPER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] HAN_DIGISTR_LOWER = new String[]{"\u25cb", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] HAN_DIVISTR = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf"};

    public static int[] getUniqueRandoms(int n) {
        int[] num = new int[n];
        Random r = new Random(System.currentTimeMillis());
        for (int i = 0; i < n; ++i) {
            num[i] = Math.abs(r.nextInt());
        }
        return num;
    }

    public static int[] getUniqueRandoms(int n, int len) {
        int[] num = new int[n];
        Random r = new Random(System.currentTimeMillis());
        for (int i = 0; i < n; ++i) {
            num[i] = Math.abs(r.nextInt() % MathUtil.digit(len));
        }
        return num;
    }

    public static int getRandom() {
        return Math.abs(new Random().nextInt());
    }

    public static int getRandom(int len) {
        int maxvalue = MathUtil.digit(len);
        return Math.abs(new Random().nextInt(maxvalue));
    }

    private static int digit(int n) {
        int j = 1;
        for (int i = 0; i < n; ++i) {
            j = 10 * j;
        }
        return j - 1;
    }

    public static String numToStrUpper(int val) {
        return MathUtil.getIntToCnStr(HAN_DIGISTR_UPPER, String.valueOf(val));
    }

    public static String numToStrLower(int val) {
        return MathUtil.getIntToCnStr(HAN_DIGISTR_LOWER, String.valueOf(val));
    }

    public static String numToRMBStrUpper(double val) {
        String signStr = "";
        String tailStr = "";
        if (val < 0.0) {
            val = -val;
            signStr = "\u8d1f";
        }
        if (val > 1.0E14 || val < -1.0E14) {
            return "\u6570\u503c\u4f4d\u6570\u8fc7\u5927!";
        }
        long temp = Math.round(val * 100.0);
        long integer = temp / 100L;
        long fraction = temp % 100L;
        int jiao = (int)fraction / 10;
        int fen = (int)fraction % 10;
        if (jiao == 0 && fen == 0) {
            tailStr = "\u6574";
        } else {
            tailStr = HAN_DIGISTR_UPPER[jiao];
            if (jiao != 0) {
                tailStr = tailStr + "\u89d2";
            }
            if (integer == 0L && jiao == 0) {
                tailStr = "";
            }
            if (fen != 0) {
                tailStr = tailStr + HAN_DIGISTR_UPPER[fen] + "\u5206";
            }
        }
        return "\uffe5" + signStr + MathUtil.getIntToCnStr(HAN_DIGISTR_UPPER, String.valueOf(integer)) + "\u5143" + tailStr;
    }

    public static String numToRMBStrLower(double val) {
        String signStr = "";
        String tailStr = "";
        if (val < 0.0) {
            val = -val;
            signStr = "\u8d1f";
        }
        if (val > 1.0E14 || val < -1.0E14) {
            return "\u6570\u503c\u4f4d\u6570\u8fc7\u5927!";
        }
        long temp = Math.round(val * 100.0);
        long integer = temp / 100L;
        long fraction = temp % 100L;
        int jiao = (int)fraction / 10;
        int fen = (int)fraction % 10;
        if (jiao == 0 && fen == 0) {
            tailStr = "\u6574";
        } else {
            tailStr = HAN_DIGISTR_LOWER[jiao];
            if (jiao != 0) {
                tailStr = tailStr + "\u89d2";
            }
            if (integer == 0L && jiao == 0) {
                tailStr = "";
            }
            if (fen != 0) {
                tailStr = tailStr + HAN_DIGISTR_LOWER[fen] + "\u5206";
            }
        }
        return "\uffe5" + signStr + MathUtil.getIntToCnStr(HAN_DIGISTR_LOWER, String.valueOf(integer)) + "\u5143" + tailStr;
    }

    public static String formatMoney(double val, Locale type) {
        NumberFormat numFormat = NumberFormat.getCurrencyInstance(type);
        return numFormat.format(val);
    }

    public static String formatMoney(double val) {
        NumberFormat numFormat = NumberFormat.getCurrencyInstance();
        return numFormat.format(val);
    }

    private static String getIntToCnStr(String[] hanDigi, String numStr) {
        String rMBStr = "";
        boolean lastzero = false;
        boolean hasvalue = false;
        int len = numStr.length();
        if (len > 15) {
            return "\u6570\u503c\u8fc7\u5927!";
        }
        for (int i = len - 1; i >= 0; --i) {
            if (numStr.charAt(len - i - 1) == ' ') continue;
            int n = numStr.charAt(len - i - 1) - 48;
            if (n < 0 || n > 9) {
                return "\u8f93\u5165\u542b\u975e\u6570\u5b57\u5b57\u7b26!";
            }
            if (n != 0) {
                if (lastzero) {
                    rMBStr = rMBStr + hanDigi[0];
                }
                if (n != 1 || i % 4 != 1 || i != len - 1) {
                    rMBStr = rMBStr + hanDigi[n];
                }
                rMBStr = rMBStr + hanDigi[i];
                hasvalue = true;
            } else if (i % 8 == 0 || i % 8 == 4 && hasvalue) {
                rMBStr = rMBStr + hanDigi[i];
                hasvalue = false;
            }
            if (i % 8 == 0 || i % 8 == 4) {
                hasvalue = false;
            }
            lastzero = n == 0 && i % 4 != 0;
        }
        if (rMBStr.length() == 0) {
            return hanDigi[0];
        }
        return rMBStr;
    }
}

