/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.net;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.StringTokenizer;

public final class NetworkUtil {
    public static String getMacAddress() throws IOException, ParseException, InterruptedException {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return NetworkUtil.windowsParseMacAddress(NetworkUtil.windowsRunIpConfigCommand());
        }
        if (os.startsWith("Linux")) {
            return NetworkUtil.linuxParseMacAddress(NetworkUtil.linuxRunIfConfigCommand());
        }
        if (os.startsWith("AIX")) {
            return NetworkUtil.getMacOnAix();
        }
        if (os.startsWith("Unix")) {
            return NetworkUtil.getMacOnUnix();
        }
        throw new IOException("unknown operating system: " + os);
    }

    public static String linuxParseMacAddress(String ipConfigResponse) throws ParseException, UnknownHostException, UnsupportedEncodingException {
        String localHost = null;
        localHost = InetAddress.getLocalHost().getHostAddress();
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            boolean containsLocalHost;
            String line = tokenizer.nextToken().trim();
            boolean bl = containsLocalHost = line.indexOf(localHost) >= 0;
            if (containsLocalHost && lastMacAddress != null) {
                return lastMacAddress;
            }
            int pianyi = 0;
            int macAddressPosition = -1;
            if (line.indexOf("HWaddr") > 0) {
                macAddressPosition = line.indexOf("HWaddr");
                pianyi = 6;
            } else {
                line = new String(line.getBytes("ISO-8859-1"), "UTF-8");
                macAddressPosition = line.indexOf("\u786c\u4ef6\u5730\u5740");
                pianyi = 5;
            }
            if (macAddressPosition <= 0 || !NetworkUtil.linuxIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + pianyi).trim().replace(':', '-'))) continue;
            lastMacAddress = macAddressCandidate;
            if (line.indexOf("\u786c\u4ef6\u5730\u5740") <= 0) continue;
            return lastMacAddress;
        }
        ParseException ex = new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        throw ex;
    }

    private static boolean linuxIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private static String linuxRunIfConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ifconfig");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static String windowsParseMacAddress(String ipConfigResponse) throws UnknownHostException, ParseException {
        String localHost = null;
        localHost = InetAddress.getLocalHost().getHostAddress();
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            String line = tokenizer.nextToken().trim();
            if (line.contains(localHost) && lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = line.indexOf(":");
            if (macAddressPosition <= 0 || !NetworkUtil.windowsIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 1).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        ParseException ex = new ParseException("cannot read MAC address from [" + ipConfigResponse + "]", 0);
        throw ex;
    }

    private static boolean windowsIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private static String windowsRunIpConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ipconfig /all");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static String getMacOnAix() throws IOException, InterruptedException {
        String nextLine;
        String s = "";
        String s1 = "netstat -i";
        Process process = Runtime.getRuntime().exec(s1);
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = bufferedreader.readLine();
        if (line != null && (nextLine = bufferedreader.readLine()).indexOf("link#2") > 0) {
            String[] datas = nextLine.split(" ");
            s = datas[11].length() == 16 ? "0" + datas[11] : datas[11];
        }
        bufferedreader.close();
        process.waitFor();
        s = s.trim().replace('.', '-');
        return s;
    }

    private static String getMacOnWindow() throws IOException, InterruptedException {
        String s = "";
        String s1 = "ipconfig /all";
        Process process = Runtime.getRuntime().exec(s1);
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = bufferedreader.readLine();
        while (line != null) {
            String nextLine = bufferedreader.readLine();
            if (line.indexOf("Physical Address") > 0) {
                int i = line.indexOf("Physical Address") + 36;
                s = line.substring(i);
                break;
            }
            line = nextLine;
        }
        bufferedreader.close();
        process.waitFor();
        return s.trim();
    }

    private static String getMacOnUnix() throws IOException, InterruptedException {
        String s = "";
        String s1 = "ifconfig";
        Process process = Runtime.getRuntime().exec(s1);
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = bufferedreader.readLine();
        while (line != null) {
            String nextLine = bufferedreader.readLine();
            if (line.indexOf("HWaddr") > 0) {
                int i = line.indexOf("HWaddr") + 7;
                s = line.substring(i);
                break;
            }
            line = nextLine;
        }
        bufferedreader.close();
        process.waitFor();
        return s.trim().replace(':', '-');
    }
}

