/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ConverterUtil {
    private static boolean isCustomClassPresent = false;
    private static Class customClass;

    public static boolean convertToBoolean(String s) {
        boolean returnValue = false;
        if (s != null && s.length() > 0) {
            if ("1".equals(s) || s.toLowerCase().equals("true")) {
                returnValue = true;
            } else if (!"0".equals(s) && !s.toLowerCase().equals("false")) {
                throw new RuntimeException("in valid string -" + s + " for boolean value");
            }
        }
        return returnValue;
    }

    public static Calendar convertToDateTime(String source) {
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Object date = null;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minite = 0;
        int second = 0;
        long miliSecond = 0L;
        int timeZoneOffSet = TimeZone.getDefault().getRawOffset();
        if (source != null && source.length() >= 19) {
            if (source.charAt(4) != '-' || source.charAt(7) != '-' || source.charAt(10) != 'T' || source.charAt(13) != ':' || source.charAt(16) != ':') {
                throw new RuntimeException("invalid date format (" + source + ") with out - s at correct place ");
            }
            year = Integer.parseInt(source.substring(0, 4));
            month = Integer.parseInt(source.substring(5, 7));
            day = Integer.parseInt(source.substring(8, 10));
            hour = Integer.parseInt(source.substring(11, 13));
            minite = Integer.parseInt(source.substring(14, 16));
            second = Integer.parseInt(source.substring(17, 19));
            int milliSecondPartLength = 0;
            if (source.length() > 19) {
                String rest = source.substring(19);
                if (rest.startsWith(".")) {
                    if (rest.endsWith("Z")) {
                        timeZoneOffSet = 0;
                        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                        miliSecond = Integer.parseInt(rest.substring(1, rest.lastIndexOf("Z")));
                        milliSecondPartLength = rest.substring(1, rest.lastIndexOf("Z")).trim().length();
                    } else if (rest.lastIndexOf("+") > 0 || rest.lastIndexOf("-") > 0) {
                        String timeOffSet = null;
                        if (rest.lastIndexOf("+") > 0) {
                            timeOffSet = rest.substring(rest.lastIndexOf("+") + 1);
                            miliSecond = Integer.parseInt(rest.substring(1, rest.lastIndexOf("+")));
                            milliSecondPartLength = rest.substring(1, rest.lastIndexOf("+")).trim().length();
                            timeZoneOffSet = 1;
                        } else if (rest.lastIndexOf("-") > 0) {
                            timeOffSet = rest.substring(rest.lastIndexOf("-") + 1);
                            miliSecond = Integer.parseInt(rest.substring(1, rest.lastIndexOf("-")));
                            milliSecondPartLength = rest.substring(1, rest.lastIndexOf("-")).trim().length();
                            timeZoneOffSet = -1;
                        }
                        if (timeOffSet.charAt(2) != ':') {
                            throw new RuntimeException("invalid time zone format (" + source + ") without : at correct place");
                        }
                        int hours = Integer.parseInt(timeOffSet.substring(0, 2));
                        int minits = Integer.parseInt(timeOffSet.substring(3, 5));
                        timeZoneOffSet = (hours * 60 + minits) * 60000 * timeZoneOffSet;
                    } else {
                        miliSecond = Integer.parseInt(rest.substring(1));
                        milliSecondPartLength = rest.substring(1).trim().length();
                    }
                } else if (rest.startsWith("Z")) {
                    calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                    timeZoneOffSet = 0;
                } else if (rest.startsWith("+") || rest.startsWith("-")) {
                    if (rest.charAt(3) != ':') {
                        throw new RuntimeException("invalid time zone format (" + source + ") without : at correct place");
                    }
                    int hours = Integer.parseInt(rest.substring(1, 3));
                    int minits = Integer.parseInt(rest.substring(4, 6));
                    timeZoneOffSet = (hours * 60 + minits) * 60000;
                    if (rest.startsWith("-")) {
                        timeZoneOffSet *= -1;
                    }
                } else {
                    throw new NumberFormatException("in valid time zone attribute");
                }
            }
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minite);
            calendar.set(13, second);
            if (milliSecondPartLength != 3) {
                miliSecond *= 1000L;
                for (int i = 0; i < milliSecondPartLength; ++i) {
                    miliSecond /= 10L;
                }
            }
            calendar.set(14, (int)miliSecond);
            calendar.set(15, timeZoneOffSet);
            if (source.length() > 19) {
                calendar.set(16, 0);
            }
        } else {
            throw new NumberFormatException("date string can not be less than 19 characters");
        }
        return calendar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date convertToDate(String source) {
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        boolean bc = false;
        if (source.startsWith("-")) {
            source = source.substring(1);
            bc = true;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int timeZoneOffSet = TimeZone.getDefault().getRawOffset();
        if (source.length() < 10) throw new RuntimeException("In valid string to parse");
        if (source.charAt(4) != '-' || source.charAt(7) != '-') {
            throw new RuntimeException("invalid date format (" + source + ") with out - s at correct place ");
        }
        year = Integer.parseInt(source.substring(0, 4));
        month = Integer.parseInt(source.substring(5, 7));
        day = Integer.parseInt(source.substring(8, 10));
        if (source.length() > 10) {
            String restpart = source.substring(10);
            if (restpart.startsWith("Z")) {
                timeZoneOffSet = 0;
            } else {
                if (!restpart.startsWith("+") && !restpart.startsWith("-") && !restpart.startsWith("T")) throw new RuntimeException("In valid string sufix");
                if (restpart.charAt(3) != ':') {
                    throw new RuntimeException("invalid time zone format (" + source + ") without : at correct place");
                }
                int hours = Integer.parseInt(restpart.substring(1, 3));
                int minits = Integer.parseInt(restpart.substring(4, 6));
                timeZoneOffSet = (hours * 60 + minits) * 60000;
                if (restpart.startsWith("-")) {
                    timeZoneOffSet *= -1;
                }
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(15, timeZoneOffSet);
        if (source.length() >= 10) {
            calendar.set(16, 0);
        }
        calendar.getTimeInMillis();
        if (!bc) return calendar.getTime();
        calendar.set(0, 0);
        return calendar.getTime();
    }

    public static String convertToString(Calendar value) {
        if (isCustomClassPresent) {
            return ConverterUtil.invokeToStringMethod(value, Calendar.class);
        }
        if (value.get(15) == -1) {
            value.setTimeZone(TimeZone.getDefault());
        }
        StringBuffer dateString = new StringBuffer(28);
        ConverterUtil.appendDate(dateString, value);
        dateString.append("T");
        ConverterUtil.appendTime(value, dateString);
        ConverterUtil.appendTimeZone(value, dateString);
        return dateString.toString();
    }

    public static void appendDate(StringBuffer dateString, Calendar calendar) {
        int year = calendar.get(1);
        if (year < 1000) {
            dateString.append("0");
        }
        if (year < 100) {
            dateString.append("0");
        }
        if (year < 10) {
            dateString.append("0");
        }
        dateString.append(year).append("-");
        int month = calendar.get(2) + 1;
        if (month < 10) {
            dateString.append("0");
        }
        dateString.append(month).append("-");
        if (calendar.get(5) < 10) {
            dateString.append("0");
        }
        dateString.append(calendar.get(5));
    }

    public static void appendTime(Calendar value, StringBuffer dateString) {
        if (value.get(11) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(11)).append(":");
        if (value.get(12) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(12)).append(":");
        if (value.get(13) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(13)).append(".");
        if (value.get(14) < 10) {
            dateString.append("0");
        }
        if (value.get(14) < 100) {
            dateString.append("0");
        }
        dateString.append(value.get(14));
    }

    public static void appendTimeZone(Calendar calendar, StringBuffer dateString) {
        int timezoneOffSet = calendar.get(15) + calendar.get(16);
        int timezoneOffSetInMinits = timezoneOffSet / 60000;
        if (timezoneOffSetInMinits < 0) {
            dateString.append("-");
            timezoneOffSetInMinits *= -1;
        } else {
            dateString.append("+");
        }
        int hours = timezoneOffSetInMinits / 60;
        int minits = timezoneOffSetInMinits % 60;
        if (hours < 10) {
            dateString.append("0");
        }
        dateString.append(hours).append(":");
        if (minits < 10) {
            dateString.append("0");
        }
        dateString.append(minits);
    }

    private static String invokeToStringMethod(Object value, Class type) {
        try {
            Method method = customClass.getMethod("convertToString", type);
            String result = (String)method.invoke(null, value);
            return result;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("can not find the method convertToString(" + type.getName() + ") in converter util class " + customClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("can not access the method convertToString(" + type.getName() + ") in converter util class " + customClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("can not invocate the method convertToString(" + type.getName() + ") in converter util class " + customClass.getName(), e);
        }
    }
}

