/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericsUtils {
    private static final Log log = LogFactory.getLog(GenericsUtils.class);

    private GenericsUtils() {
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz) {
        return GenericsUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn((Object)(clazz.getSimpleName() + "'s superclass not ParameterizedType"));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn((Object)("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn((Object)(clazz.getSimpleName() + " not set the actual class on superclass generic parameter"));
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Type[] getGenericReturnType(Method method, Class<?> clazz) {
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (clazz.isAssignableFrom(rawType)) {
                return actualTypeArguments;
            }
        }
        return null;
    }

    public static <T> Class<T> getGenericReturnTypeForMapKeyType(Method method) {
        Type[] actualTypeArguments = GenericsUtils.getGenericReturnType(method, Map.class);
        if (actualTypeArguments != null && actualTypeArguments.length == 2) {
            Type returnTypeParameter = actualTypeArguments[0];
            if (returnTypeParameter instanceof Class) {
                return (Class)returnTypeParameter;
            }
            if (returnTypeParameter instanceof ParameterizedType) {
                return (Class)((ParameterizedType)returnTypeParameter).getRawType();
            }
        }
        return null;
    }
}

