/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.reflect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectionUtils {
    private static Log logger = LogFactory.getLog(ReflectionUtils.class);

    public static Field[] getDeclaredAndInheritedFields(Class type, boolean returnFinalFields) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(ReflectionUtils.getValidFields(type.getDeclaredFields(), returnFinalFields));
        for (Class parent = type.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            allFields.addAll(ReflectionUtils.getValidFields(parent.getDeclaredFields(), returnFinalFields));
        }
        return allFields.toArray(new Field[allFields.size()]);
    }

    public static List<Method> getDeclaredAndInheritedMethods(Class type) {
        return ReflectionUtils.getDeclaredAndInheritedMethods(type, new ArrayList<Method>());
    }

    protected static List<Method> getDeclaredAndInheritedMethods(Class type, List<Method> methods) {
        if (type == null || type == Object.class) {
            return methods;
        }
        if (methods == null) {
            methods = new ArrayList<Method>();
        }
        Class parent = type.getSuperclass();
        methods = ReflectionUtils.getDeclaredAndInheritedMethods(parent, methods);
        for (Method m : type.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            methods.add(m);
        }
        return methods;
    }

    public static List<Field> getValidFields(Field[] fields, boolean returnFinalFields) {
        ArrayList<Field> validFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || !returnFinalFields && Modifier.isFinal(field.getModifiers())) continue;
            validFields.add(field);
        }
        return validFields;
    }

    public static boolean implementsInterface(Class type, Class interfaceClass) {
        return interfaceClass.isAssignableFrom(type);
    }

    public static boolean isPropertyType(Type type) {
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.isPropertyType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof Class) {
            return ReflectionUtils.isPropertyType((Class)type);
        }
        throw new RuntimeException("bad type, not parameterized...");
    }

    public static boolean isPrimitiveLike(Class type) {
        if (type == null) {
            return false;
        }
        return type == String.class || type == Character.TYPE || type == Character.class || type == Short.TYPE || type == Short.class || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Double.class || type == Double.TYPE || type == Float.TYPE || type == Float.class || type == Boolean.class || type == Boolean.TYPE || type == Byte.class || type == Byte.TYPE || type == Date.class || type == Locale.class || type == Class.class || type == UUID.class || type == URI.class || type.isEnum();
    }

    public static Class getParameterizedClass(Field field) {
        try {
            return ReflectionUtils.getParameterizedClass(field, 0);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public static Class getParameterizedClass(Field field, int index) throws Exception {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            if (ptype.getActualTypeArguments() != null && ptype.getActualTypeArguments().length <= index) {
                return null;
            }
            Type paramType = ptype.getActualTypeArguments()[index];
            if (paramType instanceof GenericArrayType) {
                Class arrayType = (Class)((GenericArrayType)paramType).getGenericComponentType();
                return Array.newInstance(arrayType, 0).getClass();
            }
            if (paramType instanceof ParameterizedType) {
                ParameterizedType paramPType = (ParameterizedType)paramType;
                return (Class)paramPType.getRawType();
            }
            if (paramType instanceof TypeVariable) {
                throw new Exception("Generic Typed Class not supported:  <" + ((TypeVariable)paramType).getName() + "> = " + ((TypeVariable)paramType).getBounds()[0]);
            }
            if (paramType instanceof Class) {
                return (Class)paramType;
            }
            throw new Exception("Unknown type... pretty bad... call for help, wave your hands... yeah!");
        }
        return null;
    }

    public static Type getParameterizedType(Field field, int index) throws Exception {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            if (ptype.getActualTypeArguments() != null && ptype.getActualTypeArguments().length <= index) {
                return null;
            }
            Type paramType = ptype.getActualTypeArguments()[index];
            if (paramType instanceof GenericArrayType) {
                return ((GenericArrayType)paramType).getGenericComponentType();
            }
            if (paramType instanceof ParameterizedType) {
                return paramType;
            }
            if (paramType instanceof TypeVariable) {
                return paramType;
            }
            if (paramType instanceof Class) {
                return (Class)paramType;
            }
            throw new Exception("Unknown type... pretty bad... call for help, wave your hands... yeah!");
        }
        return null;
    }

    public static Class getTypeArgumentOfParameterizedClass(Field field, int index, int typeIndex) {
        ParameterizedType paramPType;
        Type paramParamType;
        ParameterizedType ptype;
        Type paramType;
        if (field.getGenericType() instanceof ParameterizedType && !((paramType = (ptype = (ParameterizedType)field.getGenericType()).getActualTypeArguments()[index]) instanceof GenericArrayType) && paramType instanceof ParameterizedType && !((paramParamType = (paramPType = (ParameterizedType)paramType).getActualTypeArguments()[typeIndex]) instanceof ParameterizedType)) {
            return (Class)paramParamType;
        }
        return null;
    }

    public static Class getParameterizedClass(Class c) {
        return ReflectionUtils.getParameterizedClass(c, 0);
    }

    public static Class getParameterizedClass(Class c, int index) {
        TypeVariable<Class<T>>[] typeVars = c.getTypeParameters();
        if (typeVars.length > 0) {
            TypeVariable typeVariable = typeVars[index];
            Type[] bounds = typeVariable.getBounds();
            Type type = bounds[0];
            if (type instanceof Class) {
                return (Class)type;
            }
            return null;
        }
        return null;
    }

    public static boolean isFieldParameterizedWithClass(Field field, Class c) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            for (Type type : ptype.getActualTypeArguments()) {
                if (type == c) {
                    return true;
                }
                if (!c.isInterface() || !ReflectionUtils.implementsInterface((Class)type, c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFieldParameterizedWithPropertyType(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            for (Type type : ptype.getActualTypeArguments()) {
                if (!ReflectionUtils.isPropertyType((Class)type)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T getAnnotation(Class c, Class<T> annClass) {
        ArrayList<T> found = ReflectionUtils.getAnnotations(c, annClass);
        if (found != null && found.size() > 0) {
            return found.get(0);
        }
        return null;
    }

    public static <T> ArrayList<T> getAnnotations(Class c, Class<T> annClass) {
        ArrayList<T> found = new ArrayList<T>();
        if (c.isAnnotationPresent(annClass)) {
            found.add(c.getAnnotation(annClass));
        }
        for (Class parent = c.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            if (parent.isAnnotationPresent(annClass)) {
                found.add(parent.getAnnotation(annClass));
            }
            for (Class<?> interfaceClass : parent.getInterfaces()) {
                if (!interfaceClass.isAnnotationPresent(annClass)) continue;
                found.add(interfaceClass.getAnnotation(annClass));
            }
        }
        for (Class<?> interfaceClass : c.getInterfaces()) {
            if (!interfaceClass.isAnnotationPresent(annClass)) continue;
            found.add(interfaceClass.getAnnotation(annClass));
        }
        return found;
    }

    private static String stripFilenameExtension(String filename) {
        if (filename.indexOf(46) != -1) {
            return filename.substring(0, filename.lastIndexOf(46));
        }
        return filename;
    }

    public static Set<Class<?>> getFromDirectory(File directory, String packageName) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        if (directory.exists()) {
            for (String file : directory.list()) {
                if (!file.endsWith(".class")) continue;
                String name = packageName + '.' + ReflectionUtils.stripFilenameExtension(file);
                Class<?> clazz = Class.forName(name);
                classes.add(clazz);
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Class<?>> getFromJARFile(String jar, String packageName) throws IOException, FileNotFoundException, ClassNotFoundException {
        JarEntry jarEntry;
        HashSet classes = new HashSet();
        FileInputStream stream = new FileInputStream(jar);
        JarInputStream jarFile = new JarInputStream(stream);
        do {
            String className;
            if ((jarEntry = jarFile.getNextJarEntry()) == null || !(className = jarEntry.getName()).endsWith(".class") || !(className = ReflectionUtils.stripFilenameExtension(className)).startsWith(packageName)) continue;
            classes.add(Class.forName(className.replace('/', '.')));
        } while (jarEntry != null);
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            logger.info((Object)"InputStream close failed");
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return classes;
    }

    public static Set<Class<?>> getClasses(String packageName) throws IOException, ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ReflectionUtils.getClasses(loader, packageName);
    }

    public static Set<Class<?>> getClasses(ClassLoader loader, String packageName) throws IOException, ClassNotFoundException {
        HashSet classes = new HashSet();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = loader.getResources(path);
        if (resources != null) {
            while (resources.hasMoreElements()) {
                String filePath = resources.nextElement().getFile();
                if (filePath.indexOf("%20") > 0) {
                    filePath = filePath.replaceAll("%20", " ");
                }
                if (filePath.indexOf("%23") > 0) {
                    filePath = filePath.replaceAll("%23", "#");
                }
                if (filePath == null) continue;
                if (filePath.indexOf("!") > 0 & filePath.indexOf(".jar") > 0) {
                    String jarPath = filePath.substring(0, filePath.indexOf("!")).substring(filePath.indexOf(":") + 1);
                    if (jarPath.indexOf(":") >= 0) {
                        jarPath = jarPath.substring(1);
                    }
                    classes.addAll(ReflectionUtils.getFromJARFile(jarPath, path));
                    continue;
                }
                classes.addAll(ReflectionUtils.getFromDirectory(new File(filePath), packageName));
            }
        }
        return classes;
    }

    public static ArrayList iterToList(Iterable it) {
        if (it instanceof ArrayList) {
            return (ArrayList)it;
        }
        if (it == null) {
            return null;
        }
        ArrayList ar = new ArrayList();
        for (Object o : it) {
            ar.add(o);
        }
        return ar;
    }

    public static Object convertToArray(Class type, List<?> values) {
        Object exampleArray = Array.newInstance(type, values.size());
        try {
            Object[] array = values.toArray((Object[])exampleArray);
            return array;
        }
        catch (ClassCastException e) {
            for (int i = 0; i < values.size(); ++i) {
                Array.set(exampleArray, i, values.get(i));
            }
            return exampleArray;
        }
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectionUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ReflectionUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ReflectionUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static <T> Class<?> getTypeArgument(Class<? extends T> clazz, TypeVariable<? extends GenericDeclaration> tv) {
        HashMap resolvedTypes = new HashMap();
        Type type = clazz;
        while (!ReflectionUtils.getClass(type).equals(Object.class)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (typeParameters[i].equals(tv)) {
                    Class<?> cls = ReflectionUtils.getClass(actualTypeArguments[i]);
                    if (cls != null) {
                        return cls;
                    }
                    return ReflectionUtils.getClass((Type)resolvedTypes.get(actualTypeArguments[i]));
                }
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(Object.class)) continue;
            type = rawType.getGenericSuperclass();
        }
        return null;
    }

    public static <T> boolean isAnnotationPresent(Class c, Class<T> annClass) {
        boolean isHas = c.isAnnotationPresent(annClass);
        if (isHas) {
            return isHas;
        }
        for (Class parent = c.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            if (parent.isAnnotationPresent(annClass)) {
                return true;
            }
            for (Class<?> interfaceClass : parent.getInterfaces()) {
                if (!interfaceClass.isAnnotationPresent(annClass)) continue;
                return true;
            }
        }
        for (Class<?> interfaceClass : c.getInterfaces()) {
            if (!interfaceClass.isAnnotationPresent(annClass)) continue;
            return true;
        }
        return false;
    }
}

