/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.reflect;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.activation.DataHandler;
import org.nbone.constants.SimpleTypeConstant;
import org.nbone.util.reflect.ConverterUtil;

public class SimpleTypeMapper
implements SimpleTypeConstant {
    public static Object getSimpleTypeObject(Class<?> parameter, String text) {
        String name = parameter.getName();
        if (name.equals("java.lang.String")) {
            return text;
        }
        if (text == null || text.length() == 0) {
            return null;
        }
        if (name.equals("int")) {
            return new Integer(text);
        }
        if (name.equals("boolean")) {
            return ConverterUtil.convertToBoolean(text);
        }
        if (name.equals("byte")) {
            return new Byte(text);
        }
        if (name.equals("double")) {
            return new Double(text);
        }
        if (name.equals("short")) {
            return new Short(text);
        }
        if (name.equals("long")) {
            return new Long(text);
        }
        if (name.equals("float")) {
            return new Float(text);
        }
        if (name.equals("char")) {
            return Character.valueOf(text.toCharArray()[0]);
        }
        if (name.equals("java.lang.Integer")) {
            return new Integer(text);
        }
        if (name.equals("java.lang.Boolean")) {
            return Boolean.valueOf(text);
        }
        if (name.equals("java.lang.Byte")) {
            return new Byte(text);
        }
        if (name.equals("java.lang.Double")) {
            return new Double(text);
        }
        if (name.equals("java.lang.Short")) {
            return new Short(text);
        }
        if (name.equals("java.lang.Long")) {
            return new Long(text);
        }
        if (name.equals("java.lang.Float")) {
            return new Float(text);
        }
        if (name.equals("java.lang.Character")) {
            return Character.valueOf(text.toCharArray()[0]);
        }
        if (name.equals(W_CALENDAR)) {
            return SimpleTypeMapper.makeCalendar(text);
        }
        if (name.equals("java.util.Date")) {
            return SimpleTypeMapper.makeDate(text);
        }
        if (name.equals("java.math.BigDecimal")) {
            return new BigDecimal(text);
        }
        if (name.equals("java.math.BigInteger")) {
            return new BigInteger(text);
        }
        if (name.equals(W_URI)) {
            try {
                return new URI(text);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(" Invalid URI " + text, e);
            }
        }
        return null;
    }

    public static boolean isSimpleType(Object obj) {
        String objClassName = obj.getClass().getName();
        return obj instanceof Calendar || obj instanceof Date || SimpleTypeMapper.isSimpleType(objClassName);
    }

    public static boolean isSimpleType(Class<?> obj) {
        String objClassName = obj.getName();
        return SimpleTypeMapper.isSimpleType(objClassName);
    }

    public static boolean isDataHandler(Class<?> obj) {
        return obj.isAssignableFrom(DataHandler.class) && !obj.equals(Object.class);
    }

    public static boolean isHashSet(Class<?> obj) {
        return HashSet.class.isAssignableFrom(obj);
    }

    public static boolean isCollection(Class<?> obj) {
        return Collection.class.isAssignableFrom(obj);
    }

    public static boolean isPrimitiveWithNumber(Class<?> clazz) {
        String objClassName = clazz.getName();
        return SimpleTypeMapper.isPrimitiveWithNumber(objClassName);
    }

    public static boolean isPrimitiveWithNumber(String objClassName) {
        if (objClassName == null) {
            return false;
        }
        if (objClassName.equals("int")) {
            return true;
        }
        if (objClassName.equals("long")) {
            return true;
        }
        if (objClassName.equals("short")) {
            return true;
        }
        if (objClassName.equals("double")) {
            return true;
        }
        if (objClassName.equals("float")) {
            return true;
        }
        if (objClassName.equals("java.lang.Integer")) {
            return true;
        }
        if (objClassName.equals("java.lang.Long")) {
            return true;
        }
        if (objClassName.equals("java.lang.Short")) {
            return true;
        }
        if (objClassName.equals("java.lang.Double")) {
            return true;
        }
        if (objClassName.equals("java.lang.Float")) {
            return true;
        }
        return objClassName.equals("java.math.BigDecimal") || objClassName.equals("java.math.BigInteger");
    }

    public static boolean isPrimitiveWithString(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == String.class || clazz == Character.TYPE || clazz == Character.class;
    }

    public static boolean isPrimitive(String objClassName) {
        if (objClassName == null) {
            return false;
        }
        if (SimpleTypeMapper.isPrimitiveWithNumber(objClassName)) {
            return true;
        }
        if (objClassName.equals("java.lang.String")) {
            return true;
        }
        if (objClassName.equals("boolean")) {
            return true;
        }
        if (objClassName.equals("byte")) {
            return true;
        }
        if (objClassName.equals("char")) {
            return true;
        }
        if (objClassName.equals("java.lang.Boolean")) {
            return true;
        }
        if (objClassName.equals("java.lang.Byte")) {
            return true;
        }
        return objClassName.equals("java.lang.Character");
    }

    public static boolean isSimpleType(String objClassName) {
        if (SimpleTypeMapper.isPrimitive(objClassName)) {
            return true;
        }
        if (objClassName.equals("java.util.Date")) {
            return true;
        }
        if (objClassName.equals(W_URI)) {
            return true;
        }
        if (objClassName.equals(W_CALENDAR)) {
            return true;
        }
        if (objClassName.equals(W_Locale)) {
            return true;
        }
        return objClassName.equals(W_Class);
    }

    public static String getStringValue(Object obj) {
        if (obj instanceof Float || obj instanceof Double) {
            double data = obj instanceof Float ? ((Float)obj).doubleValue() : ((Double)obj).doubleValue();
            if (Double.isNaN(data)) {
                return "NaN";
            }
            if (data == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (data == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return obj.toString();
        }
        if (obj instanceof Calendar) {
            Calendar calendar = (Calendar)obj;
            return ConverterUtil.convertToString(calendar);
        }
        if (obj instanceof Date) {
            SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd");
            return zulu.format(obj);
        }
        if (obj instanceof URI) {
            return obj.toString();
        }
        return obj.toString();
    }

    public static Object makeCalendar(String source) {
        return ConverterUtil.convertToDateTime(source);
    }

    public static Object makeDate(String source) {
        return ConverterUtil.convertToDate(source);
    }
}

