/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileUtil {
    public static String getFileLength(long length) {
        double f = (double)Math.round((double)length / 1024.0 * 100.0) / 100.0;
        if (f < 1024.0) {
            return f + "k";
        }
        f = (double)Math.round(f / 1024.0 * 100.0) / 100.0;
        return f + "M";
    }

    public static String getExtension(String name) {
        int i = name.lastIndexOf(46);
        return i >= 0 ? name.substring(i + 1).toLowerCase() : "";
    }

    public boolean isDir(String name) {
        return new File(name).isDirectory();
    }

    public static String getFileName(String path) {
        try {
            int separatorChar = 47;
            int index = path.lastIndexOf(separatorChar);
            if (index < 0) {
                separatorChar = 92;
                index = path.lastIndexOf(separatorChar);
            }
            return path.substring(index + 1);
        }
        catch (Exception exception) {
            return "Unknown";
        }
    }

    public static String formatPath(String path) {
        return path.replace("\\\\", File.separator).replace("/", File.separator);
    }

    public static void delete(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.delete(files[i]);
                }
            }
            dir.delete();
        } else {
            dir.delete();
        }
    }

    public static void copy(String oldPath, String newPath) throws IOException {
        int bytesum = 0;
        int byteread = 0;
        File oldfile = new File(oldPath);
        if (oldfile.exists()) {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(oldPath);
                out = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)in).read(buffer)) != -1) {
                    bytesum += byteread;
                    out.write(buffer, 0, byteread);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File target) throws IOException {
        if (file.isDirectory()) {
            return;
        }
        FileInputStream fi = null;
        FileOutputStream fo = null;
        try {
            fi = new FileInputStream(file);
            fo = new FileOutputStream(target);
            byte[] buff = new byte[1024];
            int n = 0;
            while ((n = fi.read(buff)) != -1) {
                fo.write(buff, 0, n);
            }
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void cout(String str, int config, String filepath) {
        switch (config) {
            case 1: {
                System.out.println(str);
                break;
            }
            case 2: {
                if (!FileUtil.makefile(filepath)) break;
                try {
                    FileOutputStream fout = new FileOutputStream(filepath, true);
                    String tmp = "\r\n" + str;
                    fout.write(tmp.getBytes());
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                System.out.println(str);
                if (!FileUtil.makefile(filepath)) break;
                try {
                    FileOutputStream fout = new FileOutputStream(filepath, true);
                    String tmp = "\r\n" + str;
                    fout.write(tmp.getBytes());
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    public static void cout(String str) {
        FileUtil.cout(str, 2, "log.txt");
    }

    public static boolean makefile(String path) {
        File file = new File(path);
        if (file.exists()) {
            return true;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean makePath(String path) {
        File dirFile = new File(path);
        if (dirFile.exists()) {
            return true;
        }
        return dirFile.mkdirs();
    }

    public static boolean copyDir(String file1, String file2) throws IOException {
        boolean ret = false;
        new File(file1).mkdirs();
        File[] file = new File(file2).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                int len;
                FileInputStream input = new FileInputStream(file[i]);
                FileOutputStream output = new FileOutputStream(file1 + "/" + file[i].getName());
                byte[] b = new byte[5120];
                while ((len = input.read(b)) != -1) {
                    output.write(b, 0, len);
                }
                output.flush();
                output.close();
                input.close();
            }
            if (file[i].isDirectory()) {
                FileUtil.copyDir(file1 + "/" + file[i].getName(), file2 + "/" + file[i].getName());
            }
            ret = true;
        }
        return ret;
    }

    public static String getRegex(String regex, String source) {
        String des = "";
        Pattern p = Pattern.compile(regex, 32);
        Matcher m = p.matcher(source);
        if (m.find()) {
            des = m.group();
        }
        return des;
    }

    public static String[] splitRegex(String regex, String source) {
        String[] des = null;
        Pattern p = Pattern.compile(regex, 32);
        des = p.split(source);
        return des;
    }

    public static String[] getRegexM(String regex, String source) {
        String[] des = new String[]{};
        Pattern p = Pattern.compile(regex, 32);
        Matcher m = p.matcher(source);
        int n = 0;
        while (m.find()) {
            ++n;
        }
        des = new String[n];
        int i = 0;
        m.find(0);
        do {
            des[i] = m.group();
            ++i;
        } while (m.find());
        return des;
    }

    public static String delRegex(String regex, String source) {
        String des = null;
        Pattern p = Pattern.compile(regex, 32);
        Matcher m = p.matcher(source);
        des = !m.find() ? source : m.replaceAll("");
        return des;
    }

    public static String refreshFileList(String strPath) {
        String fileNames = "";
        File dir = new File(strPath);
        File[] files = dir.listFiles();
        if (files == null) {
            return "";
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileUtil.refreshFileList(files[i].getAbsolutePath());
                continue;
            }
            String strFileName = files[i].getAbsolutePath().toLowerCase();
            fileNames = fileNames + files[i].getName() + ",";
        }
        if (fileNames.indexOf(",") > -1) {
            int index = fileNames.lastIndexOf(",");
            fileNames = fileNames.substring(0, index);
        }
        return fileNames;
    }

    public static String readCnProperties(String propertiesFileName, String key) {
        File file = new File(propertiesFileName);
        String value = "";
        try {
            String text;
            BufferedReader input = new BufferedReader(new FileReader(file));
            while ((text = input.readLine()) != null) {
                String[] textArr;
                if (text.indexOf("=") <= -1 || !key.equals((textArr = text.split("="))[0].trim())) continue;
                value = new String(textArr[1].trim().getBytes(), "UTF-8");
                break;
            }
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public static String readCnProperties(InputStream propertiesInputStream, String key) {
        String value = "";
        try {
            String text;
            BufferedReader input = new BufferedReader(new InputStreamReader(propertiesInputStream));
            while ((text = input.readLine()) != null) {
                String[] textArr;
                if (text.indexOf("=") <= -1 || !key.equals((textArr = text.split("="))[0].trim())) continue;
                value = new String(textArr[1].trim().getBytes(), "UTF-8");
                break;
            }
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String[] sourcefiles, String baseDir) throws IOException {
        if (sourcefiles == null) {
            return;
        }
        ZipInputStream zis = null;
        FileInputStream fis = null;
        FilterInputStream cis = null;
        byte[] buf = new byte[1024];
        FileOutputStream out = null;
        try {
            File base = new File(baseDir);
            if (!base.isDirectory()) {
                base.mkdir();
            }
            for (int i = 0; i < sourcefiles.length; ++i) {
                fis = new FileInputStream(sourcefiles[i]);
                cis = new CheckedInputStream(fis, new Adler32());
                zis = new ZipInputStream(cis);
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    File f = new File(base, entry.getName());
                    if (entry.isDirectory()) {
                        if (f.mkdirs()) continue;
                        throw new IllegalArgumentException("Can't make dir:" + f);
                    }
                    if (!f.getParentFile().exists()) {
                        f.getParentFile().mkdirs();
                    }
                    out = new FileOutputStream(f);
                    int n = 0;
                    while ((n = zis.read(buf)) != -1) {
                        out.write(buf, 0, n);
                    }
                    out.close();
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
            try {
                if (zis != null) {
                    zis.close();
                }
                if (cis != null) {
                    cis.close();
                }
                fis.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void increasedZip(ZipOutputStream zos, byte[] buf, String baseDir, String f) throws IOException {
        File file = new File(baseDir + "/" + f);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] children = file.list();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    FileUtil.increasedZip(zos, buf, baseDir, f + "/" + children[i]);
                }
            }
        } else {
            int j;
            ZipEntry zipentry = new ZipEntry(f);
            zos.putNextEntry(zipentry);
            FileInputStream fis = new FileInputStream(file);
            while ((j = fis.read(buf)) > -1) {
                zos.write(buf, 0, j);
            }
            fis.close();
            zos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String outFileName, String baseDir, String[] sourcefiles) {
        ZipOutputStream zos = null;
        FileOutputStream fos = null;
        FilterOutputStream cos = null;
        byte[] buf = new byte[1024];
        try {
            fos = new FileOutputStream(outFileName);
            cos = new CheckedOutputStream(fos, new Adler32());
            zos = new ZipOutputStream(cos);
            for (int i = 0; i < sourcefiles.length; ++i) {
                FileUtil.increasedZip(zos, buf, baseDir, sourcefiles[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
                if (cos != null) {
                    cos.close();
                }
                fos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void downLoadFile(HttpServletRequest request, HttpServletResponse response, Vector downLoadFiles) throws IOException {
        String filename = "";
        for (int i = 0; i < downLoadFiles.size(); ++i) {
            String filePath = (String)downLoadFiles.elementAt(i);
            int index = filePath.lastIndexOf("\\");
            filename = filePath.substring(index + 1);
            FileInputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(filePath);
                if (request.getHeader("User-Agent").toLowerCase().indexOf("firefox") > 0) {
                    filename = new String(filename.getBytes("UTF-8"), "ISO8859-1");
                } else if (request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0) {
                    filename = URLEncoder.encode(filename, "UTF-8");
                }
                if (!response.isCommitted()) {
                    response.reset();
                }
                response.setContentType("application/x-msdownload");
                response.setHeader("Content-Disposition", "attachment;filename=" + filename);
                int len = 0;
                byte[] bb = new byte[1024];
                out = response.getOutputStream();
                while ((len = in.read(bb)) != -1) {
                    out.write(bb, 0, len);
                }
                continue;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

