/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class HttpFileUpload {
    private List types = new ArrayList();
    private long sizeMax;
    private int sizeThreshold;
    private String encoding;
    private String repositoryPath;
    private String fileName;

    public List getTypes() {
        return this.types;
    }

    public void setTypes(List types) {
        this.types = types;
    }

    public long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List uploadFile2Folder(HttpServletRequest request, String[] fileName) throws Exception {
        return this.uploadFile2Folder(request, "", fileName);
    }

    public List uploadFile2Folder(HttpServletRequest request, String sourceFolder, String[] fileName) throws Exception {
        List fileItems;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        if (this.sizeThreshold != 0) {
            factory.setSizeThreshold(this.sizeThreshold);
        }
        if (this.repositoryPath != null) {
            factory.setRepository(new File(this.repositoryPath));
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        if (sourceFolder == null) {
            sourceFolder = "";
        }
        if (this.sizeMax != 0L) {
            upload.setSizeMax(this.sizeMax);
        }
        if (this.encoding != null) {
            upload.setHeaderEncoding(this.encoding);
        }
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(sourceFolder);
        if (!file.exists()) {
            file.mkdir();
        }
        if ((fileItems = upload.parseRequest(request)) != null && fileItems.size() != 0) {
            Iterator it = fileItems.iterator();
            int i = 0;
            while (it.hasNext()) {
                String name;
                FileItem fi = (FileItem)it.next();
                if (fi.isFormField()) continue;
                String nameDir = name = fi.getName();
                if (name.lastIndexOf("\\") >= 0) {
                    nameDir = name.substring(name.lastIndexOf("\\"));
                }
                String type = null;
                if (nameDir.lastIndexOf(".") >= 0) {
                    type = nameDir.substring(nameDir.lastIndexOf(".") + 1);
                }
                if (fileName != null) {
                    if (fileName[i] != null) {
                        nameDir = fileName[i];
                    }
                    ++i;
                }
                if (type == null || this.isHave(this.types, type)) continue;
                File f = new File(sourceFolder + nameDir);
                fi.write(f);
                list.add(sourceFolder + nameDir);
            }
        }
        return list;
    }

    public boolean isHave(List types, String type) {
        if (types == null || types.size() == 0) {
            return false;
        }
        for (String ty : types) {
            if (!ty.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    public void deleteFileInDisk(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
    }
}

