/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    public static String keySeed = "c32ad1415f6c89fee76d8457c31efb4b";

    public static String encrypt(String content, String keyseed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyseed.getBytes());
        kgen.init(128, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        byte[] byteContent = content.getBytes("utf-8");
        cipher.init(1, key);
        byte[] result = cipher.doFinal(byteContent);
        return AESUtils.byte2hex(result);
    }

    public static byte[] decrypt(byte[] content, String keyseed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyseed.getBytes());
        kgen.init(128, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        byte[] result = cipher.doFinal(AESUtils.hex2byte(content));
        return result;
    }

    public static String decrypt(String content, String keyseed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyseed.getBytes());
        kgen.init(128, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        String result = new String(cipher.doFinal(AESUtils.hex2byte(content.getBytes("UTF-8"))));
        return result.trim();
    }

    public static String encryptForJS(String content, String keyseed) throws Exception {
        SecretKeySpec key = AESUtils.getKeySpecFromBytes(keyseed.toUpperCase());
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        byte[] byteEnc = cipher.doFinal(content.getBytes("UTF-8"));
        return AESUtils.byte2hex(byteEnc);
    }

    public static String decryptForJS(String content, String keyseed) throws Exception {
        SecretKeySpec key = AESUtils.getKeySpecFromBytes(keyseed.toUpperCase());
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(2, key);
        String result = new String(cipher.doFinal(AESUtils.hex2byte(content.getBytes("UTF-8"))));
        return result.trim();
    }

    private static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }

    private static byte[] hex2byte(byte[] b) {
        if (b.length % 2 != 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u662f\u5076\u6570!");
        }
        byte[] b2 = new byte[b.length / 2];
        for (int n = 0; n < b.length; n += 2) {
            String item = new String(b, n, 2);
            b2[n / 2] = (byte)Integer.parseInt(item, 16);
        }
        return b2;
    }

    private static SecretKeySpec getKeySpecFromBytes(String strBytes) throws NoSuchAlgorithmException {
        SecretKeySpec spec = new SecretKeySpec(AESUtils.hex2byte(strBytes.getBytes()), "AES");
        return spec;
    }

    public static void main(String[] args) throws Exception {
        String aes = AESUtils.encrypt("chen", keySeed);
        System.out.println(aes);
        String apString = AESUtils.decrypt(aes, keySeed);
        System.out.println(apString);
    }
}

