/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.security;

import org.nbone.util.security.AbstractASCII;

public class Base64UtilForUniCode
extends AbstractASCII {
    private static final byte[] encodingTable = BASE64_EncodingTable;
    private static final byte[] decodingTable = BASE64_DecodingTable;

    public static byte[] encode(byte[] data, int offset) {
        int realCount = data.length - offset;
        int modulus = realCount % 3;
        byte[] bytes = modulus == 0 ? new byte[4 * realCount / 3] : new byte[4 * (realCount / 3 + 1)];
        int dataLength = data.length - modulus;
        int i = offset;
        int j = 0;
        while (i < dataLength) {
            int a1 = data[i] & 0xFF;
            int a2 = data[i + 1] & 0xFF;
            int a3 = data[i + 2] & 0xFF;
            bytes[j] = encodingTable[a1 >>> 2 & 0x3F];
            bytes[j + 1] = encodingTable[(a1 << 4 | a2 >>> 4) & 0x3F];
            bytes[j + 2] = encodingTable[(a2 << 2 | a3 >>> 6) & 0x3F];
            bytes[j + 3] = encodingTable[a3 & 0x3F];
            i += 3;
            j += 4;
        }
        switch (modulus) {
            case 0: {
                break;
            }
            case 1: {
                int d1 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = d1 << 4 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = 61;
                bytes[bytes.length - 1] = 61;
                break;
            }
            case 2: {
                int d1 = data[data.length - 2] & 0xFF;
                int d2 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = (d1 << 4 | d2 >>> 4) & 0x3F;
                int b3 = d2 << 2 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = encodingTable[b3];
                bytes[bytes.length - 1] = 61;
            }
        }
        return bytes;
    }

    public static byte[] decode(byte[] data) {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        byte[] bytes = (data = Base64UtilForUniCode.discardNonBase64Bytes(data))[data.length - 2] == 61 ? new byte[(data.length / 4 - 1) * 3 + 1] : (data[data.length - 1] == 61 ? new byte[(data.length / 4 - 1) * 3 + 2] : new byte[data.length / 4 * 3]);
        int i = 0;
        int j = 0;
        while (i < data.length - 4) {
            b1 = decodingTable[data[i]];
            b2 = decodingTable[data[i + 1]];
            b3 = decodingTable[data[i + 2]];
            b4 = decodingTable[data[i + 3]];
            bytes[j] = (byte)(b1 << 2 | b2 >> 4);
            bytes[j + 1] = (byte)(b2 << 4 | b3 >> 2);
            bytes[j + 2] = (byte)(b3 << 6 | b4);
            i += 4;
            j += 3;
        }
        if (data[data.length - 2] == 61) {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            bytes[bytes.length - 1] = (byte)(b1 << 2 | b2 >> 4);
        } else if (data[data.length - 1] == 61) {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            b3 = decodingTable[data[data.length - 2]];
            bytes[bytes.length - 2] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 1] = (byte)(b2 << 4 | b3 >> 2);
        } else {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            b3 = decodingTable[data[data.length - 2]];
            b4 = decodingTable[data[data.length - 1]];
            bytes[bytes.length - 3] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 2] = (byte)(b2 << 4 | b3 >> 2);
            bytes[bytes.length - 1] = (byte)(b3 << 6 | b4);
        }
        return bytes;
    }

    public static byte[] decode(String data) {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        byte[] bytes = (data = Base64UtilForUniCode.discardNonBase64Chars(data)).charAt(data.length() - 2) == '=' ? new byte[(data.length() / 4 - 1) * 3 + 1] : (data.charAt(data.length() - 1) == '=' ? new byte[(data.length() / 4 - 1) * 3 + 2] : new byte[data.length() / 4 * 3]);
        int i = 0;
        int j = 0;
        while (i < data.length() - 4) {
            b1 = decodingTable[data.charAt(i)];
            b2 = decodingTable[data.charAt(i + 1)];
            b3 = decodingTable[data.charAt(i + 2)];
            b4 = decodingTable[data.charAt(i + 3)];
            bytes[j] = (byte)(b1 << 2 | b2 >> 4);
            bytes[j + 1] = (byte)(b2 << 4 | b3 >> 2);
            bytes[j + 2] = (byte)(b3 << 6 | b4);
            i += 4;
            j += 3;
        }
        if (data.charAt(data.length() - 2) == '=') {
            b1 = decodingTable[data.charAt(data.length() - 4)];
            b2 = decodingTable[data.charAt(data.length() - 3)];
            bytes[bytes.length - 1] = (byte)(b1 << 2 | b2 >> 4);
        } else if (data.charAt(data.length() - 1) == '=') {
            b1 = decodingTable[data.charAt(data.length() - 4)];
            b2 = decodingTable[data.charAt(data.length() - 3)];
            b3 = decodingTable[data.charAt(data.length() - 2)];
            bytes[bytes.length - 2] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 1] = (byte)(b2 << 4 | b3 >> 2);
        } else {
            b1 = decodingTable[data.charAt(data.length() - 4)];
            b2 = decodingTable[data.charAt(data.length() - 3)];
            b3 = decodingTable[data.charAt(data.length() - 2)];
            b4 = decodingTable[data.charAt(data.length() - 1)];
            bytes[bytes.length - 3] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 2] = (byte)(b2 << 4 | b3 >> 2);
            bytes[bytes.length - 1] = (byte)(b3 << 6 | b4);
        }
        return bytes;
    }

    private static byte[] discardNonBase64Bytes(byte[] data) {
        byte[] temp = new byte[data.length];
        int bytesCopied = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Base64UtilForUniCode.isValidBase64Byte(data[i])) continue;
            temp[bytesCopied++] = data[i];
        }
        byte[] newData = new byte[bytesCopied];
        System.arraycopy(temp, 0, newData, 0, bytesCopied);
        return newData;
    }

    private static String discardNonBase64Chars(String data) {
        StringBuffer sb = new StringBuffer();
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            if (!Base64UtilForUniCode.isValidBase64Byte((byte)data.charAt(i))) continue;
            sb.append(data.charAt(i));
        }
        return sb.toString();
    }

    private static boolean isValidBase64Byte(byte b) {
        if (b == 61) {
            return true;
        }
        if (b < 0 || b >= 128) {
            return false;
        }
        return decodingTable[b] != -1;
    }

    public static String encode(String data, String charset) throws Exception {
        if (data == null || data.length() == 0) {
            return data;
        }
        int offset = 0;
        byte[] result = Base64UtilForUniCode.encode(data.getBytes(charset), offset);
        StringBuffer sb = new StringBuffer(result.length);
        for (int i = 0; i < result.length; ++i) {
            sb.append((char)result[i]);
        }
        return sb.toString();
    }

    public static String decode(String data, String charset) throws Exception {
        if (data == null || data.length() == 0) {
            return data;
        }
        return new String(Base64UtilForUniCode.decode(data), charset);
    }

    public static void main(String[] args) throws Exception {
        String data = "\u6211\u4eec";
        String data1 = Base64UtilForUniCode.encode(data, "Unicode");
        String data2 = Base64UtilForUniCode.decode(data1, "Unicode");
        System.out.println(data);
        System.out.println(data1);
        System.out.println(data2);
    }
}

