/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.security;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAEnDecryptUtil {
    public static byte[] rsaEncrypt(byte[] pubKeyInByte, byte[] data) throws Exception {
        KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubKeyInByte);
        PublicKey pubKey = mykeyFactory.generatePublic(pubSpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, pubKey);
        return cipher.doFinal(data);
    }

    public static byte[] rsaDecrypt(byte[] privKeyInByte, byte[] data) throws Exception {
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privKeyInByte);
        KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privKey = mykeyFactory.generatePrivate(privSpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privKey);
        return cipher.doFinal(data);
    }

    public static byte[] sign(byte[] keyInByte, byte[] source) throws Exception {
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(keyInByte);
        KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privKey = mykeyFactory.generatePrivate(privSpec);
        Signature sig = Signature.getInstance("SHA1withRSA");
        sig.initSign(privKey);
        sig.update(source);
        return sig.sign();
    }

    public static boolean verify(byte[] keyInByte, byte[] source, byte[] sign) throws Exception {
        KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
        Signature sig = Signature.getInstance("SHA1withRSA");
        X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(keyInByte);
        PublicKey pubKey = mykeyFactory.generatePublic(pubSpec);
        sig.initVerify(pubKey);
        sig.update(source);
        return sig.verify(sign);
    }

    public static Object[] giveRSAKeyPairInByte() throws Exception {
        KeyPair newKeyPair = RSAEnDecryptUtil.creatmyKey();
        if (newKeyPair == null) {
            return null;
        }
        Object[] re = new Object[2];
        if (newKeyPair != null) {
            PrivateKey priv = newKeyPair.getPrivate();
            byte[] bpriv = priv.getEncoded();
            PublicKey pub = newKeyPair.getPublic();
            byte[] bpub = pub.getEncoded();
            re[0] = bpriv;
            re[1] = bpub;
            return re;
        }
        return new Object[0];
    }

    public static KeyPair creatmyKey() throws Exception {
        long mySeed = System.currentTimeMillis();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        random.setSeed(mySeed);
        keyGen.initialize(1024, random);
        return keyGen.generateKeyPair();
    }
}

