/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.temp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zip {
    private ZipInputStream zipIn;
    private ZipOutputStream zipOut;
    private ZipEntry zipEntry;
    private int bufSize;
    private byte[] buf;
    private int readedBytes;

    public Zip() {
        this(512);
    }

    public Zip(int bufSize) {
        this.bufSize = bufSize;
        this.buf = new byte[this.bufSize];
    }

    public void doZip(String zipDirectory) {
        File zipDir = new File(zipDirectory);
        String zipFileName = zipDir.getName() + ".zip";
        try {
            this.zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
            this.handleDir(zipDir, this.zipOut);
            this.zipOut.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void handleDir(File dir, ZipOutputStream zipOut) throws IOException {
        File[] files = dir.listFiles();
        if (files.length == 0) {
            this.zipOut.putNextEntry(new ZipEntry(dir.toString() + "/"));
            this.zipOut.closeEntry();
        } else {
            for (File fileName : files) {
                if (fileName.isDirectory()) {
                    this.handleDir(fileName, this.zipOut);
                    continue;
                }
                FileInputStream fileIn = new FileInputStream(fileName);
                this.zipOut.putNextEntry(new ZipEntry(fileName.toString()));
                while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
                    this.zipOut.write(this.buf, 0, this.readedBytes);
                }
                this.zipOut.closeEntry();
            }
        }
    }

    public void unZip(String unZipfileName) {
        try {
            this.zipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(unZipfileName)));
            while ((this.zipEntry = this.zipIn.getNextEntry()) != null) {
                File file = new File(this.zipEntry.getName());
                if (this.zipEntry.isDirectory()) {
                    file.mkdirs();
                } else {
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    FileOutputStream fileOut = new FileOutputStream(file);
                    while ((this.readedBytes = this.zipIn.read(this.buf)) > 0) {
                        fileOut.write(this.buf, 0, this.readedBytes);
                    }
                    fileOut.close();
                }
                this.zipIn.closeEntry();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setBufSize(int bufSize) {
        this.bufSize = bufSize;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            String name = args[1];
            Zip zip = new Zip();
            if (args[0].equals("-zip")) {
                zip.doZip(name);
            } else if (args[0].equals("-unzip")) {
                zip.unZip(name);
            }
        } else {
            System.out.println("Usage:");
            System.out.println("\u538b\u7f29:java Zip -zip directoryName");
            System.out.println("\u89e3\u538b:java Zip -unzip fileName.zip");
            throw new Exception("Arguments error!");
        }
    }
}

