/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.text;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.text.FieldPosition;
import org.nbone.constants.CharsetConstant;
import org.nbone.util.text.BaseFormat;

public class FreemarkerFormat
extends BaseFormat
implements CharsetConstant {
    private static final long serialVersionUID = 3343475495847994770L;
    private static Configuration config;
    private static StringTemplateLoader stringLoader;

    public FreemarkerFormat(String pattern) {
        super(pattern);
    }

    public static String format(String pattern, Object dataModel) {
        FreemarkerFormat temp = new FreemarkerFormat(pattern);
        return temp.format(dataModel);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer out = new StringBuffer();
        try {
            stringLoader.putTemplate(FreemarkerFormat.class.getName(), this.pattern);
            Template template = config.getTemplate(FreemarkerFormat.class.getName(), "UTF-8");
            StringWriter writer = new StringWriter();
            template.process(obj, (Writer)writer);
            out.append(((Object)writer).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    static {
        Configuration cfg = new Configuration();
        cfg.setDefaultEncoding("UTF-8");
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        config = cfg;
        FreemarkerFormat.stringLoader = stringLoader;
    }
}

