/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.text;

import java.text.FieldPosition;
import java.util.Map;
import org.nbone.util.text.BaseFormat;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpringelFormat
extends BaseFormat {
    private static final long serialVersionUID = -7495793606990372291L;
    protected static ExpressionParser elParser;
    protected static ParserContext parserContext;
    protected static ParserContext TEMPLATE_EXPRESSION;

    public SpringelFormat(String pattern) {
        super(pattern);
    }

    public static String format(String pattern, Object dataModel) {
        SpringelFormat temp = new SpringelFormat(pattern);
        return temp.format(dataModel);
    }

    public static <T> T format(String pattern, Class<T> clazz) {
        Expression expression = elParser.parseExpression(pattern);
        Object result = expression.getValue(clazz);
        return (T)result;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        StandardEvaluationContext context = SpringelFormat.createEvaluationContext(obj);
        Expression expression = elParser.parseExpression(this.pattern, parserContext);
        StringBuffer result = (StringBuffer)expression.getValue((EvaluationContext)context, StringBuffer.class);
        return result;
    }

    public static String format(ExpressionParser ep, String pattern, Object dataModel) {
        StandardEvaluationContext context;
        if (ep == null) {
            ep = elParser;
        }
        if ((context = SpringelFormat.createEvaluationContext(dataModel)) == null) {
            return pattern;
        }
        Expression expression = ep.parseExpression(pattern, parserContext);
        String result = (String)expression.getValue((EvaluationContext)context, String.class);
        return result;
    }

    protected static StandardEvaluationContext createEvaluationContext(Object dataModel) {
        StandardEvaluationContext context = null;
        if (dataModel instanceof StandardEvaluationContext) {
            context = (StandardEvaluationContext)dataModel;
            return context;
        }
        if (dataModel instanceof Map) {
            context = new StandardEvaluationContext();
            context.setVariables((Map)dataModel);
            return context;
        }
        return new StandardEvaluationContext();
    }

    static {
        TEMPLATE_EXPRESSION = ParserContext.TEMPLATE_EXPRESSION;
        SpelExpressionParser parser = new SpelExpressionParser();
        TemplateParserContext tpc = new TemplateParserContext("${", "}");
        elParser = parser;
        parserContext = tpc;
    }
}

