/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.text;

import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.nbone.constants.CharsetConstant;
import org.nbone.util.text.BaseFormat;

public class VlocityFormat
extends BaseFormat
implements CharsetConstant {
    private static final long serialVersionUID = 2955656626149507881L;
    private static VelocityEngine ve;

    public VlocityFormat(String pattern) {
        super(pattern);
    }

    public static String format(String pattern, Object dataModel) {
        VlocityFormat temp = new VlocityFormat(pattern);
        return temp.format(dataModel);
    }

    public static String format(Reader reader, Object dataModel) {
        return VlocityFormat.format(ve, reader, dataModel);
    }

    @Override
    public StringBuffer format(Object dataModel, StringBuffer toAppendTo, FieldPosition pos) {
        String temp = VlocityFormat.format(ve, this.pattern, dataModel);
        if (this.pattern.equals(temp)) {
            return new StringBuffer(temp).append(toAppendTo);
        }
        StringBuffer out = new StringBuffer(temp);
        return out;
    }

    public static String format(VelocityEngine ve, String pattern, Object dataModel) {
        Context context;
        if (ve == null) {
            ve = VlocityFormat.ve;
        }
        if ((context = VlocityFormat.createVelocityContext(dataModel)) == null) {
            return pattern;
        }
        StringWriter writer = new StringWriter();
        ve.evaluate(context, (Writer)writer, "logTag", pattern);
        return writer.toString();
    }

    public static String format(VelocityEngine ve, Reader reader, Object dataModel) {
        Context context;
        if (ve == null) {
            ve = VlocityFormat.ve;
        }
        if ((context = VlocityFormat.createVelocityContext(dataModel)) == null) {
            return reader.toString();
        }
        StringWriter writer = new StringWriter();
        ve.evaluate(context, (Writer)writer, "logTag", reader);
        return writer.toString();
    }

    protected static Context createVelocityContext(Object dataModel) {
        Context context = null;
        if (dataModel instanceof Context) {
            context = (Context)dataModel;
            return context;
        }
        if (dataModel instanceof Map) {
            context = new VelocityContext((Map)dataModel);
            return context;
        }
        return null;
    }

    static {
        VelocityEngine ve = new VelocityEngine();
        ve.addProperty("input.encoding", (Object)"UTF-8");
        ve.addProperty("output.encoding", (Object)"UTF-8");
        ve.addProperty("runtime.log.logsystem.class", (Object)"");
        ve.init();
        VlocityFormat.ve = ve;
    }
}

