/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nbone.constants.ContentType;
import org.nbone.util.json.JSONOperUtils;
import org.springframework.util.Assert;

public abstract class SuperHttpServlet
implements ContentType {
    public static final int TransformationType_JSON = 0;
    public static final int TransformationType_XML = 1;
    public static final int TransformationType_HTML = 2;

    public void sendToClient(HttpServletRequest request, HttpServletResponse response, Object object, String contentType, String charset, int transformationType) throws IOException {
        if (contentType == null) {
            contentType = "text/json";
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        Assert.notNull((Object)response, (String)" HttpServletResponse response is null.");
        String contentHead = contentType + ";charset=" + charset;
        response.setContentType(contentHead);
        PrintWriter writer = response.getWriter();
        String strData = "null";
        switch (transformationType) {
            case 0: {
                strData = JSONOperUtils.pojoToJSON(object);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                strData = String.valueOf(object);
                break;
            }
        }
        writer.write(strData);
        writer.flush();
        writer.close();
    }

    protected void sendToClientWithJson(HttpServletRequest request, HttpServletResponse response, Object object) throws IOException {
        this.sendToClient(request, response, object, "text/json", "UTF-8", 0);
    }

    protected void sendToClientWithHtml(HttpServletRequest request, HttpServletResponse response, Object object) throws IOException {
        this.sendToClient(request, response, object, "text/html", "UTF-8", 2);
    }

    public static void sendErrorJson(HttpServletRequest request, HttpServletResponse response, Object object) throws IOException {
    }

    public static void sendJson(HttpServletResponse response, int status, String message) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(status);
        response.getWriter().write(String.format("{\"code\": %s,\"message\": \"%s\"}", status, message));
    }
}

