/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web.context.prepare;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.web.context.prepare.ActionContext;

public class Dispatcher {
    private final Log loger = LogFactory.getLog(this.getClass());
    private ServletContext servletContext;
    private Map<String, String> initParams;
    private static ThreadLocal<Dispatcher> instance = new ThreadLocal();

    public static Dispatcher getInstance() {
        return instance.get();
    }

    public static void setInstance(Dispatcher dispatcher) {
        instance.set(dispatcher);
    }

    public Dispatcher(ServletContext servletContext, Map<String, String> initParams) {
        this.servletContext = servletContext;
        this.initParams = initParams;
    }

    public void init() {
    }

    public Map<String, String> getInitParamsMap() {
        return this.initParams;
    }

    public String getFilterInitParameter(String name) {
        String value = null;
        if (this.initParams.containsKey(name)) {
            value = this.initParams.get(name);
        }
        return value;
    }

    public Map<String, Object> createContextMap(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        HashMap params = new HashMap(request.getParameterMap());
        HashMap<String, Object> extraContext = this.createContextMap(params, request, response, context);
        return extraContext;
    }

    public HashMap<String, Object> createContextMap(Map parameterMap, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("dispatcher.parameters", parameterMap);
        extraContext.put("dispatcher.HttpServletRequest", request);
        extraContext.put("dispatcher.HttpServletResponse", response);
        extraContext.put("dispatcher.ServletContext", servletContext);
        return extraContext;
    }

    public void prepare(HttpServletRequest request, HttpServletResponse response) {
        String encoding = null;
        Locale locale = null;
        if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
            encoding = "UTF-8";
        }
        if (encoding != null) {
            this.applyRequestEncoding(request, encoding);
            this.applyResponseEncoding(response, encoding);
        }
        if (locale != null) {
            response.setLocale(locale);
        }
    }

    private void applyRequestEncoding(HttpServletRequest request, String encoding) {
        try {
            if (!encoding.equals(request.getCharacterEncoding())) {
                request.setCharacterEncoding(encoding);
            }
        }
        catch (Exception e) {
            this.loger.error((Object)("Error setting character encoding to '" + encoding + "' - ignoring."), (Throwable)e);
        }
    }

    private void applyResponseEncoding(HttpServletResponse response, String encoding) {
        try {
            if (!encoding.equals(response.getCharacterEncoding())) {
                response.setCharacterEncoding(encoding);
            }
        }
        catch (Exception e) {
            this.loger.error((Object)("Error setting character encoding to '" + encoding + "' - ignoring."), (Throwable)e);
        }
    }

    public void cleanup() {
        instance.set(null);
        ActionContext.setContext(null);
    }
}

