/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web.context.prepare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.web.context.prepare.ActionContext;
import org.nbone.web.context.prepare.Dispatcher;

public class InitOperations {
    private final Log loger = LogFactory.getLog(this.getClass());

    public Dispatcher initDispatcher(FilterConfig filterConfig) {
        Dispatcher dispatcher = this.createDispatcher(filterConfig);
        dispatcher.init();
        return dispatcher;
    }

    private Dispatcher createDispatcher(FilterConfig filterConfig) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = filterConfig.getInitParameter(name);
            params.put(name, value);
        }
        return new Dispatcher(filterConfig.getServletContext(), params);
    }

    public void cleanup() {
        ActionContext.setContext(null);
    }

    public List<Pattern> buildExcludedPatternsList(Dispatcher dispatcher) {
        String excludePattern = dispatcher.getFilterInitParameter("excludePattern");
        if (excludePattern != null) {
            return this.buildExcludedPatternsList(excludePattern);
        }
        return null;
    }

    private List<Pattern> buildExcludedPatternsList(String patterns) {
        if (null != patterns && patterns.trim().length() != 0) {
            String[] tokens;
            ArrayList<Pattern> list = new ArrayList<Pattern>();
            for (String token : tokens = patterns.split(",")) {
                list.add(Pattern.compile(token.trim()));
            }
            return Collections.unmodifiableList(list);
        }
        return null;
    }
}

