/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web.context.prepare;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.web.context.prepare.ActionContext;
import org.nbone.web.context.prepare.Dispatcher;
import org.nbone.web.util.RequestUtils;

public class PrepareOperations {
    private final Log loger = LogFactory.getLog(this.getClass());
    private ServletContext servletContext;
    private Dispatcher dispatcher;
    public static final String CLEANUP_RECURSION_COUNTER = "__cleanup_recursion_counter";

    public PrepareOperations(ServletContext servletContext, Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.servletContext = servletContext;
    }

    public ActionContext createActionContext(HttpServletRequest request, HttpServletResponse response) {
        ActionContext ctx;
        ActionContext oldContext;
        Integer counter = 1;
        Integer oldCounter = (Integer)request.getAttribute(CLEANUP_RECURSION_COUNTER);
        if (oldCounter != null) {
            counter = oldCounter + 1;
        }
        if ((oldContext = ActionContext.getContext()) != null) {
            ctx = new ActionContext(new HashMap<String, Object>(oldContext.getContextMap()));
        } else {
            Map<String, Object> context = this.dispatcher.createContextMap(request, response, this.servletContext);
            ctx = new ActionContext(context);
        }
        request.setAttribute(CLEANUP_RECURSION_COUNTER, (Object)counter);
        ActionContext.setContext(ctx);
        return ctx;
    }

    public void setEncodingAndLocale(HttpServletRequest request, HttpServletResponse response) {
        this.dispatcher.prepare(request, response);
    }

    public void assignDispatcherToThread() {
        Dispatcher.setInstance(this.dispatcher);
    }

    public void cleanupRequest(HttpServletRequest request) {
        Integer counterVal = (Integer)request.getAttribute(CLEANUP_RECURSION_COUNTER);
        if (counterVal != null) {
            counterVal = counterVal - 1;
            request.setAttribute(CLEANUP_RECURSION_COUNTER, (Object)counterVal);
            if (counterVal > 0) {
                if (this.loger.isDebugEnabled()) {
                    this.loger.debug((Object)("skipping cleanup counter=" + counterVal));
                }
                return;
            }
        }
        ActionContext.setContext(null);
        Dispatcher.setInstance(null);
    }

    public void cleanupDispatcher() {
        if (this.dispatcher == null) {
            throw new NullPointerException("Something is seriously wrong, Dispatcher is not initialized(null).");
        }
        try {
            this.dispatcher.cleanup();
        }
        finally {
            ActionContext.setContext(null);
        }
    }

    public boolean isUrlExcluded(HttpServletRequest request, List<Pattern> excludedPatterns) {
        if (excludedPatterns != null) {
            String uri = RequestUtils.getUri(request);
            for (Pattern pattern : excludedPatterns) {
                if (!pattern.matcher(uri).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

