/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web.context.prepare;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.web.context.prepare.Dispatcher;
import org.nbone.web.context.prepare.InitOperations;
import org.nbone.web.context.prepare.PrepareOperations;

public class ThinkPrepareFilter
implements Filter {
    protected static final String REQUEST_EXCLUDED_FROM_ACTION_MAPPING = ThinkPrepareFilter.class.getName() + ".REQUEST_EXCLUDED_FROM_ACTION_MAPPING";
    protected PrepareOperations prepare;
    protected List<Pattern> excludedPatterns = null;
    protected Log logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        InitOperations init = new InitOperations();
        Dispatcher dispatcher = null;
        try {
            dispatcher = init.initDispatcher(filterConfig);
            this.prepare = new PrepareOperations(filterConfig.getServletContext(), dispatcher);
            this.excludedPatterns = init.buildExcludedPatternsList(dispatcher);
            this.postInit(dispatcher, filterConfig);
        }
        finally {
            init.cleanup();
        }
    }

    protected void postInit(Dispatcher dispatcher, FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            if (this.excludedPatterns != null && this.prepare.isUrlExcluded(request, this.excludedPatterns)) {
                request.setAttribute(REQUEST_EXCLUDED_FROM_ACTION_MAPPING, new Object());
            } else {
                this.prepare.setEncodingAndLocale(request, response);
                this.prepare.createActionContext(request, response);
                this.prepare.assignDispatcherToThread();
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.prepare.cleanupRequest(request);
        }
    }

    public void destroy() {
        this.prepare.cleanupDispatcher();
    }
}

