/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nbone.web.util.RequestUtils;

@WebFilter(urlPatterns={"/*"})
public class TraceFilter
implements Filter {
    private boolean enabled = true;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.enabled && (RequestUtils.isDebug(httpRequest) || RequestUtils.isTrace(httpRequest))) {
            httpResponse.addHeader("X-ServerName", request.getServerName());
            httpResponse.addHeader("X-Server-LocalAddr", request.getLocalAddr());
            httpResponse.addHeader("X-Server-LocalName", request.getLocalName());
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

