/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nbone.constants.CharsetConstant;
import org.nbone.util.WebIOUtils;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvUtils {
    public static final String ENCODING = "encoding";

    public static void exportCsv(HttpServletRequest request, HttpServletResponse response, String csvFileName, List<?> dataList, String[] header, String ... nameMapping) throws IOException {
        String encode = request.getParameter(ENCODING);
        String dataEncoding = response.getHeader(ENCODING);
        if (encode == null) {
            encode = "UTF-8";
        }
        OutputStream os = WebIOUtils.getOutputStream(response, "text/csv;charset=UTF-8", csvFileName);
        if (dataEncoding != null && "UTF-8-BOM".equals(dataEncoding.toUpperCase())) {
            os.write(CharsetConstant.UTF_8_BOM_HEAD);
        }
        OutputStreamWriter writer = new OutputStreamWriter(os, Charset.forName(encode));
        CsvBeanWriter csvWriter = new CsvBeanWriter((Writer)writer, CsvPreference.STANDARD_PREFERENCE);
        csvWriter.writeHeader(header);
        if (nameMapping == null || nameMapping.length == 0) {
            nameMapping = header;
        }
        for (Object item : dataList) {
            csvWriter.write(item, nameMapping);
        }
        csvWriter.close();
    }
}

