/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nbone.web.util.RequestUtils;

public class HttpUtil {
    public static void setCookie(HttpServletResponse resp, String cName, String cValue, int expiry) {
        Cookie cookie = new Cookie(cName, cValue);
        cookie.setMaxAge(expiry);
        resp.addCookie(cookie);
    }

    public static void setCookie(HttpServletResponse resp, String cName, String cValue) {
        int expiry = 31536000;
        Cookie cookie = new Cookie(cName, cValue);
        cookie.setMaxAge(expiry);
        resp.addCookie(cookie);
    }

    public static void setCookieValue(HttpServletRequest req, HttpServletResponse resp, String cName, String cValue) {
        Cookie[] cookie = req.getCookies();
        for (int i = 0; i < cookie.length; ++i) {
            if (cookie[i].getName() == null || !cookie[i].getName().equalsIgnoreCase(cName)) continue;
            cookie[i].setValue(cValue);
            break;
        }
    }

    public static Cookie getCookie(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null || name == null || name.length() == 0) {
            return null;
        }
        Cookie cookie = null;
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            cookie = cookies[i];
            if (req.getServerName().equals(cookie.getDomain())) break;
        }
        return cookie;
    }

    public static void deleteCookie(HttpServletResponse response, Cookie cookie) {
        if (cookie != null) {
            cookie.setPath("/");
            cookie.setValue("");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    public static String getCookieValue(HttpServletRequest req, String cName) {
        Cookie cookie = HttpUtil.getCookie(req, cName);
        String cvalue = null;
        if (cookie != null) {
            cvalue = cookie.getValue();
        }
        return cvalue;
    }

    public static void setNoCache(HttpServletRequest request, HttpServletResponse response) {
        if (request.getProtocol().compareTo("HTTP/1.0") == 0) {
            response.setHeader("Pragma", "no-cache");
        } else if (request.getProtocol().compareTo("HTTP/1.1") == 0) {
            response.setHeader("Cache-Control", "no-cache");
        }
        response.setDateHeader("Expires", 0L);
    }

    public static String getCurrentFullURL(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String query = request.getQueryString();
        if (query != null && !"".equals(query)) {
            url.append('?');
            url.append(query);
        }
        return url.toString();
    }

    public static String getCurrentURLParam(HttpServletRequest request, String paramNames) {
        return HttpUtil.getURLParam(HttpUtil.getCurrentFullURL(request), paramNames);
    }

    public static String getCurrentURLAllParam(HttpServletRequest request) {
        return request.getQueryString();
    }

    public static String getURLParam(String url, String paramNames) {
        if (paramNames == null || "".equals(paramNames)) {
            return null;
        }
        String params = "";
        String[] allparams = HttpUtil.getURLAllParam(url).split("&");
        for (int i = 0; i < allparams.length; ++i) {
            String[] pn = paramNames.split(",");
            for (int j = 0; j < pn.length; ++j) {
                if (!pn[j].equals(allparams[i].split("=")[0])) continue;
                params = params + allparams[i] + "&";
            }
        }
        if (!params.equals("")) {
            params = params.substring(0, params.length() - 1);
        }
        return params;
    }

    public static String getURLAllParam(String url) {
        if (url == null || "".equals(url)) {
            return null;
        }
        String params = "";
        String[] p = url.split("\\?");
        if (p.length == 2) {
            params = p[1];
        } else if (p.length > 2) {
            for (int i = 1; i < p.length; ++i) {
                params = params + p[i] + "?";
            }
            if (!params.equals("")) {
                params = params.substring(0, params.length() - 1);
            }
        }
        return params;
    }

    public static String getRemoteMac(HttpServletRequest request) {
        String address = RequestUtils.getRemoteVerityIP(request);
        String tmpStr = "";
        String tmpMAC = "";
        try {
            Process process = Runtime.getRuntime().exec("nbtstat -a " + address);
            InputStreamReader isReader = new InputStreamReader(process.getInputStream());
            LineNumberReader lnReader = new LineNumberReader(isReader);
            for (int i = 1; i < 100; ++i) {
                tmpStr = lnReader.readLine();
                if (tmpStr == null || tmpStr.indexOf("MAC Address") <= 1) continue;
                tmpMAC = tmpStr.substring(tmpStr.indexOf("MAC Address") + 14, tmpStr.length());
                break;
            }
        }
        catch (IOException ex) {
            return null;
        }
        if (tmpMAC.length() < 17) {
            return null;
        }
        String mac = tmpMAC.substring(0, 2) + "-" + tmpMAC.substring(3, 5) + "-" + tmpMAC.substring(6, 8) + "-" + tmpMAC.substring(9, 11) + "-" + tmpMAC.substring(12, 14) + "-" + tmpMAC.substring(15, 17);
        return mac;
    }

    public static boolean isDomain(String address) {
        int di = address.indexOf(".");
        if (di < 0) {
            return false;
        }
        String one = address.substring(0, di);
        return !one.matches("^[-\\+]?\\d+$");
    }

    public static void exportFile(HttpServletRequest request, HttpServletResponse response, InputStream is, String fileName) throws IOException {
        if (!response.isCommitted()) {
            response.reset();
        }
        response.setContentType("application/unknown;charset=utf-8");
        response.setContentType("text/plain");
        String agent = request.getHeader("user-agent");
        if (agent.indexOf("MSIE") != -1) {
            String temp = URLEncoder.encode(fileName, "UTF-8");
            if (temp.length() > 150) {
                temp = new String(fileName.getBytes("GBK"), "ISO-8859-1");
            }
            response.addHeader("Content-Disposition", "attachment; filename=\"" + temp + "\"");
        } else {
            response.addHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes("utf-8"), "iso-8859-1") + "\"");
        }
        ServletOutputStream outs = response.getOutputStream();
        BufferedInputStream buf = new BufferedInputStream(is);
        int readBytes = 0;
        while ((readBytes = buf.read()) != -1) {
            outs.write(readBytes);
        }
        outs.flush();
        response.setStatus(200);
        response.flushBuffer();
        if (outs != null) {
            outs.close();
        }
        if (buf != null) {
            buf.close();
        }
        if (is != null) {
            is.close();
        }
    }

    public static void exportFile(HttpServletRequest request, HttpServletResponse response, String txt, String fileName) throws IOException {
        if (!response.isCommitted()) {
            response.reset();
        }
        response.setContentType("application/unknown;charset=utf-8");
        response.setContentType("text/plain");
        String agent = request.getHeader("user-agent");
        if (agent.indexOf("MSIE") != -1) {
            String temp = URLEncoder.encode(fileName, "UTF-8");
            if (temp.length() > 150) {
                temp = new String(fileName.getBytes("GBK"), "ISO-8859-1");
            }
            response.addHeader("Content-Disposition", "attachment; filename=\"" + temp + "\"");
        } else {
            response.addHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes("utf-8"), "iso-8859-1") + "\"");
        }
        ServletOutputStream outs = response.getOutputStream();
        outs.write(txt.getBytes());
        outs.flush();
        response.setStatus(200);
        response.flushBuffer();
        if (outs != null) {
            outs.close();
        }
    }
}

