/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web.util;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.nbone.common.model.PageRequest;
import org.nbone.mvc.domain.RequestQuery;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestQueryUtils {
    public static final String[] PAGE_NUM_NAMES = new String[]{"pageNum", "pageNo", "pageNow", "page", "currentPage", "pageNumber"};
    public static final String[] PAGE_SIZE_NAMES = new String[]{"pageSize", "pagesize", "count", "size", "length"};
    public static final String[] ORDER_BY_NAMES = new String[]{"orderBy", "orderby", "sort"};
    public static final String LIMIT = "limit";

    public static void getPageRequest(PageRequest pageRequest) {
        HttpServletRequest request = RequestQueryUtils.getRequest();
        pageRequest.setPageNum(RequestQueryUtils.getPageNum((ServletRequest)request));
        pageRequest.setPageSize(RequestQueryUtils.getPageSize((ServletRequest)request));
        pageRequest.setLimit(RequestQueryUtils.getLimit((ServletRequest)request));
        pageRequest.setOrderBy(RequestQueryUtils.getOrderBy((ServletRequest)request));
    }

    public static RequestQuery getRequestQuery() {
        return RequestQueryUtils.getRequestQuery((ServletRequest)RequestQueryUtils.getRequest());
    }

    public static RequestQuery getRequestQuery(ServletRequest request) {
        Integer pageNum = RequestQueryUtils.getPageNum(request);
        Integer pageSize = RequestQueryUtils.getPageSize(request);
        Integer limit = RequestQueryUtils.getLimit(request);
        String orderBy = RequestQueryUtils.getOrderBy(request);
        RequestQuery requestQuery = new RequestQuery(pageNum, pageSize, limit, orderBy);
        return requestQuery;
    }

    public static Integer getPageNum(ServletRequest request) {
        for (String pageNumKey : PAGE_NUM_NAMES) {
            String pageNum = request.getParameter(pageNumKey);
            if (!StringUtils.hasLength((String)pageNum)) continue;
            return Integer.valueOf(pageNum);
        }
        return 1;
    }

    public static Integer getPageSize(ServletRequest request) {
        for (String pageSizeName : PAGE_SIZE_NAMES) {
            String pageSize = request.getParameter(pageSizeName);
            if (!StringUtils.hasLength((String)pageSize)) continue;
            return Integer.valueOf(pageSize);
        }
        return 20;
    }

    public static Integer getLimit() {
        return RequestQueryUtils.getLimit((ServletRequest)RequestQueryUtils.getRequest());
    }

    public static Integer getLimit(ServletRequest request) {
        String limit = request.getParameter(LIMIT);
        if (StringUtils.hasLength((String)limit)) {
            return Integer.valueOf(limit);
        }
        return null;
    }

    public static String getOrderBy() {
        return RequestQueryUtils.getOrderBy((ServletRequest)RequestQueryUtils.getRequest());
    }

    public static String getOrderBy(ServletRequest request) {
        for (String orderByName : ORDER_BY_NAMES) {
            String orderBy = request.getParameter(orderByName);
            if (!StringUtils.hasLength((String)orderBy)) continue;
            return orderBy;
        }
        return null;
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequest = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequest.getRequest();
        return request;
    }
}

