/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.web.util;

import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    public static final String SERVLET_PATH = "javax.servlet.include.servlet_path";

    public static String getServletPath(HttpServletRequest request) {
        int endIndex;
        int pos;
        String servletPath = request.getServletPath();
        String requestUri = request.getRequestURI();
        if (requestUri != null && servletPath != null && !requestUri.endsWith(servletPath) && (pos = requestUri.indexOf(servletPath)) > -1) {
            servletPath = requestUri.substring(requestUri.indexOf(servletPath));
        }
        if (null != servletPath && !"".equals(servletPath)) {
            return servletPath;
        }
        int startIndex = request.getContextPath().equals("") ? 0 : request.getContextPath().length();
        int n = endIndex = request.getPathInfo() == null ? requestUri.length() : requestUri.lastIndexOf(request.getPathInfo());
        if (startIndex > endIndex) {
            endIndex = startIndex;
        }
        return requestUri.substring(startIndex, endIndex);
    }

    public static String getUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(SERVLET_PATH);
        if (uri != null) {
            return uri;
        }
        uri = RequestUtils.getServletPath(request);
        if (uri != null && !"".equals(uri)) {
            return uri;
        }
        uri = request.getRequestURI();
        return uri.substring(request.getContextPath().length());
    }

    public static String getContextPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    public static String getServerInfo(HttpServletRequest request) {
        String serverInfo = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
        return serverInfo;
    }

    public static String getBasePath(HttpServletRequest request) {
        String path = request.getContextPath();
        String basePath = RequestUtils.getServerInfo(request) + path;
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        return basePath;
    }

    public static String getLocalServerInfo(HttpServletRequest request) {
        return request.getLocalAddr() + ":" + request.getLocalPort();
    }

    public static String getLocalServerNameInfo(HttpServletRequest request) {
        return request.getLocalName() + ":" + request.getLocalPort();
    }

    public static String getRemoteVerityIP(HttpServletRequest request) {
        if (request == null) {
            return "request is null. unknown";
        }
        String remoteAddr = request.getHeader("X-Real-IP");
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static boolean isDebug(HttpServletRequest request) {
        int headerDebug = request.getIntHeader("debug");
        String parameterDebug = request.getParameter("debug");
        return headerDebug == 1 || "1".equals(parameterDebug);
    }

    public static boolean isTrace(HttpServletRequest request) {
        int headerTrace = request.getIntHeader("trace");
        String parameterTrace = request.getParameter("trace");
        return headerTrace == 1 || "1".equals(parameterTrace);
    }
}

