/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.advanced.jmx;

import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.server.NeoServer;
import org.neo4j.server.advanced.AdvancedNeoServer;
import org.neo4j.server.advanced.helpers.AdvancedServerBuilder;
import org.neo4j.server.advanced.jmx.ServerManagement;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.TargetDirectory;

public class ServerManagementTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    @Rule
    public final TargetDirectory.TestDirectory baseDir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldBeAbleToRestartServer() throws Exception {
        String dbDirectory1 = this.baseDir.directory("db1").getAbsolutePath();
        String dbDirectory2 = this.baseDir.directory("db2").getAbsolutePath();
        PropertyFileConfigurator config = new PropertyFileConfigurator(AdvancedServerBuilder.server().usingDatabaseDir(dbDirectory1).createPropertiesFiles(), ConsoleLogger.DEV_NULL);
        NeoServer server = (NeoServer)this.cleanup.add((Object)new AdvancedNeoServer((ConfigurationBuilder)config, (InternalAbstractGraphDatabase.Dependencies)ServerManagementTest.graphDbDependencies()));
        server.start();
        Assert.assertNotNull((Object)server.getDatabase().getGraph());
        Assert.assertEquals((Object)dbDirectory1, (Object)server.getDatabase().getLocation());
        ServerManagementTest.setProperty(config.configuration(), Configurator.DATABASE_LOCATION_PROPERTY_KEY, dbDirectory2);
        ServerManagement bean = new ServerManagement(server);
        bean.restartServer();
        Assert.assertNotNull((Object)server.getDatabase().getGraph());
        Assert.assertEquals((Object)dbDirectory2, (Object)server.getDatabase().getLocation());
    }

    private static GraphDatabaseDependencies graphDbDependencies() {
        return GraphDatabaseDependencies.newDependencies().logging((Logging)new SingleLoggingService(StringLogger.DEV_NULL));
    }

    private static void setProperty(Config config, String key, String value) {
        Map params = config.getParams();
        params.put(key, value);
        config.applyChanges(params);
    }
}

