/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;
import org.neo4j.test.mockito.mock.GraphMock;
import org.neo4j.test.mockito.mock.Link;
import org.neo4j.test.mockito.mock.Properties;
import org.neo4j.test.mockito.mock.Property;

class PathRepresentationTest {
    PathRepresentationTest() {
    }

    @Test
    void shouldHaveLength() {
        Assertions.assertNotNull((Object)PathRepresentationTest.pathrep().length());
    }

    @Test
    void shouldHaveStartNodeLink() {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", PathRepresentationTest.pathrep().startNode());
    }

    @Test
    void shouldHaveEndNodeLink() {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", PathRepresentationTest.pathrep().endNode());
    }

    @Test
    void shouldHaveNodeList() {
        Assertions.assertNotNull((Object)PathRepresentationTest.pathrep().nodes());
    }

    @Test
    void shouldHaveRelationshipList() {
        Assertions.assertNotNull((Object)PathRepresentationTest.pathrep().relationships());
    }

    @Test
    void shouldHaveDirectionList() {
        Assertions.assertNotNull((Object)PathRepresentationTest.pathrep().directions());
    }

    @Test
    void shouldSerialiseToMap() {
        Map repr = RepresentationTestAccess.serialize(PathRepresentationTest.pathrep());
        Assertions.assertNotNull((Object)repr);
        PathRepresentationTest.verifySerialisation(repr);
    }

    private static PathRepresentation<Path> pathrep() {
        Node a = GraphMock.node((long)0L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]);
        Node b = GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]);
        Node c = GraphMock.node((long)2L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]);
        Node d = GraphMock.node((long)3L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]);
        Relationship ab = GraphMock.relationship((long)17L, (Node)a, (String)"LOVES", (Node)b, (Property[])new Property[0]);
        Relationship cb = GraphMock.relationship((long)18L, (Node)c, (String)"HATES", (Node)b, (Property[])new Property[0]);
        Relationship cd = GraphMock.relationship((long)19L, (Node)c, (String)"KNOWS", (Node)d, (Property[])new Property[0]);
        return new PathRepresentation(GraphMock.path((Node)a, (Link[])new Link[]{Link.link((Relationship)ab, (Node)b), Link.link((Relationship)cb, (Node)c), Link.link((Relationship)cd, (Node)d)}));
    }

    public static void verifySerialisation(Map<String, Object> pathrep) {
        Assertions.assertNotNull((Object)pathrep.get("length"));
        int length = Integer.parseInt(pathrep.get("length").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", pathrep.get("start").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", pathrep.get("end").toString());
        Object nodes = pathrep.get("nodes");
        Assertions.assertTrue((boolean)(nodes instanceof List));
        List nodeList = (List)nodes;
        Assertions.assertEquals((int)(length + 1), (int)nodeList.size());
        for (Object node : nodeList) {
            RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", node.toString());
        }
        Object rels = pathrep.get("relationships");
        Assertions.assertTrue((boolean)(rels instanceof List));
        List relList = (List)rels;
        Assertions.assertEquals((int)length, (int)relList.size());
        for (Object rel : relList) {
            RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+", rel.toString());
        }
        Object directions = pathrep.get("directions");
        Assertions.assertTrue((boolean)(directions instanceof List));
        List directionList = (List)directions;
        Assertions.assertEquals((int)length, (int)directionList.size());
        Assertions.assertEquals((Object)"->", (Object)directionList.get(0).toString());
        Assertions.assertEquals((Object)"<-", (Object)directionList.get(1).toString());
        Assertions.assertEquals((Object)"->", (Object)directionList.get(2).toString());
    }
}

