/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.nio.file.Path;
import java.util.Map;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.WebContainerTestUtils;
import org.neo4j.server.configuration.ServerSettings;

public class ConfigFileBuilder {
    private final Path directory;
    private final Map<String, String> config;

    public static ConfigFileBuilder builder(Path directory) {
        return new ConfigFileBuilder(directory);
    }

    private ConfigFileBuilder(Path directory) {
        this.directory = directory;
        this.config = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.data_directory.name(), directory.toAbsolutePath().toString() + "/data", ServerSettings.db_api_path.name(), "http://localhost:7474/db/data/"});
    }

    public Path build() {
        Path path = this.directory.resolve("config");
        WebContainerTestUtils.writeConfigToFile(this.config, (Path)path);
        return path;
    }

    public ConfigFileBuilder withNameValue(String name, String value) {
        this.config.put(name, value);
        return this;
    }

    public ConfigFileBuilder withSetting(Setting<?> setting, String value) {
        this.config.put(setting.name(), value);
        return this;
    }

    public ConfigFileBuilder withoutSetting(Setting<?> setting) {
        this.config.remove(setting.name());
        return this;
    }
}

