/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.server.WebContainerTestUtils;
import org.neo4j.server.configuration.ConfigFileBuilder;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class ConfigLoaderTest {
    @Inject
    private TestDirectory testDirectory;

    ConfigLoaderTest() {
    }

    @Test
    void shouldProvideAConfiguration() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
    }

    @Test
    void shouldUseSpecifiedConfigFile() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        String EXPECTED_VALUE = "bar";
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)((SocketAddress)testConf.get(GraphDatabaseSettings.default_advertised_address)).toString());
    }

    @Test
    void shouldUseSpecifiedHomeDir() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.testDirectory.absolutePath().toString(), (Object)((Path)testConf.get(GraphDatabaseSettings.neo4j_home)).toString());
    }

    @Test
    void shouldUseWorkingDirForHomeDirIfUnspecified() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).build();
        Config testConf = Config.newBuilder().fromFile(configFile).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Path.of(System.getProperty("user.dir"), new String[0]).toAbsolutePath().toString(), (Object)((Path)testConf.get(GraphDatabaseSettings.neo4j_home)).toString());
    }

    @Test
    void shouldAcceptDuplicateKeysWithSameValue() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)testConf);
        String EXPECTED_VALUE = "bar";
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)((SocketAddress)testConf.get(GraphDatabaseSettings.default_advertised_address)).toString());
    }

    @Test
    void loadOfflineConfigShouldDisableBolt() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).withNameValue(BoltConnector.enabled.name(), "true").build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        ConfigUtils.disableAllConnectors((Config)testConf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)testConf);
        org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)testConf.get(BoltConnector.enabled));
    }

    @Test
    void loadOfflineConfigAddDisabledBoltConnector() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        ConfigUtils.disableAllConnectors((Config)testConf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)testConf);
        org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)testConf.get(BoltConnector.enabled));
    }

    @Test
    void shouldFindThirdPartyJaxRsPackages() throws IOException {
        Path file = WebContainerTestUtils.createTempConfigFile((Path)this.testDirectory.homePath());
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            out.write(ServerSettings.third_party_packages.name());
            out.write("=");
            out.write("com.foo.bar=\"mount/point/foo\",");
            out.write("com.foo.baz=\"/bar\",");
            out.write("com.foo.foobarbaz=\"/\"");
            out.write(System.lineSeparator());
        }
        Config config = Config.newBuilder().fromFile(file).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)thirdpartyJaxRsPackages);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)thirdpartyJaxRsPackages.size());
    }

    @Test
    void shouldRetainRegistrationOrderOfThirdPartyJaxRsPackages() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).withNameValue(ServerSettings.third_party_packages.name(), "org.neo4j.extension.extension1=/extension1,org.neo4j.extension.extension2=/extension2,org.neo4j.extension.extension3=/extension3").build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)thirdpartyJaxRsPackages.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/extension1", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(0)).mountPoint());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/extension2", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(1)).mountPoint());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/extension3", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(2)).mountPoint());
    }

    @Test
    void shouldThrowWhenSpecifiedConfigFileDoesNotExist() {
        Path nonExistentConfigFile = Path.of("/tmp/" + System.currentTimeMillis(), new String[0]);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().fromFile(nonExistentConfigFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build());
    }

    @Test
    void shouldWorkFineWhenSpecifiedConfigFileDoesNotExist() {
        Path nonExistentConfigFile = Path.of("/tmp/" + System.currentTimeMillis(), new String[0]);
        Config config = Config.newBuilder().fromFileNoThrow(nonExistentConfigFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
    }

    @Test
    void shouldDefaultToCorrectValueForAuthStoreLocation() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).withoutSetting(GraphDatabaseSettings.data_directory).build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        Assertions.assertThat((Path)((Path)config.get(GraphDatabaseInternalSettings.auth_store_directory))).isEqualTo((Object)this.testDirectory.homePath().resolve("data").resolve("dbms").toAbsolutePath());
    }

    @Test
    void shouldSetAValueForAuthStoreLocation() {
        Path configFile = ConfigFileBuilder.builder(this.testDirectory.homePath()).withSetting(GraphDatabaseSettings.data_directory, "the-data-dir").build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        Assertions.assertThat((Path)((Path)config.get(GraphDatabaseInternalSettings.auth_store_directory))).isEqualTo((Object)this.testDirectory.homePath().resolve("the-data-dir").resolve("dbms").toAbsolutePath());
    }
}

