/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.util.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;
import org.neo4j.test.server.HTTP;

class AuthorizationHeadersTest {
    AuthorizationHeadersTest() {
    }

    @Test
    void shouldParseHappyPath() {
        String username = "jake";
        String password = "qwerty123456";
        String header = HTTP.basicAuthHeader((String)username, (String)password);
        String[] parsed = AuthorizationHeaders.decode((String)header);
        Assertions.assertEquals((Object)username, (Object)parsed[0]);
        Assertions.assertEquals((Object)password, (Object)parsed[1]);
    }

    @Test
    void shouldHandleSadPaths() {
        Assertions.assertNull((Object)AuthorizationHeaders.decode((String)""));
        Assertions.assertNull((Object)AuthorizationHeaders.decode((String)"Basic"));
        Assertions.assertNull((Object)AuthorizationHeaders.decode((String)"Basic not valid value"));
        Assertions.assertNull((Object)AuthorizationHeaders.decode((String)("Basic " + Base64.getEncoder().encodeToString("".getBytes()))));
    }
}

