/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.batchinsert.internal.FileSystemClosingBatchInserter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProviderFactory;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class BatchInsertersTest {
    @Inject
    private DatabaseLayout databaseLayout;

    BatchInsertersTest() {
    }

    @Test
    void automaticallyCloseCreatedFileSystemOnShutdown() throws Exception {
        BatchInsertersTest.verifyInserterFileSystemClose(BatchInserters.inserter((DatabaseLayout)this.databaseLayout));
        BatchInsertersTest.verifyInserterFileSystemClose(BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (Config)BatchInsertersTest.getConfig()));
        BatchInsertersTest.verifyInserterFileSystemClose(BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (Config)BatchInsertersTest.getConfig(), BatchInsertersTest.getExtensions()));
    }

    @Test
    void providedFileSystemNotClosedAfterShutdown() throws IOException {
        try (EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();){
            BatchInsertersTest.verifyProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fs), fs);
            BatchInsertersTest.verifyProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fs, (Config)BatchInsertersTest.getConfig()), fs);
            BatchInsertersTest.verifyProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fs, (Config)BatchInsertersTest.getConfig(), BatchInsertersTest.getExtensions()), fs);
        }
    }

    private static Iterable<ExtensionFactory<?>> getExtensions() {
        return Iterables.asIterable((Object[])new ExtensionFactory[]{new GenericNativeIndexProviderFactory()});
    }

    private static Config getConfig() {
        return Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName());
    }

    private static void verifyProvidedFileSystemOpenAfterShutdown(BatchInserter inserter, EphemeralFileSystemAbstraction fileSystemAbstraction) {
        inserter.shutdown();
        Assertions.assertFalse((boolean)fileSystemAbstraction.isClosed());
    }

    private static void verifyInserterFileSystemClose(BatchInserter inserter) {
        MatcherAssert.assertThat((String)"Expect specific implementation that will do required cleanups.", (Object)inserter, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(FileSystemClosingBatchInserter.class)));
        inserter.shutdown();
    }
}

