/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexValueTestUtil;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

@Neo4jLayoutExtension
class BatchInsertIndexTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;
    private Config.Builder configBuilder;
    private DatabaseManagementService managementService;

    BatchInsertIndexTest() {
    }

    @BeforeEach
    void setUp() {
        this.configBuilder = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath());
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @ParameterizedTest
    @EnumSource(value=GraphDatabaseSettings.SchemaIndex.class)
    void batchInserterShouldUseConfiguredIndexProvider(GraphDatabaseSettings.SchemaIndex schemaIndex) throws Exception {
        this.configure(schemaIndex);
        BatchInserter inserter = this.newBatchInserter();
        inserter.createDeferredSchemaIndex(TestLabels.LABEL_ONE).on("key").create();
        inserter.shutdown();
        GraphDatabaseService db = this.startGraphDatabaseServiceAndAwaitIndexes();
        try (Transaction tx = db.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)tx).kernelTransaction();
            TokenRead tokenRead = kernelTransaction.tokenRead();
            SchemaRead schemaRead = kernelTransaction.schemaRead();
            int labelId = tokenRead.nodeLabel(TestLabels.LABEL_ONE.name());
            int propertyId = tokenRead.propertyKey("key");
            IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{propertyId})));
            Assertions.assertTrue((boolean)schemaIndex.providerName().contains(index.getIndexProvider().getKey()), (String)BatchInsertIndexTest.unexpectedIndexProviderMessage(index));
            Assertions.assertTrue((boolean)schemaIndex.providerName().contains(index.getIndexProvider().getVersion()), (String)BatchInsertIndexTest.unexpectedIndexProviderMessage(index));
            tx.commit();
        }
    }

    @ParameterizedTest
    @EnumSource(value=GraphDatabaseSettings.SchemaIndex.class)
    void shouldPopulateIndexWithUniquePointsThatCollideOnSpaceFillingCurve(GraphDatabaseSettings.SchemaIndex schemaIndex) throws Exception {
        this.configure(schemaIndex);
        BatchInserter inserter = this.newBatchInserter();
        Pair collidingPoints = SpatialIndexValueTestUtil.pointsWithSameValueOnSpaceFillingCurve((Config)this.configBuilder.build());
        inserter.createNode(MapUtil.map((Object[])new Object[]{"prop", collidingPoints.first()}), new Label[]{TestLabels.LABEL_ONE});
        inserter.createNode(MapUtil.map((Object[])new Object[]{"prop", collidingPoints.other()}), new Label[]{TestLabels.LABEL_ONE});
        inserter.createDeferredConstraint(TestLabels.LABEL_ONE).assertPropertyIsUnique("prop").create();
        inserter.shutdown();
        GraphDatabaseService db = this.startGraphDatabaseServiceAndAwaitIndexes();
        try (Transaction tx = db.beginTx();){
            BatchInsertIndexTest.assertSingleCorrectHit((PointValue)collidingPoints.first(), tx);
            BatchInsertIndexTest.assertSingleCorrectHit((PointValue)collidingPoints.other(), tx);
            tx.commit();
        }
    }

    @ParameterizedTest
    @EnumSource(value=GraphDatabaseSettings.SchemaIndex.class)
    void shouldThrowWhenPopulatingWithNonUniquePoints(GraphDatabaseSettings.SchemaIndex schemaIndex) throws Exception {
        this.configure(schemaIndex);
        BatchInserter inserter = this.newBatchInserter();
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        inserter.createNode(MapUtil.map((Object[])new Object[]{"prop", point}), new Label[]{TestLabels.LABEL_ONE});
        inserter.createNode(MapUtil.map((Object[])new Object[]{"prop", point}), new Label[]{TestLabels.LABEL_ONE});
        inserter.createDeferredConstraint(TestLabels.LABEL_ONE).assertPropertyIsUnique("prop").create();
        inserter.shutdown();
        GraphDatabaseService db = this.startGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            Assertions.assertThrows(IllegalStateException.class, () -> tx.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS));
        }
        tx = db.beginTx();
        try {
            Schema schema = tx.schema();
            Iterator indexes = schema.getIndexes().iterator();
            Assertions.assertTrue((boolean)indexes.hasNext());
            IndexDefinition index = (IndexDefinition)indexes.next();
            Schema.IndexState indexState = schema.getIndexState(index);
            Assertions.assertEquals((Object)Schema.IndexState.FAILED, (Object)indexState);
            Assertions.assertFalse((boolean)indexes.hasNext());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void creatingFulltextIndexIsUnsupported() throws Exception {
        try (BatchInserter inserter = this.newBatchInserter();){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> inserter.createDeferredSchemaIndex(TestLabels.LABEL_ONE).on("key").withIndexType(IndexType.FULLTEXT).withName("fts").create());
        }
    }

    @Test
    void creatingIndexesWithCustomConfigurationsIsUnsupported() throws Exception {
        try (BatchInserter inserter = this.newBatchInserter();){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> inserter.createDeferredSchemaIndex(TestLabels.LABEL_ONE).on("key").withIndexConfiguration(Map.of(IndexSettingImpl.SPATIAL_CARTESIAN_MAX, new double[]{0.0, 0.0})).create());
        }
    }

    @Test
    void creatingUniquenessConstraintWithIndexTypeIsUnsupported() throws Exception {
        try (BatchInserter inserter = this.newBatchInserter();){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> inserter.createDeferredConstraint(TestLabels.LABEL_ONE).assertPropertyIsUnique("key").withIndexType(IndexType.BTREE).create());
        }
    }

    @Test
    void creatingNodeKeyConstraintWithIndexTypeIsUnsupported() throws Exception {
        try (BatchInserter inserter = this.newBatchInserter();){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> inserter.createDeferredConstraint(TestLabels.LABEL_ONE).assertPropertyIsNodeKey("key").withIndexType(IndexType.BTREE).create());
        }
    }

    private void configure(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.configBuilder = this.configBuilder.set(GraphDatabaseSettings.default_schema_provider, (Object)schemaIndex.providerName());
    }

    private static void assertSingleCorrectHit(PointValue point, Transaction tx) {
        ResourceIterator nodes = tx.findNodes(TestLabels.LABEL_ONE, "prop", (Object)point);
        Assertions.assertTrue((boolean)nodes.hasNext());
        Node node = (Node)nodes.next();
        Object prop = node.getProperty("prop");
        Assertions.assertEquals((Object)point, (Object)prop);
        Assertions.assertFalse((boolean)nodes.hasNext());
    }

    private BatchInserter newBatchInserter() throws Exception {
        return BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (Config)this.configBuilder.build());
    }

    private GraphDatabaseService startGraphDatabaseServiceAndAwaitIndexes() {
        GraphDatabaseService database = this.startGraphDatabaseService();
        this.awaitIndexesOnline(database);
        return database;
    }

    private GraphDatabaseService startGraphDatabaseService() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).setFileSystem(this.fs).setConfig(this.configBuilder.build()).build();
        return this.managementService.database("neo4j");
    }

    private void awaitIndexesOnline(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.commit();
        }
    }

    private static String unexpectedIndexProviderMessage(IndexDescriptor index) {
        return "Unexpected provider: key=" + index.getIndexProvider().getKey() + ", version=" + index.getIndexProvider().getVersion();
    }
}

