/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.batchinsert.internal.BatchInserterImpl;
import org.neo4j.batchinsert.internal.BatchRelationship;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.LabelScanReader;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.NativeLabelScanStore;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.mockito.matcher.CollectionMatcher;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@PageCacheExtension
@Neo4jLayoutExtension
class BatchInsertTest {
    private static final IndexProviderDescriptor DESCRIPTOR = TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR;
    private static final String KEY = DESCRIPTOR.getKey();
    private static final String INTERNAL_LOG_FILE = "debug.log";
    private static final IndexDescriptor internalIndex = TestIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
    private static final IndexDescriptor internalUniqueIndex = TestIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{0});
    private static final Map<String, Object> properties = new HashMap<String, Object>();
    private static final RelationshipType[] relTypeArray = new RelationshipType[]{RelTypes.REL_TYPE1, RelTypes.REL_TYPE2, RelTypes.REL_TYPE3, RelTypes.REL_TYPE4, RelTypes.REL_TYPE5};
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;

    BatchInsertTest() {
    }

    private static Stream<Arguments> params() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{5}), Arguments.arguments((Object[])new Object[]{GraphDatabaseSettings.dense_node_threshold.defaultValue()}));
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldUpdateStringArrayPropertiesOnNodesUsingBatchInserter1(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        String[] array1 = new String[]{"1"};
        String[] array2 = new String[]{"a"};
        long id1 = inserter.createNode(MapUtil.map((Object[])new Object[]{"array", array1}), new Label[0]);
        long id2 = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[0]);
        inserter.getNodeProperties(id1).get("array");
        inserter.setNodeProperty(id1, "array", (Object)array1);
        inserter.setNodeProperty(id2, "array", (Object)array2);
        inserter.getNodeProperties(id1).get("array");
        inserter.setNodeProperty(id1, "array", (Object)array1);
        inserter.setNodeProperty(id2, "array", (Object)array2);
        MatcherAssert.assertThat(inserter.getNodeProperties(id1).get("array"), (Matcher)CoreMatchers.equalTo((Object)array1));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testSimple(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node1 = inserter.createNode(null, new Label[0]);
        long node2 = inserter.createNode(null, new Label[0]);
        long rel1 = inserter.createRelationship(node1, node2, (RelationshipType)RelTypes.BATCH_TEST, null);
        BatchRelationship rel = inserter.getRelationshipById(rel1);
        Assertions.assertEquals((long)rel.getStartNode(), (long)node1);
        Assertions.assertEquals((long)rel.getEndNode(), (long)node2);
        Assertions.assertEquals((Object)RelTypes.BATCH_TEST.name(), (Object)rel.getType().name());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testSetAndAddNodeProperties(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long tehNode = inserter.createNode(MapUtil.map((Object[])new Object[]{"one", "one", "two", "two", "three", "three"}), new Label[0]);
        inserter.setNodeProperty(tehNode, "four", (Object)"four");
        inserter.setNodeProperty(tehNode, "five", (Object)"five");
        Map<String, Object> props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        Assertions.assertEquals((int)5, (int)props.size());
        Assertions.assertEquals((Object)"one", (Object)props.get("one"));
        Assertions.assertEquals((Object)"five", (Object)props.get("five"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void setSingleProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(null, new Label[0]);
        String value = "Something";
        String key = "name";
        inserter.setNodeProperty(node, key, (Object)value);
        GraphDatabaseAPI db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        MatcherAssert.assertThat((Object)BatchInsertTest.getNodeInTx(node, (GraphDatabaseService)db), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)key).withValue((Object)value)));
        this.managementService.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testSetAndKeepNodeProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long tehNode = inserter.createNode(MapUtil.map((Object[])new Object[]{"foo", "bar"}), new Label[0]);
        inserter.setNodeProperty(tehNode, "foo2", (Object)"bar2");
        Map<String, Object> props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        Assertions.assertEquals((int)2, (int)props.size());
        Assertions.assertEquals((Object)"bar", (Object)props.get("foo"));
        Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        Assertions.assertEquals((int)2, (int)props.size());
        Assertions.assertEquals((Object)"bar", (Object)props.get("foo"));
        Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.setNodeProperty(tehNode, "foo", (Object)"bar3");
        props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assertions.assertEquals((int)2, (int)props.size());
        Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assertions.assertEquals((int)2, (int)props.size());
        Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testSetAndKeepRelationshipProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long from = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long to = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long theRel = inserter.createRelationship(from, to, RelationshipType.withName((String)"TestingPropsHere"), MapUtil.map((Object[])new Object[]{"foo", "bar"}));
        inserter.setRelationshipProperty(theRel, "foo2", (Object)"bar2");
        Map<String, Object> props = BatchInsertTest.getRelationshipProperties(inserter, theRel);
        Assertions.assertEquals((int)2, (int)props.size());
        Assertions.assertEquals((Object)"bar", (Object)props.get("foo"));
        Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        props = BatchInsertTest.getRelationshipProperties(inserter, theRel);
        Assertions.assertEquals((int)2, (int)props.size());
        Assertions.assertEquals((Object)"bar", (Object)props.get("foo"));
        Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.setRelationshipProperty(theRel, "foo", (Object)"bar3");
        props = BatchInsertTest.getRelationshipProperties(inserter, theRel);
        Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assertions.assertEquals((int)2, (int)props.size());
        Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        props = BatchInsertTest.getRelationshipProperties(inserter, theRel);
        Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assertions.assertEquals((int)2, (int)props.size());
        Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testNodeHasProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long theNode = inserter.createNode(properties, new Label[0]);
        long anotherNode = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long relationship = inserter.createRelationship(theNode, anotherNode, RelationshipType.withName((String)"foo"), properties);
        for (String key : properties.keySet()) {
            Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            Assertions.assertFalse((boolean)inserter.nodeHasProperty(theNode, key + "-"));
            Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
            Assertions.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key + "-"));
        }
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testRemoveProperties(int denseNodeThreshold) throws Exception {
        String key;
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long theNode = inserter.createNode(properties, new Label[0]);
        long anotherNode = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long relationship = inserter.createRelationship(theNode, anotherNode, RelationshipType.withName((String)"foo"), properties);
        inserter.removeNodeProperty(theNode, "key0");
        inserter.removeRelationshipProperty(relationship, "key1");
        Iterator<String> iterator = properties.keySet().iterator();
        block16: while (iterator.hasNext()) {
            switch (key = iterator.next()) {
                case "key0": {
                    Assertions.assertFalse((boolean)inserter.nodeHasProperty(theNode, key));
                    Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block16;
                }
                case "key1": {
                    Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
                    Assertions.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block16;
                }
            }
            Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
        }
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        iterator = properties.keySet().iterator();
        block17: while (iterator.hasNext()) {
            switch (key = iterator.next()) {
                case "key0": {
                    Assertions.assertFalse((boolean)inserter.nodeHasProperty(theNode, key));
                    Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block17;
                }
                case "key1": {
                    Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
                    Assertions.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block17;
                }
            }
            Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
        }
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldBeAbleToRemoveDynamicProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        String key = "tags";
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{key, new String[]{"one", "two", "three"}}), new Label[0]);
        inserter.removeNodeProperty(nodeId, key);
        Assertions.assertFalse((boolean)inserter.getNodeProperties(nodeId).containsKey(key));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldBeAbleToOverwriteDynamicProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        String key = "tags";
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{key, new String[]{"one", "two", "three"}}), new Label[0]);
        Object[] secondValue = new String[]{"four", "five", "six"};
        inserter.setNodeProperty(nodeId, key, (Object)secondValue);
        Assertions.assertArrayEquals((Object[])secondValue, (Object[])((String[])BatchInsertTest.getNodeProperties(inserter, nodeId).get(key)));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testMore(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long startNode = inserter.createNode(properties, new Label[0]);
        long[] endNodes = new long[25];
        HashSet<Long> rels = new HashSet<Long>();
        for (int i = 0; i < 25; ++i) {
            endNodes[i] = inserter.createNode(properties, new Label[0]);
            rels.add(inserter.createRelationship(startNode, endNodes[i], relTypeArray[i % 5], properties));
        }
        for (BatchRelationship rel : inserter.getRelationships(startNode)) {
            Assertions.assertTrue((boolean)rels.contains(rel.getId()));
            Assertions.assertEquals((long)rel.getStartNode(), (long)startNode);
        }
        inserter.setNodeProperties(startNode, properties);
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"params"})
    void makeSureLoopsCanBeCreated(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long startNode = inserter.createNode(properties, new Label[0]);
        long otherNode = inserter.createNode(properties, new Label[0]);
        long selfRelationship = inserter.createRelationship(startNode, startNode, relTypeArray[0], properties);
        long relationship = inserter.createRelationship(startNode, otherNode, relTypeArray[0], properties);
        for (BatchRelationship rel : inserter.getRelationships(startNode)) {
            if (rel.getId() == selfRelationship) {
                Assertions.assertEquals((long)startNode, (long)rel.getStartNode());
                Assertions.assertEquals((long)startNode, (long)rel.getEndNode());
                continue;
            }
            if (rel.getId() == relationship) {
                Assertions.assertEquals((long)startNode, (long)rel.getStartNode());
                Assertions.assertEquals((long)otherNode, (long)rel.getEndNode());
                continue;
            }
            Assertions.fail((String)("Unexpected relationship " + rel.getId()));
        }
        GraphDatabaseAPI db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try (Transaction transaction = db.beginTx();){
            Node realStartNode = transaction.getNodeById(startNode);
            Relationship realSelfRelationship = transaction.getRelationshipById(selfRelationship);
            Relationship realRelationship = transaction.getRelationshipById(relationship);
            Assertions.assertEquals((Object)realSelfRelationship, (Object)realStartNode.getSingleRelationship((RelationshipType)RelTypes.REL_TYPE1, Direction.INCOMING));
            Assertions.assertEquals((Object)Iterators.asSet((Object[])new Relationship[]{realSelfRelationship, realRelationship}), (Object)Iterables.asSet((Iterable)realStartNode.getRelationships(Direction.OUTGOING)));
            Assertions.assertEquals((Object)Iterators.asSet((Object[])new Relationship[]{realSelfRelationship, realRelationship}), (Object)Iterables.asSet((Iterable)realStartNode.getRelationships()));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void createBatchNodeAndRelationshipsDeleteAllInEmbedded(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long nodeId = inserter.createNode(null, new Label[0]);
        inserter.createRelationship(nodeId, inserter.createNode(null, new Label[0]), (RelationshipType)RelTypes.BATCH_TEST, null);
        inserter.createRelationship(inserter.createNode(null, new Label[0]), nodeId, (RelationshipType)RelTypes.REL_TYPE1, null);
        GraphDatabaseAPI db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try (Transaction tx = db.beginTx();){
            Node node = tx.getNodeById(nodeId);
            for (Relationship relationship : node.getRelationships()) {
                relationship.delete();
            }
            node.delete();
            tx.commit();
        }
        this.managementService.shutdown();
    }

    @Test
    void messagesLogGetsClosed() throws IOException {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (Config)Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()));
        inserter.shutdown();
        Assertions.assertTrue((boolean)new File(this.databaseLayout.getNeo4jLayout().homeDirectory(), INTERNAL_LOG_FILE).delete());
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void createEntitiesWithEmptyPropertiesMap(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[0]);
        BatchInsertTest.getNodeProperties(inserter, nodeId);
        long anotherNodeId = inserter.createNode(null, new Label[0]);
        long relId = inserter.createRelationship(nodeId, anotherNodeId, (RelationshipType)RelTypes.BATCH_TEST, MapUtil.map((Object[])new Object[0]));
        inserter.getRelationshipProperties(relId);
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void createEntitiesWithDynamicPropertiesMap(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        BatchInsertTest.setAndGet(inserter, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        BatchInsertTest.setAndGet(inserter, BatchInsertTest.intArray());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldAddInitialLabelsToCreatedNode(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[]{Labels.FIRST, Labels.SECOND});
        Assertions.assertTrue((boolean)inserter.nodeHasLabel(node, (Label)Labels.FIRST));
        Assertions.assertTrue((boolean)inserter.nodeHasLabel(node, (Label)Labels.SECOND));
        Assertions.assertFalse((boolean)inserter.nodeHasLabel(node, (Label)Labels.THIRD));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldGetNodeLabels(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[]{Labels.FIRST, Labels.THIRD});
        Iterable<String> labelNames = BatchInsertTest.asNames(inserter.getNodeLabels(node));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{Labels.FIRST.name(), Labels.THIRD.name()}), (Object)Iterables.asSet(labelNames));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldAddManyInitialLabelsAsDynamicRecords(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        Pair<Label[], Set<String>> labels = BatchInsertTest.manyLabels(200);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), (Label[])labels.first());
        BatchInsertTest.forceFlush(inserter);
        Iterable<String> labelNames = BatchInsertTest.asNames(inserter.getNodeLabels(node));
        Assertions.assertEquals((Object)labels.other(), (Object)Iterables.asSet(labelNames));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldReplaceExistingInlinedLabelsWithDynamic(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[]{Labels.FIRST});
        Pair<Label[], Set<String>> labels = BatchInsertTest.manyLabels(100);
        inserter.setNodeLabels(node, (Label[])labels.first());
        Iterable<String> labelNames = BatchInsertTest.asNames(inserter.getNodeLabels(node));
        Assertions.assertEquals((Object)labels.other(), (Object)Iterables.asSet(labelNames));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldReplaceExistingDynamicLabelsWithInlined(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), (Label[])BatchInsertTest.manyLabels(150).first());
        inserter.setNodeLabels(node, new Label[]{Labels.FIRST});
        Iterable<String> labelNames = BatchInsertTest.asNames(inserter.getNodeLabels(node));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{Labels.FIRST.name()}), (Object)Iterables.asSet(labelNames));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldCreateDeferredSchemaIndexesInEmptyDatabase(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        IndexDefinition definition = inserter.createDeferredSchemaIndex(Label.label((String)"Hacker")).on("handle").create();
        Assertions.assertEquals((Object)"Hacker", (Object)((Label)Iterables.single((Iterable)definition.getLabels())).name());
        Assertions.assertEquals((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object)"handle")), (Object)Iterables.asCollection((Iterable)definition.getPropertyKeys()));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldCreateDeferredUniquenessConstraintInEmptyDatabase(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        ConstraintDefinition definition = inserter.createDeferredConstraint(Label.label((String)"Hacker")).assertPropertyIsUnique("handle").create();
        Assertions.assertEquals((Object)"Hacker", (Object)definition.getLabel().name());
        Assertions.assertEquals((Object)ConstraintType.UNIQUENESS, (Object)definition.getConstraintType());
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"handle"}), (Object)Iterables.asSet((Iterable)definition.getPropertyKeys()));
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldCreateConsistentUniquenessConstraint(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        inserter.createDeferredConstraint(Label.label((String)"Hacker")).assertPropertyIsUnique("handle").create();
        GraphDatabaseAPI graphdb = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try {
            ConstraintDescriptor constraint;
            IndexDescriptor indexRule;
            NeoStores neoStores = ((RecordStorageEngine)graphdb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
            SchemaStore store = neoStores.getSchemaStore();
            TokenHolders tokenHolders = (TokenHolders)graphdb.getDependencyResolver().resolveDependency(TokenHolders.class);
            SchemaRuleAccess schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess((SchemaStore)store, (TokenHolders)tokenHolders);
            ArrayList<Long> inUse = new ArrayList<Long>();
            SchemaRecord record = (SchemaRecord)store.newRecord();
            long high = store.getHighestPossibleIdInUse();
            for (long i = 1L; i <= high; ++i) {
                store.getRecord(i, (AbstractBaseRecord)record, RecordLoad.FORCE);
                if (!record.inUse()) continue;
                inUse.add(i);
            }
            Assertions.assertEquals((int)2, (int)inUse.size(), (String)"records in use");
            SchemaRule rule0 = schemaRuleAccess.loadSingleSchemaRule(((Long)inUse.get(0)).longValue());
            SchemaRule rule1 = schemaRuleAccess.loadSingleSchemaRule(((Long)inUse.get(1)).longValue());
            if (rule0 instanceof IndexDescriptor) {
                indexRule = (IndexDescriptor)rule0;
                constraint = (ConstraintDescriptor)rule1;
            } else {
                constraint = (ConstraintDescriptor)rule0;
                indexRule = (IndexDescriptor)rule1;
            }
            OptionalLong owningConstraintId = indexRule.getOwningConstraintId();
            Assertions.assertTrue((boolean)owningConstraintId.isPresent(), (String)"index should have owning constraint");
            Assertions.assertEquals((long)constraint.getId(), (long)owningConstraintId.getAsLong(), (String)"index should reference constraint");
            Assertions.assertEquals((long)indexRule.getId(), (long)constraint.asIndexBackedConstraint().ownedIndexId(), (String)"constraint should reference index");
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotAllowCreationOfDuplicateIndex(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        String labelName = "Hacker1";
        inserter.createDeferredSchemaIndex(Label.label((String)labelName)).on("handle").create();
        Assertions.assertThrows(ConstraintViolationException.class, () -> inserter.createDeferredSchemaIndex(Label.label((String)labelName)).on("handle").create());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotAllowCreationOfDuplicateConstraint(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        String labelName = "Hacker2";
        inserter.createDeferredConstraint(Label.label((String)labelName)).assertPropertyIsUnique("handle").create();
        Assertions.assertThrows(ConstraintViolationException.class, () -> inserter.createDeferredConstraint(Label.label((String)labelName)).assertPropertyIsUnique("handle").create());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotAllowCreationOfDeferredSchemaConstraintAfterIndexOnSameKeys(int denseNodeThreshold) throws Exception {
        String labelName = "Hacker3";
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        inserter.createDeferredSchemaIndex(Label.label((String)labelName)).on("handle").create();
        Assertions.assertThrows(ConstraintViolationException.class, () -> inserter.createDeferredConstraint(Label.label((String)labelName)).assertPropertyIsUnique("handle").create());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotAllowCreationOfDeferredSchemaIndexAfterConstraintOnSameKeys(int denseNodeThreshold) throws Exception {
        String labelName = "Hacker4";
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        inserter.createDeferredConstraint(Label.label((String)labelName)).assertPropertyIsUnique("handle").create();
        Assertions.assertThrows(ConstraintViolationException.class, () -> inserter.createDeferredSchemaIndex(Label.label((String)labelName)).on("handle").create());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldRunIndexPopulationJobAtShutdown(int denseNodeThreshold) throws Throwable {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)DESCRIPTOR);
        Mockito.when((Object)provider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)populator);
        Mockito.when((Object)populator.sampleResult()).thenReturn((Object)new IndexSample());
        Mockito.when((Object)provider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor);
        Mockito.when((Object)provider.completeConfiguration((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).then(inv -> inv.getArgument(0));
        BatchInserter inserter = this.newBatchInserterWithIndexProvider(SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)KEY, (IndexProvider)provider), provider.getProviderDescriptor(), denseNodeThreshold);
        inserter.createDeferredSchemaIndex(Label.label((String)"Hacker")).on("handle").create();
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"handle", "Jakewins"}), new Label[]{Label.label((String)"Hacker")});
        inserter.shutdown();
        ((IndexProvider)Mockito.verify((Object)provider)).init();
        ((IndexProvider)Mockito.verify((Object)provider)).start();
        ((IndexProvider)Mockito.verify((Object)provider)).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).add((Collection)MockitoHamcrest.argThat((Matcher)CollectionMatcher.matchesCollection((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)internalIndex.schema(), (Value[])new Value[]{Values.of((Object)"Jakewins")})})));
        ((IndexPopulator)Mockito.verify((Object)populator)).verifyDeferredConstraints((NodePropertyAccessor)ArgumentMatchers.any(NodePropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
        ((IndexProvider)Mockito.verify((Object)provider)).stop();
        ((IndexProvider)Mockito.verify((Object)provider)).shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldRunConstraintPopulationJobAtShutdown(int denseNodeThreshold) throws Throwable {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)DESCRIPTOR);
        Mockito.when((Object)provider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)populator);
        Mockito.when((Object)populator.sampleResult()).thenReturn((Object)new IndexSample());
        Mockito.when((Object)provider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor);
        Mockito.when((Object)provider.completeConfiguration((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).then(inv -> inv.getArgument(0));
        BatchInserter inserter = this.newBatchInserterWithIndexProvider(SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)KEY, (IndexProvider)provider), provider.getProviderDescriptor(), denseNodeThreshold);
        inserter.createDeferredConstraint(Label.label((String)"Hacker")).assertPropertyIsUnique("handle").create();
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"handle", "Jakewins"}), new Label[]{Label.label((String)"Hacker")});
        inserter.shutdown();
        ((IndexProvider)Mockito.verify((Object)provider)).init();
        ((IndexProvider)Mockito.verify((Object)provider)).start();
        ((IndexProvider)Mockito.verify((Object)provider)).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).add((Collection)MockitoHamcrest.argThat((Matcher)CollectionMatcher.matchesCollection((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)internalUniqueIndex.schema(), (Value[])new Value[]{Values.of((Object)"Jakewins")})})));
        ((IndexPopulator)Mockito.verify((Object)populator)).verifyDeferredConstraints((NodePropertyAccessor)ArgumentMatchers.any(NodePropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
        ((IndexProvider)Mockito.verify((Object)provider)).stop();
        ((IndexProvider)Mockito.verify((Object)provider)).shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldRepopulatePreexistingIndexed(int denseNodeThreshold) throws Throwable {
        long jakewins = this.dbWithIndexAndSingleIndexedNode(denseNodeThreshold);
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)DESCRIPTOR);
        Mockito.when((Object)provider.completeConfiguration((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).then(inv -> inv.getArgument(0));
        Mockito.when((Object)provider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)populator);
        Mockito.when((Object)populator.sampleResult()).thenReturn((Object)new IndexSample());
        Mockito.when((Object)provider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor);
        BatchInserter inserter = this.newBatchInserterWithIndexProvider(SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)KEY, (IndexProvider)provider), provider.getProviderDescriptor(), denseNodeThreshold);
        long boggle = inserter.createNode(MapUtil.map((Object[])new Object[]{"handle", "b0ggl3"}), new Label[]{Label.label((String)"Hacker")});
        inserter.shutdown();
        ((IndexProvider)Mockito.verify((Object)provider)).init();
        ((IndexProvider)Mockito.verify((Object)provider)).start();
        ((IndexProvider)Mockito.verify((Object)provider)).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).add((Collection)MockitoHamcrest.argThat((Matcher)CollectionMatcher.matchesCollection((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)jakewins, (SchemaDescriptorSupplier)internalIndex.schema(), (Value[])new Value[]{Values.of((Object)"Jakewins")}), IndexEntryUpdate.add((long)boggle, (SchemaDescriptorSupplier)internalIndex.schema(), (Value[])new Value[]{Values.of((Object)"b0ggl3")})})));
        ((IndexPopulator)Mockito.verify((Object)populator)).verifyDeferredConstraints((NodePropertyAccessor)ArgumentMatchers.any(NodePropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
        ((IndexProvider)Mockito.verify((Object)provider)).stop();
        ((IndexProvider)Mockito.verify((Object)provider)).shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldPopulateLabelScanStoreOnShutdown(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node1 = inserter.createNode(null, new Label[]{Labels.FIRST});
        long node2 = inserter.createNode(null, new Label[]{Labels.SECOND});
        long node3 = inserter.createNode(null, new Label[]{Labels.THIRD});
        long node4 = inserter.createNode(null, new Label[]{Labels.FIRST, Labels.SECOND});
        long node5 = inserter.createNode(null, new Label[]{Labels.FIRST, Labels.THIRD});
        LabelScanStore labelScanStore = this.getLabelScanStore();
        inserter.shutdown();
        labelScanStore.init();
        labelScanStore.start();
        BatchInsertTest.assertLabelScanStoreContains(labelScanStore, 0, node1, node4, node5);
        BatchInsertTest.assertLabelScanStoreContains(labelScanStore, 1, node2, node4);
        BatchInsertTest.assertLabelScanStoreContains(labelScanStore, 2, node3, node5);
        labelScanStore.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void propertiesCanBeReSetUsingBatchInserter(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", "One");
        props.put("count", 1);
        props.put("tags", new String[]{"one", "two"});
        props.put("something", "something");
        long nodeId = inserter.createNode(props, new Label[0]);
        inserter.setNodeProperty(nodeId, "name", (Object)"NewOne");
        inserter.removeNodeProperty(nodeId, "count");
        inserter.removeNodeProperty(nodeId, "something");
        inserter.setNodeProperty(nodeId, "name", (Object)"YetAnotherOne");
        inserter.setNodeProperty(nodeId, "additional", (Object)"something");
        Assertions.assertEquals((Object)"YetAnotherOne", inserter.getNodeProperties(nodeId).get("name"));
        Assertions.assertEquals((Object)"something", inserter.getNodeProperties(nodeId).get("additional"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testCleanupEmptyPropertyRecords(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", 1099511659993L);
        properties.put("firstName", "Edward");
        properties.put("lastName", "Shevchenko");
        properties.put("gender", "male");
        properties.put("birthday", new SimpleDateFormat("yyyy-MM-dd").parse("1987-11-08").getTime());
        properties.put("birthday_month", 11);
        properties.put("birthday_day", 8);
        long time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse("2010-04-22T18:05:40.912+0000").getTime();
        properties.put("creationDate", time);
        properties.put("locationIP", "46.151.255.205");
        properties.put("browserUsed", "Firefox");
        properties.put("email", new String[0]);
        properties.put("languages", new String[0]);
        long personNodeId = inserter.createNode(properties, new Label[0]);
        Assertions.assertEquals((Object)"Shevchenko", (Object)BatchInsertTest.getNodeProperties(inserter, personNodeId).get("lastName"));
        MatcherAssert.assertThat((Object)((String[])BatchInsertTest.getNodeProperties(inserter, personNodeId).get("email")), (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        inserter.setNodeProperty(personNodeId, "email", (Object)new String[]{"Edward1099511659993@gmail.com"});
        MatcherAssert.assertThat((Object)((String[])BatchInsertTest.getNodeProperties(inserter, personNodeId).get("email")), (Matcher)Matchers.arrayContaining((Object[])new String[]{"Edward1099511659993@gmail.com"}));
        inserter.setNodeProperty(personNodeId, "email", (Object)new String[]{"Edward1099511659993@gmail.com", "backup@gmail.com"});
        MatcherAssert.assertThat((Object)((String[])BatchInsertTest.getNodeProperties(inserter, personNodeId).get("email")), (Matcher)Matchers.arrayContaining((Object[])new String[]{"Edward1099511659993@gmail.com", "backup@gmail.com"}));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void propertiesCanBeReSetUsingBatchInserter2(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long id = inserter.createNode(new HashMap(), new Label[0]);
        inserter.setNodeProperty(id, "test", (Object)"looooooooooong test");
        inserter.setNodeProperty(id, "test", (Object)"small test");
        Assertions.assertEquals((Object)"small test", inserter.getNodeProperties(id).get("test"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void replaceWithBiggerPropertySpillsOverIntoNewPropertyRecord(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", "One");
        props.put("count", 1);
        props.put("tags", new String[]{"one", "two"});
        long id = inserter.createNode(props, new Label[0]);
        inserter.setNodeProperty(id, "name", (Object)"NewOne");
        inserter.setNodeProperty(id, "count", (Object)"something");
        Assertions.assertEquals((Object)"something", inserter.getNodeProperties(id).get("count"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void mustSplitUpRelationshipChainsWhenCreatingDenseNodes(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node1 = inserter.createNode(null, new Label[0]);
        long node2 = inserter.createNode(null, new Label[0]);
        for (int i = 0; i < 1000; ++i) {
            for (MyRelTypes relType : MyRelTypes.values()) {
                inserter.createRelationship(node1, node2, (RelationshipType)relType, null);
            }
        }
        NeoStores neoStores = BatchInsertTest.getFlushedNeoStores(inserter);
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord record = (NodeRecord)nodeStore.getRecord(node1, (AbstractBaseRecord)((NodeRecord)nodeStore.newRecord()), RecordLoad.NORMAL);
        Assertions.assertTrue((boolean)record.isDense(), (String)("Node " + record + " should have been dense"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldGetRelationships(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(null, new Label[0]);
        BatchInsertTest.createRelationships(inserter, node, RelTypes.REL_TYPE1, 3);
        BatchInsertTest.createRelationships(inserter, node, RelTypes.REL_TYPE2, 4);
        Set gottenRelationships = Iterables.asSet((Iterable)inserter.getRelationshipIds(node));
        Assertions.assertEquals((int)21, (int)gottenRelationships.size());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotCreateSameLabelTwiceOnSameNode(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"itemId", 1000L}), new Label[]{Label.label((String)"Item"), Label.label((String)"Item")});
        NodeStore nodeStore = BatchInsertTest.getFlushedNeoStores(inserter).getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.getRecord(nodeId, (AbstractBaseRecord)((NodeRecord)nodeStore.newRecord()), RecordLoad.NORMAL);
        NodeLabels labels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        long[] labelIds = labels.get(nodeStore);
        Assertions.assertEquals((int)1, (int)labelIds.length);
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSortLabelIdsWhenGetOrCreate(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"Item", 123456789123L}), new Label[]{Label.label((String)"AA"), Label.label((String)"BB"), Label.label((String)"CC"), Label.label((String)"DD")});
        inserter.setNodeLabels(nodeId, new Label[]{Label.label((String)"CC"), Label.label((String)"AA"), Label.label((String)"DD"), Label.label((String)"EE"), Label.label((String)"FF")});
        NodeStore nodeStore = BatchInsertTest.getFlushedNeoStores(inserter).getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.getRecord(nodeId, (AbstractBaseRecord)((NodeRecord)nodeStore.newRecord()), RecordLoad.NORMAL);
        NodeLabels labels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        long[] labelIds = labels.get(nodeStore);
        long[] sortedLabelIds = (long[])labelIds.clone();
        Arrays.sort(sortedLabelIds);
        Assertions.assertArrayEquals((long[])sortedLabelIds, (long[])labelIds);
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldCreateUniquenessConstraint(int denseNodeThreshold) throws Exception {
        Label label = Label.label((String)"Person");
        String propertyKey = "name";
        String duplicatedValue = "Tom";
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        inserter.createDeferredConstraint(label).assertPropertyIsUnique(propertyKey).create();
        GraphDatabaseAPI db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try {
            try (Transaction tx = db.beginTx();){
                List constraints = Iterables.asList((Iterable)tx.schema().getConstraints());
                Assertions.assertEquals((int)1, (int)constraints.size());
                ConstraintDefinition constraint = (ConstraintDefinition)constraints.get(0);
                Assertions.assertEquals((Object)label.name(), (Object)constraint.getLabel().name());
                Assertions.assertEquals((Object)propertyKey, (Object)Iterables.single((Iterable)constraint.getPropertyKeys()));
                tx.createNode(new Label[]{label}).setProperty(propertyKey, (Object)duplicatedValue);
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.createNode(new Label[]{label}).setProperty(propertyKey, (Object)duplicatedValue);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            Assertions.fail((String)"Uniqueness property constraint was violated, exception expected");
        }
        catch (ConstraintViolationException e) {
            Assertions.assertEquals((Object)String.format("Node(0) already exists with label `%s` and property `%s` = '%s'", label.name(), propertyKey, duplicatedValue), (Object)e.getMessage());
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotAllowCreationOfUniquenessConstraintAndIndexOnSameLabelAndProperty(int denseNodeThreshold) throws Exception {
        Label label = Label.label((String)"Person1");
        String property = "name";
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        inserter.createDeferredConstraint(label).assertPropertyIsUnique(property).create();
        ConstraintViolationException e = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> inserter.createDeferredSchemaIndex(label).on(property).create());
        Assertions.assertEquals((Object)"Index for given {label;property} already exists", (Object)e.getMessage());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotAllowDuplicatedUniquenessConstraints(int denseNodeThreshold) throws Exception {
        Label label = Label.label((String)"Person2");
        String property = "name";
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        inserter.createDeferredConstraint(label).assertPropertyIsUnique(property).create();
        ConstraintViolationException e = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> inserter.createDeferredConstraint(label).assertPropertyIsUnique(property).create());
        Assertions.assertEquals((Object)"It is not allowed to create node keys, uniqueness constraints or indexes on the same {label;property}", (Object)e.getMessage());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotAllowDuplicatedIndexes(int denseNodeThreshold) throws Exception {
        Label label = Label.label((String)"Person3");
        String property = "name";
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        inserter.createDeferredSchemaIndex(label).on(property).create();
        ConstraintViolationException e = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> inserter.createDeferredSchemaIndex(label).on(property).create());
        Assertions.assertEquals((Object)"Index for given {label;property} already exists", (Object)e.getMessage());
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"params"})
    void uniquenessConstraintShouldBeCheckedOnBatchInserterShutdownAndFailIfViolated(int denseNodeThreshold) throws Exception {
        Label label = Label.label((String)"Foo");
        String property = "Bar";
        String value = "Baz";
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        inserter.createDeferredConstraint(label).assertPropertyIsUnique(property).create();
        inserter.createNode(Collections.singletonMap(property, value), new Label[]{label});
        inserter.createNode(Collections.singletonMap(property, value), new Label[]{label});
        GraphDatabaseAPI db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try (Transaction tx = db.beginTx();){
            Schema schema = tx.schema();
            IndexDefinition index = (IndexDefinition)schema.getIndexes(label).iterator().next();
            String indexFailure = schema.getIndexFailure(index);
            MatcherAssert.assertThat((Object)indexFailure, (Matcher)CoreMatchers.containsString((String)"IndexEntryConflictException"));
            MatcherAssert.assertThat((Object)indexFailure, (Matcher)CoreMatchers.containsString((String)value));
            tx.commit();
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldChangePropertiesInCurrentBatch(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        Map properties = MapUtil.map((Object[])new Object[]{"key1", "value1"});
        long node = inserter.createNode(properties, new Label[0]);
        properties.put("additionalKey", "Additional value");
        inserter.setNodeProperties(node, properties);
        Assertions.assertEquals((Object)properties, BatchInsertTest.getNodeProperties(inserter, node));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldIgnoreRemovingNonExistentNodeProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long id = inserter.createNode(Collections.emptyMap(), new Label[0]);
        inserter.removeNodeProperty(id, "non-existent");
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldIgnoreRemovingNonExistentRelationshipProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        Map noProperties = Collections.emptyMap();
        long nodeId1 = inserter.createNode(noProperties, new Label[0]);
        long nodeId2 = inserter.createNode(noProperties, new Label[0]);
        long id = inserter.createRelationship(nodeId1, nodeId2, (RelationshipType)MyRelTypes.TEST, noProperties);
        inserter.removeRelationshipProperty(id, "non-existent");
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldStartOnAndUpdateDbContainingFulltextIndex() throws Exception {
        boolean impermanent = false;
        int denseNodeThreshold = (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue();
        GraphDatabaseAPI db = this.instantiateGraphDatabaseService(denseNodeThreshold);
        String key = "key";
        Label label = Label.label((String)"Label");
        String indexName = "ftsNodes";
        try {
            try (Transaction tx = db.beginTx();){
                db.executeTransactionally(String.format("CALL db.index.fulltext.createNodeIndex('%s', ['%s'], ['%s'] )", indexName, label.name(), key));
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            this.managementService.shutdown();
        }
        String value = "hey";
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(Collections.singletonMap(key, value), new Label[]{label});
        inserter.shutdown();
        GraphDatabaseAPI dbAfterInsert = this.instantiateGraphDatabaseService(denseNodeThreshold);
        try (Transaction tx = dbAfterInsert.beginTx();){
            ResourceIterator nodes = tx.findNodes(label, key, (Object)value);
            Node foundNode = (Node)Iterators.single((Iterator)nodes);
            Assertions.assertEquals((long)node, (long)foundNode.getId());
            dbAfterInsert.executeTransactionally(String.format("CALL db.index.fulltext.queryNodes('%s', '%s')", indexName, value), new HashMap(), result -> {
                Assertions.assertTrue((boolean)result.hasNext());
                Map hit = result.next();
                Node indexedNode = (Node)hit.get("node");
                Assertions.assertFalse((boolean)result.hasNext());
                return indexedNode;
            });
        }
        finally {
            this.managementService.shutdown();
        }
    }

    private Config configuration(int denseNodeThreshold) {
        return Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.absolutePath().toPath()).set(GraphDatabaseSettings.dense_node_threshold, (Object)denseNodeThreshold).build();
    }

    private BatchInserter newBatchInserter(int denseNodeThreshold) throws Exception {
        return BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (Config)this.configuration(denseNodeThreshold));
    }

    private BatchInserter newBatchInserterWithIndexProvider(ExtensionFactory<?> provider, IndexProviderDescriptor providerDescriptor, int denseNodeThreshold) throws Exception {
        Config configuration = this.configuration(denseNodeThreshold);
        configuration.set(GraphDatabaseSettings.default_schema_provider, (Object)providerDescriptor.name());
        return BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (Config)configuration, Collections.singletonList(provider));
    }

    private GraphDatabaseAPI switchToEmbeddedGraphDatabaseService(BatchInserter inserter, int denseNodeThreshold) {
        inserter.shutdown();
        return this.instantiateGraphDatabaseService(denseNodeThreshold);
    }

    private GraphDatabaseAPI instantiateGraphDatabaseService(int denseNodeThreshold) {
        TestDatabaseManagementServiceBuilder factory = new TestDatabaseManagementServiceBuilder(this.databaseLayout);
        factory.setFileSystem(this.fs);
        this.managementService = factory.impermanent().setConfig(this.configuration(denseNodeThreshold)).build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private LabelScanStore getLabelScanStore() {
        return new NativeLabelScanStore(this.pageCache, this.databaseLayout, this.fs, FullStoreChangeStream.EMPTY, true, new Monitors(), RecoveryCleanupWorkCollector.immediate());
    }

    private static void assertLabelScanStoreContains(LabelScanStore labelScanStore, int labelId, long ... nodes) {
        List<Long> actualNodeIds;
        LabelScanReader labelScanReader = labelScanStore.newReader();
        List expectedNodeIds = Arrays.stream(nodes).boxed().collect(Collectors.toList());
        try (PrimitiveLongResourceIterator itr = labelScanReader.nodesWithLabel(labelId);){
            actualNodeIds = BatchInsertTest.extractPrimitiveLongIteratorAsList(itr);
        }
        Assertions.assertEquals(expectedNodeIds, actualNodeIds);
    }

    private static List<Long> extractPrimitiveLongIteratorAsList(PrimitiveLongResourceIterator longIterator) {
        ArrayList<Long> actualNodeIds = new ArrayList<Long>();
        while (longIterator.hasNext()) {
            actualNodeIds.add(longIterator.next());
        }
        return actualNodeIds;
    }

    private static void createRelationships(BatchInserter inserter, long node, RelationshipType relType, int out) {
        int i;
        for (i = 0; i < out; ++i) {
            inserter.createRelationship(node, inserter.createNode(null, new Label[0]), relType, null);
        }
        for (i = 0; i < out; ++i) {
            inserter.createRelationship(inserter.createNode(null, new Label[0]), node, relType, null);
        }
        for (i = 0; i < out; ++i) {
            inserter.createRelationship(node, node, relType, null);
        }
    }

    private long dbWithIndexAndSingleIndexedNode(int denseNodeThreshold) throws Exception {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)DESCRIPTOR);
        Mockito.when((Object)provider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)populator);
        Mockito.when((Object)provider.completeConfiguration((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).then(inv -> inv.getArgument(0));
        BatchInserter inserter = this.newBatchInserterWithIndexProvider(SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)KEY, (IndexProvider)provider), provider.getProviderDescriptor(), denseNodeThreshold);
        inserter.createDeferredSchemaIndex(Label.label((String)"Hacker")).on("handle").create();
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"handle", "Jakewins"}), new Label[]{Label.label((String)"Hacker")});
        inserter.shutdown();
        return nodeId;
    }

    private static void setAndGet(BatchInserter inserter, Object value) {
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"key", value}), new Label[0]);
        Object readValue = inserter.getNodeProperties(nodeId).get("key");
        if (readValue.getClass().isArray()) {
            Assertions.assertArrayEquals((int[])((int[])value), (int[])((int[])readValue));
        } else {
            Assertions.assertEquals((Object)value, readValue);
        }
    }

    private static int[] intArray() {
        int length = 20;
        int[] array = new int[length];
        int startValue = 0x40000000;
        for (int i = 0; i < length; ++i) {
            array[i] = startValue + i;
        }
        return array;
    }

    private static Node getNodeInTx(long nodeId, GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.getNodeById(nodeId);
            return node;
        }
    }

    private static void forceFlush(BatchInserter inserter) {
        ((BatchInserterImpl)inserter).forceFlushChanges();
    }

    private static NeoStores getFlushedNeoStores(BatchInserter inserter) {
        BatchInsertTest.forceFlush(inserter);
        return ((BatchInserterImpl)inserter).getNeoStores();
    }

    private static Iterable<String> asNames(Iterable<Label> nodeLabels) {
        return Iterables.map(Label::name, nodeLabels);
    }

    private static Pair<Label[], Set<String>> manyLabels(int count) {
        Label[] labels = new Label[count];
        HashSet<CallSite> expectedLabelNames = new HashSet<CallSite>();
        for (int i = 0; i < labels.length; ++i) {
            String labelName = "bach label " + i;
            labels[i] = Label.label((String)labelName);
            expectedLabelNames.add((CallSite)((Object)labelName));
        }
        return Pair.of((Object)labels, expectedLabelNames);
    }

    private static Map<String, Object> getNodeProperties(BatchInserter inserter, long nodeId) {
        return inserter.getNodeProperties(nodeId);
    }

    private static Map<String, Object> getRelationshipProperties(BatchInserter inserter, long relId) {
        return inserter.getRelationshipProperties(relId);
    }

    static {
        properties.put("key0", "SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA");
        properties.put("key1", 1);
        properties.put("key2", (short)2);
        properties.put("key3", 3L);
        properties.put("key4", Float.valueOf(4.0f));
        properties.put("key5", 5.0);
        properties.put("key6", (byte)6);
        properties.put("key7", true);
        properties.put("key8", Character.valueOf('\b'));
        properties.put("key10", new String[]{"SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA", "dsasda", "dssadsad"});
        properties.put("key11", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key12", new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key13", new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        properties.put("key14", new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f});
        properties.put("key15", new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        properties.put("key16", new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key17", new boolean[]{true, false, true, false});
        properties.put("key18", new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t'});
    }

    private static enum Labels implements Label
    {
        FIRST,
        SECOND,
        THIRD;

    }

    private static enum RelTypes implements RelationshipType
    {
        BATCH_TEST,
        REL_TYPE1,
        REL_TYPE2,
        REL_TYPE3,
        REL_TYPE4,
        REL_TYPE5;

    }
}

