/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.locker.DatabaseLocker;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class BatchInserterImplTest {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;

    BatchInserterImplTest() {
    }

    @Test
    void testHonorsPassedInParams() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (Config)Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)"280K"));
        NeoStores neoStores = (NeoStores)ReflectionUtil.getPrivateField((Object)inserter, (String)"neoStores", NeoStores.class);
        PageCache pageCache = (PageCache)ReflectionUtil.getPrivateField((Object)neoStores, (String)"pageCache", PageCache.class);
        inserter.shutdown();
        long mappedMemoryTotalSize = MuninnPageCache.memoryRequiredForPages((long)pageCache.maxCachedPages());
        MatcherAssert.assertThat((String)"memory mapped config is active", (Object)mappedMemoryTotalSize, (Matcher)Matchers.is((Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(ByteUnit.kibiBytes((long)270L))), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(ByteUnit.kibiBytes((long)290L))))));
    }

    @Test
    void testCreatesLockFile() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        try {
            Assertions.assertTrue((boolean)this.databaseLayout.databaseLockFile().exists());
        }
        finally {
            inserter.shutdown();
        }
    }

    @Test
    void testFailsOnExistingStoreLockFile() throws IOException {
        try (DatabaseLocker lock = new DatabaseLocker(this.fileSystem, this.databaseLayout);){
            lock.checkLock();
            FileLockException e = (FileLockException)Assertions.assertThrows(FileLockException.class, () -> BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Unable to obtain lock on file"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCorrectlyMarkHighIds() throws Exception {
        DatabaseLayout layout = this.databaseLayout;
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem, (Config)Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)"8m"));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", "Just some name");
        properties.put("some_array", new String[]{"this", "is", "a", "string", "which", "really", "is", "an", "array"});
        long[] nodeIds = new long[10];
        for (int i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = inserter.createNode(properties, new Label[0]);
        }
        MutableLongSet nodeIdsSet = LongSets.mutable.of(nodeIds);
        inserter.shutdown();
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(layout.getNeo4jLayout().homeDirectory()).setFileSystem(this.fileSystem).build();
        try {
            Transaction tx;
            GraphDatabaseService db = dbms.database("neo4j");
            for (long nodeId : nodeIds) {
                tx = db.beginTx();
                try {
                    tx.getNodeById(nodeId).addLabel(TestLabels.LABEL_ONE);
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            for (int i = 0; i < 5; ++i) {
                try (Transaction tx2 = db.beginTx();){
                    Node node = tx2.createNode();
                    Assertions.assertFalse((boolean)nodeIdsSet.contains(node.getId()));
                    tx2.commit();
                    continue;
                }
            }
            for (long nodeId : nodeIds) {
                tx = db.beginTx();
                try {
                    tx.getNodeById(nodeId).delete();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
        }
        finally {
            dbms.shutdown();
        }
    }
}

