/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.batchinsert.internal.FileSystemClosingBatchInserter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class BatchInsertersTest {
    @Inject
    private DatabaseLayout databaseLayout;

    BatchInsertersTest() {
    }

    @Test
    void automaticallyCloseCreatedFileSystemOnShutdown() throws Exception {
        BatchInsertersTest.verifyInserterFileSystemClose(BatchInserters.inserter((DatabaseLayout)this.databaseLayout));
        BatchInsertersTest.verifyInserterFileSystemClose(BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (Config)BatchInsertersTest.getConfig()));
    }

    @Test
    void providedFileSystemNotClosedAfterShutdown() throws IOException {
        try (EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();){
            BatchInsertersTest.verifyProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fs), fs);
            BatchInsertersTest.verifyProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fs, (Config)BatchInsertersTest.getConfig()), fs);
        }
    }

    private static Config getConfig() {
        return Config.newBuilder().set(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.mebiBytes((long)10L)).set(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).set(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName()).build();
    }

    private static void verifyProvidedFileSystemOpenAfterShutdown(BatchInserter inserter, EphemeralFileSystemAbstraction fileSystemAbstraction) {
        inserter.shutdown();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fileSystemAbstraction.isClosed());
    }

    private static void verifyInserterFileSystemClose(BatchInserter inserter) {
        ((ObjectAssert)Assertions.assertThat((Object)inserter).as("Expect specific implementation that will do required cleanups.", new Object[0])).isInstanceOf(FileSystemClosingBatchInserter.class);
        inserter.shutdown();
    }
}

