/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.batchinsert.internal.BatchInserterImpl;
import org.neo4j.batchinsert.internal.BatchRelationship;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
@Neo4jLayoutExtension
class BatchInsertTest {
    private static final String INTERNAL_LOG_FILE = "debug.log";
    private static final Map<String, Object> properties = new HashMap<String, Object>();
    private static final RelationshipType[] relTypeArray = new RelationshipType[]{RelTypes.REL_TYPE1, RelTypes.REL_TYPE2, RelTypes.REL_TYPE3, RelTypes.REL_TYPE4, RelTypes.REL_TYPE5};
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private PageCache pageCache;
    @Inject
    private RecordDatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;

    BatchInsertTest() {
    }

    private static Stream<Arguments> params() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{5}), Arguments.arguments((Object[])new Object[]{GraphDatabaseSettings.dense_node_threshold.defaultValue()}));
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldUpdateStringArrayPropertiesOnNodesUsingBatchInserter1(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        String[] array1 = new String[]{"1"};
        String[] array2 = new String[]{"a"};
        long id1 = inserter.createNode(MapUtil.map((Object[])new Object[]{"array", array1}), new Label[0]);
        long id2 = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[0]);
        inserter.getNodeProperties(id1).get("array");
        inserter.setNodeProperty(id1, "array", (Object)array1);
        inserter.setNodeProperty(id2, "array", (Object)array2);
        inserter.getNodeProperties(id1).get("array");
        inserter.setNodeProperty(id1, "array", (Object)array1);
        inserter.setNodeProperty(id2, "array", (Object)array2);
        Assertions.assertThat(inserter.getNodeProperties(id1).get("array")).isEqualTo((Object)array1);
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testSimple(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node1 = inserter.createNode(null, new Label[0]);
        long node2 = inserter.createNode(null, new Label[0]);
        long rel1 = inserter.createRelationship(node1, node2, (RelationshipType)RelTypes.BATCH_TEST, null);
        BatchRelationship rel = inserter.getRelationshipById(rel1);
        org.junit.jupiter.api.Assertions.assertEquals((long)rel.getStartNode(), (long)node1);
        org.junit.jupiter.api.Assertions.assertEquals((long)rel.getEndNode(), (long)node2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)RelTypes.BATCH_TEST.name(), (Object)rel.getType().name());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testSetAndAddNodeProperties(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long tehNode = inserter.createNode(MapUtil.map((Object[])new Object[]{"one", "one", "two", "two", "three", "three"}), new Label[0]);
        inserter.setNodeProperty(tehNode, "four", (Object)"four");
        inserter.setNodeProperty(tehNode, "five", (Object)"five");
        Map<String, Object> props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)props.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"one", (Object)props.get("one"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"five", (Object)props.get("five"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void setSingleProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long nodeById = inserter.createNode(null, new Label[0]);
        String value = "Something";
        String key = "name";
        inserter.setNodeProperty(nodeById, key, (Object)value);
        GraphDatabaseAPI db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try (Transaction tx = db.beginTx();){
            Node node = tx.getNodeById(nodeById);
            Assertions.assertThat((Object)node.getProperty(key)).isEqualTo((Object)value);
        }
        this.managementService.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testSetAndKeepNodeProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long tehNode = inserter.createNode(MapUtil.map((Object[])new Object[]{"foo", "bar"}), new Label[0]);
        inserter.setNodeProperty(tehNode, "foo2", (Object)"bar2");
        Map<String, Object> props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)props.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)props.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.setNodeProperty(tehNode, "foo", (Object)"bar3");
        props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)props.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        props = BatchInsertTest.getNodeProperties(inserter, tehNode);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)props.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testSetAndKeepRelationshipProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long from = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long to = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long theRel = inserter.createRelationship(from, to, RelationshipType.withName((String)"TestingPropsHere"), MapUtil.map((Object[])new Object[]{"foo", "bar"}));
        inserter.setRelationshipProperty(theRel, "foo2", (Object)"bar2");
        Map<String, Object> props = BatchInsertTest.getRelationshipProperties(inserter, theRel);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)props.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        props = BatchInsertTest.getRelationshipProperties(inserter, theRel);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)props.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.setRelationshipProperty(theRel, "foo", (Object)"bar3");
        props = BatchInsertTest.getRelationshipProperties(inserter, theRel);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)props.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        props = BatchInsertTest.getRelationshipProperties(inserter, theRel);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)props.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar3", (Object)props.get("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testNodeHasProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long theNode = inserter.createNode(properties, new Label[0]);
        long anotherNode = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long relationship = inserter.createRelationship(theNode, anotherNode, RelationshipType.withName((String)"foo"), properties);
        for (String key : properties.keySet()) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)inserter.nodeHasProperty(theNode, key + "-"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key + "-"));
        }
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testRemoveProperties(int denseNodeThreshold) throws Exception {
        String key;
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long theNode = inserter.createNode(properties, new Label[0]);
        long anotherNode = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long relationship = inserter.createRelationship(theNode, anotherNode, RelationshipType.withName((String)"foo"), properties);
        inserter.removeNodeProperty(theNode, "key0");
        inserter.removeRelationshipProperty(relationship, "key1");
        Iterator<String> iterator = properties.keySet().iterator();
        block16: while (iterator.hasNext()) {
            switch (key = iterator.next()) {
                case "key0": {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)inserter.nodeHasProperty(theNode, key));
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block16;
                }
                case "key1": {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block16;
                }
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
        }
        inserter.shutdown();
        inserter = this.newBatchInserter(denseNodeThreshold);
        iterator = properties.keySet().iterator();
        block17: while (iterator.hasNext()) {
            switch (key = iterator.next()) {
                case "key0": {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)inserter.nodeHasProperty(theNode, key));
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block17;
                }
                case "key1": {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block17;
                }
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
        }
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldBeAbleToRemoveDynamicProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        String key = "tags";
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{key, new String[]{"one", "two", "three"}}), new Label[0]);
        inserter.removeNodeProperty(nodeId, key);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)inserter.getNodeProperties(nodeId).containsKey(key));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldBeAbleToOverwriteDynamicProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        String key = "tags";
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{key, new String[]{"one", "two", "three"}}), new Label[0]);
        Object[] secondValue = new String[]{"four", "five", "six"};
        inserter.setNodeProperty(nodeId, key, (Object)secondValue);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])secondValue, (Object[])((String[])BatchInsertTest.getNodeProperties(inserter, nodeId).get(key)));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testMore(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long startNode = inserter.createNode(properties, new Label[0]);
        long[] endNodes = new long[25];
        HashSet<Long> rels = new HashSet<Long>();
        for (int i = 0; i < 25; ++i) {
            endNodes[i] = inserter.createNode(properties, new Label[0]);
            rels.add(inserter.createRelationship(startNode, endNodes[i], relTypeArray[i % 5], properties));
        }
        for (BatchRelationship rel : inserter.getRelationships(startNode)) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)rels.contains(rel.getId()));
            org.junit.jupiter.api.Assertions.assertEquals((long)rel.getStartNode(), (long)startNode);
        }
        inserter.setNodeProperties(startNode, properties);
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"params"})
    void makeSureLoopsCanBeCreated(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long startNode = inserter.createNode(properties, new Label[0]);
        long otherNode = inserter.createNode(properties, new Label[0]);
        long selfRelationship = inserter.createRelationship(startNode, startNode, relTypeArray[0], properties);
        long relationship = inserter.createRelationship(startNode, otherNode, relTypeArray[0], properties);
        for (BatchRelationship rel : inserter.getRelationships(startNode)) {
            if (rel.getId() == selfRelationship) {
                org.junit.jupiter.api.Assertions.assertEquals((long)startNode, (long)rel.getStartNode());
                org.junit.jupiter.api.Assertions.assertEquals((long)startNode, (long)rel.getEndNode());
                continue;
            }
            if (rel.getId() == relationship) {
                org.junit.jupiter.api.Assertions.assertEquals((long)startNode, (long)rel.getStartNode());
                org.junit.jupiter.api.Assertions.assertEquals((long)otherNode, (long)rel.getEndNode());
                continue;
            }
            org.junit.jupiter.api.Assertions.fail((String)("Unexpected relationship " + rel.getId()));
        }
        GraphDatabaseAPI db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try (Transaction transaction = db.beginTx();){
            Node realStartNode = transaction.getNodeById(startNode);
            Relationship realSelfRelationship = transaction.getRelationshipById(selfRelationship);
            Relationship realRelationship = transaction.getRelationshipById(relationship);
            org.junit.jupiter.api.Assertions.assertEquals((Object)realSelfRelationship, (Object)realStartNode.getSingleRelationship((RelationshipType)RelTypes.REL_TYPE1, Direction.INCOMING));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Relationship[]{realSelfRelationship, realRelationship}), (Object)Iterables.asSet((Iterable)realStartNode.getRelationships(Direction.OUTGOING)));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Relationship[]{realSelfRelationship, realRelationship}), (Object)Iterables.asSet((Iterable)realStartNode.getRelationships()));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void createBatchNodeAndRelationshipsDeleteAllInEmbedded(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long nodeId = inserter.createNode(null, new Label[0]);
        inserter.createRelationship(nodeId, inserter.createNode(null, new Label[0]), (RelationshipType)RelTypes.BATCH_TEST, null);
        inserter.createRelationship(inserter.createNode(null, new Label[0]), nodeId, (RelationshipType)RelTypes.REL_TYPE1, null);
        GraphDatabaseAPI db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try (Transaction tx = db.beginTx();){
            Node node = tx.getNodeById(nodeId);
            for (Relationship relationship : node.getRelationships()) {
                relationship.delete();
            }
            node.delete();
            tx.commit();
        }
        this.managementService.shutdown();
    }

    @Test
    void messagesLogGetsClosed() throws IOException {
        Config config = Config.newBuilder().set(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (Config)config);
        inserter.shutdown();
        Files.delete(this.databaseLayout.getNeo4jLayout().homeDirectory().resolve(INTERNAL_LOG_FILE));
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void createEntitiesWithEmptyPropertiesMap(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[0]);
        BatchInsertTest.getNodeProperties(inserter, nodeId);
        long anotherNodeId = inserter.createNode(null, new Label[0]);
        long relId = inserter.createRelationship(nodeId, anotherNodeId, (RelationshipType)RelTypes.BATCH_TEST, MapUtil.map((Object[])new Object[0]));
        inserter.getRelationshipProperties(relId);
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void createEntitiesWithDynamicPropertiesMap(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        BatchInsertTest.setAndGet(inserter, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        BatchInsertTest.setAndGet(inserter, BatchInsertTest.intArray());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldAddInitialLabelsToCreatedNode(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[]{Labels.FIRST, Labels.SECOND});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.nodeHasLabel(node, (Label)Labels.FIRST));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)inserter.nodeHasLabel(node, (Label)Labels.SECOND));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)inserter.nodeHasLabel(node, (Label)Labels.THIRD));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldGetNodeLabels(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[]{Labels.FIRST, Labels.THIRD});
        Iterable<String> labelNames = BatchInsertTest.asNames(inserter.getNodeLabels(node));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{Labels.FIRST.name(), Labels.THIRD.name()}), (Object)Iterables.asSet(labelNames));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldAddManyInitialLabelsAsDynamicRecords(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        Pair<Label[], Set<String>> labels = BatchInsertTest.manyLabels(200);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), (Label[])labels.first());
        BatchInsertTest.forceFlush(inserter);
        Iterable<String> labelNames = BatchInsertTest.asNames(inserter.getNodeLabels(node));
        org.junit.jupiter.api.Assertions.assertEquals((Object)labels.other(), (Object)Iterables.asSet(labelNames));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldReplaceExistingInlinedLabelsWithDynamic(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[]{Labels.FIRST});
        Pair<Label[], Set<String>> labels = BatchInsertTest.manyLabels(100);
        inserter.setNodeLabels(node, (Label[])labels.first());
        Iterable<String> labelNames = BatchInsertTest.asNames(inserter.getNodeLabels(node));
        org.junit.jupiter.api.Assertions.assertEquals((Object)labels.other(), (Object)Iterables.asSet(labelNames));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldReplaceExistingDynamicLabelsWithInlined(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), (Label[])BatchInsertTest.manyLabels(150).first());
        inserter.setNodeLabels(node, new Label[]{Labels.FIRST});
        Iterable<String> labelNames = BatchInsertTest.asNames(inserter.getNodeLabels(node));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{Labels.FIRST.name()}), (Object)Iterables.asSet(labelNames));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldRepopulatePreexistingIndexes(int denseNodeThreshold) throws Throwable {
        GraphDatabaseAPI db = this.instantiateGraphDatabaseService(denseNodeThreshold);
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(Label.label((String)"Hacker")).on("handle").create();
            int labelId = ((TransactionImpl)tx).kernelTransaction().tokenRead().nodeLabel("Hacker");
            int propId = ((TransactionImpl)tx).kernelTransaction().tokenRead().propertyKey("handle");
            LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propId});
            tx.commit();
        }
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = tx.createNode(new Label[]{Label.label((String)"Hacker")});
            node.setProperty("handle", (Object)"Jakewins");
            long nodeId = node.getId();
            tx.commit();
        }
        this.managementService.shutdown();
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long boggle = inserter.createNode(MapUtil.map((Object[])new Object[]{"handle", "b0ggl3"}), new Label[]{Label.label((String)"Hacker")});
        db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try (Transaction tx = db.beginTx();){
            Assertions.assertThat((Stream)tx.findNodes(Label.label((String)"Hacker")).stream()).hasSize(2);
            Assertions.assertThat(tx.findNodes(Label.label((String)"Hacker"), "handle", (Object)"b0ggl3").stream().map(Entity::getId)).containsExactly((Object[])new Long[]{boggle});
        }
        this.managementService.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void propertiesCanBeReSetUsingBatchInserter(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", "One");
        props.put("count", 1);
        props.put("tags", new String[]{"one", "two"});
        props.put("something", "something");
        long nodeId = inserter.createNode(props, new Label[0]);
        inserter.setNodeProperty(nodeId, "name", (Object)"NewOne");
        inserter.removeNodeProperty(nodeId, "count");
        inserter.removeNodeProperty(nodeId, "something");
        inserter.setNodeProperty(nodeId, "name", (Object)"YetAnotherOne");
        inserter.setNodeProperty(nodeId, "additional", (Object)"something");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"YetAnotherOne", inserter.getNodeProperties(nodeId).get("name"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"something", inserter.getNodeProperties(nodeId).get("additional"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testCleanupEmptyPropertyRecords(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", 1099511659993L);
        properties.put("firstName", "Edward");
        properties.put("lastName", "Shevchenko");
        properties.put("gender", "male");
        properties.put("birthday", new SimpleDateFormat("yyyy-MM-dd").parse("1987-11-08").getTime());
        properties.put("birthday_month", 11);
        properties.put("birthday_day", 8);
        long time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse("2010-04-22T18:05:40.912+0000").getTime();
        properties.put("creationDate", time);
        properties.put("locationIP", "46.151.255.205");
        properties.put("browserUsed", "Firefox");
        properties.put("email", new String[0]);
        properties.put("languages", new String[0]);
        long personNodeId = inserter.createNode(properties, new Label[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Shevchenko", (Object)BatchInsertTest.getNodeProperties(inserter, personNodeId).get("lastName"));
        Assertions.assertThat((Object[])((String[])BatchInsertTest.getNodeProperties(inserter, personNodeId).get("email"))).isEmpty();
        inserter.setNodeProperty(personNodeId, "email", (Object)new String[]{"Edward1099511659993@gmail.com"});
        Assertions.assertThat((Object[])((String[])BatchInsertTest.getNodeProperties(inserter, personNodeId).get("email"))).contains((Object[])new String[]{"Edward1099511659993@gmail.com"});
        inserter.setNodeProperty(personNodeId, "email", (Object)new String[]{"Edward1099511659993@gmail.com", "backup@gmail.com"});
        Assertions.assertThat((Object[])((String[])BatchInsertTest.getNodeProperties(inserter, personNodeId).get("email"))).contains((Object[])new String[]{"Edward1099511659993@gmail.com", "backup@gmail.com"});
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void propertiesCanBeReSetUsingBatchInserter2(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long id = inserter.createNode(new HashMap(), new Label[0]);
        inserter.setNodeProperty(id, "test", (Object)"looooooooooong test");
        inserter.setNodeProperty(id, "test", (Object)"small test");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"small test", inserter.getNodeProperties(id).get("test"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void replaceWithBiggerPropertySpillsOverIntoNewPropertyRecord(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", "One");
        props.put("count", 1);
        props.put("tags", new String[]{"one", "two"});
        long id = inserter.createNode(props, new Label[0]);
        inserter.setNodeProperty(id, "name", (Object)"NewOne");
        inserter.setNodeProperty(id, "count", (Object)"something");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"something", inserter.getNodeProperties(id).get("count"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void mustSplitUpRelationshipChainsWhenCreatingDenseNodes(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node1 = inserter.createNode(null, new Label[0]);
        long node2 = inserter.createNode(null, new Label[0]);
        for (int i = 0; i < 1000; ++i) {
            for (MyRelTypes relType : MyRelTypes.values()) {
                inserter.createRelationship(node1, node2, (RelationshipType)relType, null);
            }
        }
        NeoStores neoStores = BatchInsertTest.getFlushedNeoStores(inserter);
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord record = (NodeRecord)nodeStore.newRecord();
        try (PageCursor cursor = nodeStore.openPageCursorForReading(0L, CursorContext.NULL);){
            nodeStore.getRecordByCursor(node1, (AbstractBaseRecord)record, RecordLoad.NORMAL, cursor);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)record.isDense(), (String)("Node " + record + " should have been dense"));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldGetRelationships(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(null, new Label[0]);
        BatchInsertTest.createRelationships(inserter, node, RelTypes.REL_TYPE1, 3);
        BatchInsertTest.createRelationships(inserter, node, RelTypes.REL_TYPE2, 4);
        Set gottenRelationships = Iterables.asSet((Iterable)inserter.getRelationshipIds(node));
        org.junit.jupiter.api.Assertions.assertEquals((int)21, (int)gottenRelationships.size());
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotCreateSameLabelTwiceOnSameNode(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"itemId", 1000L}), new Label[]{Label.label((String)"Item"), Label.label((String)"Item")});
        NodeStore nodeStore = BatchInsertTest.getFlushedNeoStores(inserter).getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.newRecord();
        try (PageCursor cursor = nodeStore.openPageCursorForReading(nodeId, CursorContext.NULL);){
            nodeStore.getRecordByCursor(nodeId, (AbstractBaseRecord)node, RecordLoad.NORMAL, cursor);
        }
        NodeLabels labels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        long[] labelIds = labels.get(nodeStore, StoreCursors.NULL);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)labelIds.length);
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSortLabelIdsWhenGetOrCreate(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"Item", 123456789123L}), new Label[]{Label.label((String)"AA"), Label.label((String)"BB"), Label.label((String)"CC"), Label.label((String)"DD")});
        inserter.setNodeLabels(nodeId, new Label[]{Label.label((String)"CC"), Label.label((String)"AA"), Label.label((String)"DD"), Label.label((String)"EE"), Label.label((String)"FF")});
        NodeStore nodeStore = BatchInsertTest.getFlushedNeoStores(inserter).getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.newRecord();
        try (PageCursor cursor = nodeStore.openPageCursorForReading(nodeId, CursorContext.NULL);){
            nodeStore.getRecordByCursor(nodeId, (AbstractBaseRecord)node, RecordLoad.NORMAL, cursor);
        }
        NodeLabels labels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        long[] labelIds = labels.get(nodeStore, StoreCursors.NULL);
        long[] sortedLabelIds = Arrays.copyOf(labelIds, labelIds.length);
        Arrays.sort(sortedLabelIds);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])sortedLabelIds, (long[])labelIds);
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldChangePropertiesInCurrentBatch(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        Map properties = MapUtil.map((Object[])new Object[]{"key1", "value1"});
        long node = inserter.createNode(properties, new Label[0]);
        properties.put("additionalKey", "Additional value");
        inserter.setNodeProperties(node, properties);
        org.junit.jupiter.api.Assertions.assertEquals((Object)properties, BatchInsertTest.getNodeProperties(inserter, node));
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldIgnoreRemovingNonExistentNodeProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long id = inserter.createNode(Collections.emptyMap(), new Label[0]);
        inserter.removeNodeProperty(id, "non-existent");
        inserter.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldIgnoreRemovingNonExistentRelationshipProperty(int denseNodeThreshold) throws Exception {
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        Map noProperties = Collections.emptyMap();
        long nodeId1 = inserter.createNode(noProperties, new Label[0]);
        long nodeId2 = inserter.createNode(noProperties, new Label[0]);
        long id = inserter.createRelationship(nodeId1, nodeId2, (RelationshipType)MyRelTypes.TEST, noProperties);
        inserter.removeRelationshipProperty(id, "non-existent");
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldStartOnAndUpdateDbContainingFulltextIndex() throws Exception {
        int denseNodeThreshold = (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue();
        GraphDatabaseAPI db = this.instantiateGraphDatabaseService(denseNodeThreshold);
        String key = "key";
        Label label = Label.label((String)"Label");
        String indexName = "ftsNodes";
        try {
            try (Transaction tx = db.beginTx();){
                db.executeTransactionally(String.format("CREATE FULLTEXT INDEX %s FOR (n:%s) ON EACH [n.%s]", indexName, label.name(), key));
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            this.managementService.shutdown();
        }
        String value = "hey";
        BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
        long node = inserter.createNode(Collections.singletonMap(key, value), new Label[]{label});
        inserter.shutdown();
        GraphDatabaseAPI dbAfterInsert = this.instantiateGraphDatabaseService(denseNodeThreshold);
        try (Transaction tx = dbAfterInsert.beginTx();){
            ResourceIterator nodes = tx.findNodes(label, key, (Object)value);
            Node foundNode = (Node)Iterators.single((Iterator)nodes);
            org.junit.jupiter.api.Assertions.assertEquals((long)node, (long)foundNode.getId());
            dbAfterInsert.executeTransactionally(String.format("CALL db.index.fulltext.queryNodes('%s', '%s')", indexName, value), new HashMap(), result -> {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
                Map hit = result.next();
                Node indexedNode = (Node)hit.get("node");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
                return indexedNode;
            });
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBuildCorrectCountsStoreOnIncrementalImport() throws Exception {
        Label label = Label.label((String)"Person");
        int denseNodeThreshold = (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue();
        for (int r = 0; r < 3; ++r) {
            BatchInserter inserter = this.newBatchInserter(denseNodeThreshold);
            try {
                for (int i = 0; i < 100; ++i) {
                    inserter.createNode(null, new Label[]{label});
                }
            }
            finally {
                inserter.shutdown();
            }
            final int round = 1 + r;
            try (GBPTreeCountsStore countsStore = new GBPTreeCountsStore(this.pageCache, this.databaseLayout.countStore(), this.fs, RecoveryCleanupWorkCollector.immediate(), new CountsBuilder(){

                public void initialize(CountsAccessor.Updater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                    throw new UnsupportedOperationException("Should not be required");
                }

                public long lastCommittedTxId() {
                    return 1L + (long)round;
                }
            }, DatabaseReadOnlyChecker.readOnly(), PageCacheTracer.NULL, GBPTreeCountsStore.NO_MONITOR, this.databaseLayout.getDatabaseName(), 1000, (LogProvider)NullLogProvider.getInstance());){
                countsStore.start(CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                org.junit.jupiter.api.Assertions.assertEquals((long)((r + 1) * 100), (long)countsStore.nodeCount(0, CursorContext.NULL));
                continue;
            }
        }
    }

    @Test
    void shouldIncrementDegreesOnUpdatingDenseNode() throws Exception {
        int denseNodeThreshold = 10;
        BatchInserter inserter = this.newBatchInserter(this.configurationBuilder().set(GraphDatabaseSettings.dense_node_threshold, (Object)10).set(GraphDatabaseInternalSettings.batch_inserter_batch_size, (Object)2).build());
        long denseNode = inserter.createNode(null, new Label[0]);
        for (int i = 0; i < denseNodeThreshold * 2; ++i) {
            inserter.createRelationship(denseNode, inserter.createNode(null, new Label[0]), relTypeArray[0], null);
        }
        GraphDatabaseAPI db = this.switchToEmbeddedGraphDatabaseService(inserter, denseNodeThreshold);
        try (Transaction tx = db.beginTx();){
            Assertions.assertThat((int)tx.getNodeById(denseNode).getDegree(relTypeArray[0], Direction.OUTGOING)).isEqualTo(denseNodeThreshold * 2);
        }
        this.managementService.shutdown();
    }

    private Config.Builder configurationBuilder() {
        return Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.absolutePath()).set(GraphDatabaseSettings.preallocate_logical_logs, (Object)false);
    }

    private Config configuration(int denseNodeThreshold) {
        return this.configurationBuilder().set(GraphDatabaseSettings.dense_node_threshold, (Object)denseNodeThreshold).build();
    }

    private BatchInserter newBatchInserter(int denseNodeThreshold) throws Exception {
        return this.newBatchInserter(this.configuration(denseNodeThreshold));
    }

    private BatchInserter newBatchInserter(Config config) throws Exception {
        return BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (Config)config);
    }

    private BatchInserter newBatchInserterWithIndexProvider(ExtensionFactory<?> provider, IndexProviderDescriptor providerDescriptor, int denseNodeThreshold) throws Exception {
        Config configuration = this.configuration(denseNodeThreshold);
        configuration.set(GraphDatabaseSettings.default_schema_provider, (Object)providerDescriptor.name());
        return BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (Config)configuration);
    }

    private GraphDatabaseAPI switchToEmbeddedGraphDatabaseService(BatchInserter inserter, int denseNodeThreshold) {
        inserter.shutdown();
        return this.instantiateGraphDatabaseService(denseNodeThreshold);
    }

    private GraphDatabaseAPI instantiateGraphDatabaseService(int denseNodeThreshold) {
        TestDatabaseManagementServiceBuilder factory = new TestDatabaseManagementServiceBuilder((DatabaseLayout)this.databaseLayout);
        factory.setFileSystem(this.fs);
        this.managementService = factory.impermanent().setConfig(this.configuration(denseNodeThreshold)).build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private static void createRelationships(BatchInserter inserter, long node, RelationshipType relType, int out) {
        int i;
        for (i = 0; i < out; ++i) {
            inserter.createRelationship(node, inserter.createNode(null, new Label[0]), relType, null);
        }
        for (i = 0; i < out; ++i) {
            inserter.createRelationship(inserter.createNode(null, new Label[0]), node, relType, null);
        }
        for (i = 0; i < out; ++i) {
            inserter.createRelationship(node, node, relType, null);
        }
    }

    private static void setAndGet(BatchInserter inserter, Object value) {
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"key", value}), new Label[0]);
        Object readValue = inserter.getNodeProperties(nodeId).get("key");
        if (readValue.getClass().isArray()) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((int[])((int[])value), (int[])((int[])readValue));
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)value, readValue);
        }
    }

    private static int[] intArray() {
        int length = 20;
        int[] array = new int[length];
        int startValue = 0x40000000;
        for (int i = 0; i < length; ++i) {
            array[i] = startValue + i;
        }
        return array;
    }

    private static void forceFlush(BatchInserter inserter) {
        ((BatchInserterImpl)inserter).forceFlushChanges();
    }

    private static NeoStores getFlushedNeoStores(BatchInserter inserter) {
        BatchInsertTest.forceFlush(inserter);
        return ((BatchInserterImpl)inserter).getNeoStores();
    }

    private static Iterable<String> asNames(Iterable<Label> nodeLabels) {
        return Iterables.map(Label::name, nodeLabels);
    }

    private static Pair<Label[], Set<String>> manyLabels(int count) {
        Label[] labels = new Label[count];
        HashSet<CallSite> expectedLabelNames = new HashSet<CallSite>();
        for (int i = 0; i < labels.length; ++i) {
            String labelName = "bach label " + i;
            labels[i] = Label.label((String)labelName);
            expectedLabelNames.add((CallSite)((Object)labelName));
        }
        return Pair.of((Object)labels, expectedLabelNames);
    }

    private static Map<String, Object> getNodeProperties(BatchInserter inserter, long nodeId) {
        return inserter.getNodeProperties(nodeId);
    }

    private static Map<String, Object> getRelationshipProperties(BatchInserter inserter, long relId) {
        return inserter.getRelationshipProperties(relId);
    }

    static {
        properties.put("key0", "SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA");
        properties.put("key1", 1);
        properties.put("key2", (short)2);
        properties.put("key3", 3L);
        properties.put("key4", Float.valueOf(4.0f));
        properties.put("key5", 5.0);
        properties.put("key6", (byte)6);
        properties.put("key7", true);
        properties.put("key8", Character.valueOf('\b'));
        properties.put("key10", new String[]{"SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA", "dsasda", "dssadsad"});
        properties.put("key11", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key12", new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key13", new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        properties.put("key14", new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f});
        properties.put("key15", new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        properties.put("key16", new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key17", new boolean[]{true, false, true, false});
        properties.put("key18", new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t'});
    }

    private static enum Labels implements Label
    {
        FIRST,
        SECOND,
        THIRD;

    }

    private static enum RelTypes implements RelationshipType
    {
        BATCH_TEST,
        REL_TYPE1,
        REL_TYPE2,
        REL_TYPE3,
        REL_TYPE4,
        REL_TYPE5;

    }
}

