/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.TokenIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.schema.SimpleEntityTokenClient;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
@Neo4jLayoutExtension
public class BatchInsertTokenIndexesTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldPopulateTokenIndexesOnShutdown() throws Exception {
        TokenIndexReader reader;
        try {
            GraphDatabaseAPI db = this.instantiateGraphDatabaseService();
            try (Transaction tx = db.beginTx();){
                Iterable indexes = tx.schema().getIndexes();
                Assertions.assertThat((Iterable)indexes).hasSize(2);
                tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            }
        }
        finally {
            this.managementService.shutdown();
        }
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (Config)this.configuration());
        long node1 = inserter.createNode(null, new Label[]{Labels.FIRST});
        long node2 = inserter.createNode(null, new Label[]{Labels.SECOND});
        long node3 = inserter.createNode(null, new Label[]{Labels.THIRD});
        long node4 = inserter.createNode(null, new Label[]{Labels.FIRST, Labels.SECOND});
        long node5 = inserter.createNode(null, new Label[]{Labels.FIRST, Labels.THIRD});
        long rel1 = inserter.createRelationship(node1, node2, (RelationshipType)RelTypes.REL_TYPE1, Collections.emptyMap());
        long rel2 = inserter.createRelationship(node2, node3, (RelationshipType)RelTypes.REL_TYPE2, Collections.emptyMap());
        long rel3 = inserter.createRelationship(node3, node4, (RelationshipType)RelTypes.REL_TYPE3, Collections.emptyMap());
        long rel4 = inserter.createRelationship(node3, node4, (RelationshipType)RelTypes.REL_TYPE1, Collections.emptyMap());
        long rel5 = inserter.createRelationship(node3, node4, (RelationshipType)RelTypes.REL_TYPE3, Collections.emptyMap());
        inserter.shutdown();
        try (TokenIndexAccessor accesor = this.tokenIndexAccessor(EntityType.NODE);){
            reader = accesor.newTokenReader();
            try {
                BatchInsertTokenIndexesTest.assertTokenIndexContains(reader, 0, node1, node4, node5);
                BatchInsertTokenIndexesTest.assertTokenIndexContains(reader, 1, node2, node4);
                BatchInsertTokenIndexesTest.assertTokenIndexContains(reader, 2, node3, node5);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        accesor = this.tokenIndexAccessor(EntityType.RELATIONSHIP);
        try {
            reader = accesor.newTokenReader();
            try {
                BatchInsertTokenIndexesTest.assertTokenIndexContains(reader, 0, rel1, rel4);
                BatchInsertTokenIndexesTest.assertTokenIndexContains(reader, 1, rel2);
                BatchInsertTokenIndexesTest.assertTokenIndexContains(reader, 2, rel3, rel5);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (accesor != null) {
                accesor.close();
            }
        }
    }

    private static void assertTokenIndexContains(TokenIndexReader reader, int tokenId, Long ... intityIds) {
        SimpleEntityTokenClient tokenClient = new SimpleEntityTokenClient();
        reader.query((IndexProgressor.EntityTokenClient)tokenClient, IndexQueryConstraints.unconstrained(), new TokenPredicate(tokenId), CursorContext.NULL);
        ArrayList<Long> found = new ArrayList<Long>();
        while (tokenClient.next()) {
            found.add(tokenClient.reference);
        }
        Assertions.assertThat(found).containsExactlyInAnyOrder((Object[])intityIds);
    }

    private GraphDatabaseAPI instantiateGraphDatabaseService() {
        TestDatabaseManagementServiceBuilder factory = new TestDatabaseManagementServiceBuilder(this.databaseLayout);
        factory.setFileSystem(this.fs);
        this.managementService = factory.setConfig(this.configuration()).build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private Config configuration() {
        return Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.absolutePath()).set(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).build();
    }

    private TokenIndexAccessor tokenIndexAccessor(EntityType entityType) {
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (String)this.databaseLayout.getDatabaseName()).build();
        IndexDescriptor id = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)entityType), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withName("index").materialise(0L);
        Path path = entityType == EntityType.NODE ? this.databaseLayout.labelScanStore() : this.databaseLayout.relationshipTypeScanStore();
        return new TokenIndexAccessor(context, this.databaseLayout, (IndexFiles)new IndexFiles.SingleFile(this.fs, path), this.configuration(), id, RecoveryCleanupWorkCollector.immediate());
    }

    private static enum RelTypes implements RelationshipType
    {
        REL_TYPE1,
        REL_TYPE2,
        REL_TYPE3;

    }

    private static enum Labels implements Label
    {
        FIRST,
        SECOND,
        THIRD;

    }
}

