/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Test;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.batchinsert.internal.BatchInserterImpl;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.internal.locker.DatabaseLocker;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.lock.LockTracer;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class BatchInserterImplTest {
    private final Config config = Config.defaults(Map.of(GraphDatabaseSettings.pagecache_memory, "280K", GraphDatabaseSettings.logical_log_rotation_threshold, ByteUnit.mebiBytes((long)1L)));
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;

    BatchInserterImplTest() {
    }

    @Test
    void testHonorsPassedInParams() throws Exception {
        try (BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (Config)this.config);){
            NeoStores neoStores = (NeoStores)ReflectionUtil.getPrivateField((Object)inserter, (String)"neoStores", NeoStores.class);
            PageCache pageCache = (PageCache)ReflectionUtil.getPrivateField((Object)neoStores, (String)"pageCache", PageCache.class);
            long mappedMemoryTotalSize = MuninnPageCache.memoryRequiredForPages((long)pageCache.maxCachedPages());
            ((AbstractLongAssert)Assertions.assertThat((long)mappedMemoryTotalSize).as("memory mapped config is active", new Object[0])).isGreaterThan(ByteUnit.kibiBytes((long)270L)).isLessThan(ByteUnit.kibiBytes((long)290L));
        }
    }

    @Test
    void testCreatesLockFile() throws Exception {
        try (BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(this.databaseLayout.databaseLockFile(), new LinkOption[0]));
        }
    }

    @Test
    void testFailsOnExistingStoreLockFile() throws IOException {
        try (DatabaseLocker lock = new DatabaseLocker(this.fileSystem, this.databaseLayout);){
            lock.checkLock();
            FileLockException e = (FileLockException)org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem));
            Assertions.assertThat((String)e.getMessage()).startsWith((CharSequence)"Unable to obtain lock on file");
        }
    }

    @Test
    void tracePageCacheAccessInBatchInserter() throws IOException {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        DatabaseTracers databaseTracers = new DatabaseTracers(DatabaseTracer.NULL, LockTracer.NONE, (PageCacheTracer)pageCacheTracer);
        try (BatchInserterImpl inserter = new BatchInserterImpl(this.databaseLayout, this.fileSystem, this.config, databaseTracers);){
            for (int i = 0; i < 10; ++i) {
                inserter.createNode(Map.of("name", RandomStringUtils.randomAscii((int)10)), new Label[]{Label.label((String)"marker")});
            }
        }
        long pins = pageCacheTracer.pins();
        Assertions.assertThat((long)pins).isGreaterThan(0L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(pins);
        Assertions.assertThat((long)pageCacheTracer.hits()).isGreaterThan(0L).isLessThanOrEqualTo(pins);
        Assertions.assertThat((long)pageCacheTracer.faults()).isGreaterThan(0L).isLessThanOrEqualTo(pins);
        Assertions.assertThat((long)pageCacheTracer.flushes()).isGreaterThan(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCorrectlyMarkHighIds() throws Exception {
        DatabaseLayout layout = this.databaseLayout;
        long[] nodeIds = new long[10];
        try (BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem, (Config)this.config);){
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("name", "Just some name");
            properties.put("some_array", new String[]{"this", "is", "a", "string", "which", "really", "is", "an", "array"});
            for (int i = 0; i < nodeIds.length; ++i) {
                nodeIds[i] = inserter.createNode(properties, new Label[0]);
            }
        }
        MutableLongSet nodeIdsSet = LongSets.mutable.of(nodeIds);
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(layout.getNeo4jLayout().homeDirectory()).setFileSystem(this.fileSystem).build();
        try {
            Transaction tx;
            GraphDatabaseService db = dbms.database("neo4j");
            for (long nodeId : nodeIds) {
                tx = db.beginTx();
                try {
                    tx.getNodeById(nodeId).addLabel(TestLabels.LABEL_ONE);
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            for (int i = 0; i < 5; ++i) {
                try (Transaction tx2 = db.beginTx();){
                    Node node = tx2.createNode();
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)nodeIdsSet.contains(node.getId()));
                    tx2.commit();
                    continue;
                }
            }
            for (long nodeId : nodeIds) {
                tx = db.beginTx();
                try {
                    tx.getNodeById(nodeId).delete();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
        }
        finally {
            dbms.shutdown();
        }
    }
}

