/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.factory.neo4j;

import java.io.Serializable;
import org.neo4j.cypher.internal.parser.common.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.parser.common.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.parser.common.ast.factory.CreateIndexTypes;
import org.neo4j.cypher.internal.parser.common.ast.factory.HintIndexType;
import org.neo4j.cypher.internal.parser.common.ast.factory.ShowCommandFilterTypes;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005y1AAA\u0002\u0001#!)!\u0004\u0001C\u00017\t\u0019b*Z85U\u0006\u001bFKR1di>\u0014\u0018\u0010V3ti*\u0011A!B\u0001\u0006]\u0016|GG\u001b\u0006\u0003\r\u001d\tqAZ1di>\u0014\u0018P\u0003\u0002\t\u0013\u0005\u0019\u0011m\u001d;\u000b\u0005)Y\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00051i\u0011AB2za\",'O\u0003\u0002\u0005\u001d)\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003/%\tA!\u001e;jY&\u0011\u0011\u0004\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\t1\u0001")
public class Neo4jASTFactoryTest
extends CypherFunSuite {
    public Neo4jASTFactoryTest() {
        this.test("invalidDropCommand", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToStringShouldWrapper("Unsupported drop constraint command: Please delete the constraint by name instead", new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29), Prettifier$.MODULE$.default()).shouldBe((Object)"Unsupported drop constraint command: Please delete the constraint by name instead"), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("relationshipPatternNotAllowed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToStringShouldWrapper(ASTExceptionFactory.relationshipPatternNotAllowed((ConstraintType)ConstraintType.NODE_UNIQUE), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33), Prettifier$.MODULE$.default()).shouldBe((Object)"'IS NODE UNIQUE' does not allow relationship patterns"), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("nodePatternNotAllowed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToStringShouldWrapper(ASTExceptionFactory.nodePatternNotAllowed((ConstraintType)ConstraintType.REL_KEY), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39), Prettifier$.MODULE$.default()).shouldBe((Object)"'IS RELATIONSHIP KEY' does not allow node patterns"), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("onlySinglePropertyAllowed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToStringShouldWrapper(ASTExceptionFactory.onlySinglePropertyAllowed((ConstraintType)ConstraintType.NODE_EXISTS), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45), Prettifier$.MODULE$.default()).shouldBe((Object)"Constraint type 'EXISTS' does not allow multiple properties"), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("invalidShowFilterType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToStringShouldWrapper(ASTExceptionFactory.invalidShowFilterType((String)"indexes", (ShowCommandFilterTypes)ShowCommandFilterTypes.INVALID), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51), Prettifier$.MODULE$.default()).shouldBe((Object)"Filter type INVALID is not defined for show indexes command."), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("invalidCreateIndexType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToStringShouldWrapper(ASTExceptionFactory.invalidCreateIndexType((CreateIndexTypes)CreateIndexTypes.INVALID), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58), Prettifier$.MODULE$.default()).shouldBe((Object)"Index type INVALID is not defined for create index command."), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("invalidBTREEHintIndexType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToStringShouldWrapper(ASTExceptionFactory.invalidHintIndexType((HintIndexType)HintIndexType.BTREE), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default()).shouldBe((Object)"Index type BTREE is no longer supported for USING index hint. Use TEXT, RANGE or POINT instead."), new Position("Neo4jASTFactoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
    }
}

