/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.Main;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.ShellParameterMap;
import org.neo4j.shell.StringLinePrinter;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.cli.Encryption;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.log.AnsiLogger;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.shell.terminal.CypherShellTerminalBuilder;
import org.neo4j.shell.test.AssertableMain;
import org.neo4j.shell.util.Version;
import org.neo4j.shell.util.Versions;

@Timeout(value=5L, unit=TimeUnit.MINUTES)
class MainIntegrationTest {
    private static final String USER = "neo4j";
    private static final String PASSWORD = "neo";
    private static final String newLine = System.lineSeparator();
    private static final String GOOD_BYE = String.format(":exit%n%nBye!%n", new Object[0]);
    private final Version serverVersion = Versions.version((String)((String)this.runInDbAndReturn("", CypherShell::getServerVersion)));
    private final Matcher<String> endsWithInteractiveExit = CoreMatchers.endsWith((String)String.format("> %s", GOOD_BYE));

    MainIntegrationTest() {
    }

    private Matcher<String> returned42AndExited() {
        return Matchers.allOf((Matcher)CoreMatchers.containsString((String)this.return42Output()), this.endsWithInteractiveExit);
    }

    @Test
    void promptsOnWrongAuthenticationIfInteractive() throws Exception {
        this.testWithUser("kate", "bush", false).args("--format verbose").userInputLines(new String[]{"kate", "bush", "return 42 as x;", ":exit"}).run().assertSuccess().assertThatOutput(new Matcher[]{Matchers.startsWith((String)String.format("username: kate%npassword: ****%n", new Object[0])), this.returned42AndExited()});
    }

    @Test
    void promptsOnPasswordChangeRequiredSinceVersion4() throws Exception {
        Assumptions.assumeTrue((this.serverVersion.major() >= 4 ? 1 : 0) != 0);
        this.testWithUser("bob", "expired", true).args("--format verbose").userInputLines(new String[]{"bob", "expired", "newpass", "newpass", "return 42 as x;", ":exit"}).run().assertSuccess().assertThatOutput(new Matcher[]{Matchers.startsWith((String)String.format("username: bob%npassword: *******%nPassword change required%nnew password: *******%nconfirm password: *******%n", new Object[0])), this.returned42AndExited()});
    }

    @Test
    void promptsOnPasswordChangeRequiredBeforeVersion4() throws Exception {
        Assumptions.assumeTrue((this.serverVersion.major() < 4 ? 1 : 0) != 0);
        this.testWithUser("bob", "expired", true).args("--format verbose").userInputLines(new String[]{"bob", "expired", "match (n) return count(n);", ":exit"}).run().assertSuccess(false).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"CALL dbms.changePassword")}).assertThatOutput(new Matcher[]{this.endsWithInteractiveExit});
    }

    @Test
    void allowUserToUpdateExpiredPasswordInteractivelyWithoutBeingPrompted() throws Exception {
        Assumptions.assumeTrue((this.serverVersion.major() >= 4 ? 1 : 0) != 0);
        this.testWithUser("bob", "expired", true).args("-u bob -p expired -d system --format verbose").addArgs(new String[]{"ALTER CURRENT USER SET PASSWORD FROM \"expired\" TO \"shinynew\";"}).run().assertSuccess().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)"0 rows")});
        this.assertUserCanConnectAndRunQuery("bob", "shinynew");
    }

    @Test
    void shouldFailIfNonInteractivelySettingPasswordOnNonSystemDb() throws Exception {
        Assumptions.assumeTrue((this.serverVersion.major() >= 4 ? 1 : 0) != 0);
        this.testWithUser("kjell", "expired", true).args("-u kjell -p expired -d neo4j --non-interactive").addArgs(new String[]{"ALTER CURRENT USER SET PASSWORD FROM \"expired\" TO \"h\u00f6glund\";"}).run().assertFailure(new String[0]).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"The credentials you provided were valid, but must be changed")});
    }

    @Test
    void shouldBePromptedIfRunningNonInteractiveCypherThatDoesntUpdatePassword() throws Exception {
        Assumptions.assumeTrue((this.serverVersion.major() >= 4 ? 1 : 0) != 0);
        this.testWithUser("bruce", "expired", true).args("-u bruce -p expired -d neo4j").addArgs(new String[]{"match (n) return n;"}).userInputLines(new String[]{"newpass", "newpass"}).run().assertSuccess();
        this.assertUserCanConnectAndRunQuery("bruce", "newpass");
    }

    @Test
    void shouldNotBePromptedIfRunningWithExplicitNonInteractiveCypherThatDoesntUpdatePassword() throws Exception {
        Assumptions.assumeTrue((this.serverVersion.major() >= 4 ? 1 : 0) != 0);
        this.testWithUser("nick", "expired", true).args("-u nick -p expired -d neo4j --non-interactive").addArgs(new String[]{"match (n) return n;"}).run().assertFailure(new String[0]).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"The credentials you provided were valid, but must be changed")}).assertThatOutput(new Matcher[]{Matchers.emptyString()});
    }

    @Test
    void doesPromptOnNonInteractiveOuput() throws Exception {
        this.testWithUser("holy", "ghost", false).addArgs(new String[]{"return 42 as x;"}).outputInteractive(false).userInputLines(new String[]{"holy", "ghost"}).run().assertSuccessAndConnected().assertOutputLines(new String[]{"username: holy", "password: *****", "x", "42"});
    }

    @Test
    void shouldHandleEmptyLine() throws Exception {
        String expectedPrompt = String.format("neo4j@neo4j> %nneo4j@neo4j> :exit", new Object[0]);
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{"", ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)expectedPrompt), this.endsWithInteractiveExit});
    }

    @Test
    void wrongPortWithBolt() throws Exception {
        this.testWithUser("leonard", "coen", false).args("-u leonard -p coen -a bolt://localhost:1234").run().assertFailure(new String[]{"Unable to connect to localhost:1234, ensure the database is running and that there is a working network connection to it."});
    }

    @Test
    void wrongPortWithNeo4j() throws Exception {
        this.testWithUser("jackie", "leven", false).args("-u jackie -p leven -a neo4j://localhost:1234").run().assertFailure(new String[]{"Connection refused"});
    }

    @Test
    void shouldAskForCredentialsWhenConnectingWithAFile() throws Exception {
        this.testWithUser("jacob", "collier", false).addArgs(new String[]{"--file", this.fileFromResource("single.cypher")}).userInputLines(new String[]{"jacob", "collier"}).run().assertSuccessAndConnected().assertOutputLines(new String[]{"username: jacob", "password: *******", "result", "42"});
    }

    @Test
    void shouldSupportVerboseFormatWhenReadingFile() throws Exception {
        String expectedQueryResult = String.format("+--------+%n| result |%n+--------+%n| 42     |%n+--------+", new Object[0]);
        this.testWithUser("philip", "glass", false).args("-u philip -p glass --format verbose").addArgs(new String[]{"--file", this.fileFromResource("single.cypher")}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)expectedQueryResult)});
    }

    @Test
    void shouldReadEmptyCypherStatementsFile() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--file", this.fileFromResource("empty.cypher")}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{Matchers.emptyString()});
    }

    @Test
    void shouldReadMultipleCypherStatementsFromFile() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--file", this.fileFromResource("multiple.cypher")}).run().assertSuccessAndConnected().assertOutputLines(new String[]{"result", "42", "result", "1337", "result", "\"done\""});
    }

    @Test
    void shouldFailIfInputFileDoesntExist() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--file", "missing-file"}).run().assertFailure(new String[]{"missing-file (No such file or directory)"});
    }

    @Test
    void shouldHandleInvalidCypherFromFile() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--file", this.fileFromResource("invalid.cypher")}).run().assertFailure(new String[0]).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"Invalid input")}).assertOutputLines(new String[]{"result", "42"});
    }

    @Test
    void shouldReadSingleCypherStatementsFromFileInteractively() throws Exception {
        String file = this.fileFromResource("single.cypher");
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":source " + file, ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :source " + file + String.format("%nresult%n42", new Object[0]))), this.endsWithInteractiveExit});
    }

    @Test
    void shouldDisconnect() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", ":exit"}).run().assertSuccessAndDisconnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected>", new Object[0]))), CoreMatchers.endsWith((String)GOOD_BYE)});
    }

    @Test
    void shouldNotBeAbleToRunQueryWhenDisconnected() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", "RETURN 42 AS x;", ":exit"}).run().assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"Not connected to Neo4j")}).assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected>", new Object[0]))), CoreMatchers.endsWith((String)GOOD_BYE)});
    }

    @Test
    void shouldDisconnectAndHelp() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", ":help", ":exit"}).run().assertSuccessAndDisconnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :help", new Object[0]))), CoreMatchers.containsString((String)String.format("%nAvailable commands:", new Object[0])), CoreMatchers.endsWith((String)GOOD_BYE)});
    }

    @Test
    void shouldDisconnectAndHistory() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", ":history", ":exit"}).run().assertSuccessAndDisconnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :history", new Object[0]))), CoreMatchers.containsString((String)"1  :disconnect"), CoreMatchers.containsString((String)"2  :history"), CoreMatchers.endsWith((String)GOOD_BYE)});
    }

    @Test
    void shouldDisconnectAndSource() throws Exception {
        String file = this.fileFromResource("exit.cypher");
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", ":source " + file}).run().assertSuccessAndDisconnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :source %s", file))), CoreMatchers.endsWith((String)String.format("Bye!%n", new Object[0]))});
    }

    @Test
    void shouldDisconnectAndConnectWithUsernamePasswordAndDatabase() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", String.format(":connect -u %s -p %s -d %s", USER, PASSWORD, "system"), ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :connect -u %s -p %s -d %s", USER, PASSWORD, "system"))), CoreMatchers.endsWith((String)String.format("%s@%s> %s", USER, "system", GOOD_BYE))});
    }

    @Test
    void shouldDisconnectAndConnectWithUsernamePasswordAndDatabaseWithFullArguments() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", String.format(":connect --username %s --password %s --database %s", USER, PASSWORD, "system"), ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :connect --username %s --password %s --database %s", USER, PASSWORD, "system"))), CoreMatchers.endsWith((String)String.format("%s@%s> %s", USER, "system", GOOD_BYE))});
    }

    @Test
    void shouldFailIfConnectingWithInvalidPassword() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", String.format(":connect -u %s -p %s -d %s", USER, "wut!", "system"), ":exit"}).run().assertSuccessAndDisconnected(false).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"The client is unauthorized due to authentication failure.")}).assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :connect -u %s -p %s -d %s", USER, "wut!", "system"))), CoreMatchers.endsWith((String)GOOD_BYE)});
    }

    @Test
    void shouldFailIfConnectingWithInvalidUser() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", String.format(":connect -u %s -p %s -d %s", "PaulWesterberg", PASSWORD, "system"), ":exit"}).run().assertSuccessAndDisconnected(false).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"The client is unauthorized due to authentication failure.")}).assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :connect -u %s -p %s -d %s", "PaulWesterberg", PASSWORD, "system"))), CoreMatchers.endsWith((String)GOOD_BYE)});
    }

    @Test
    void shouldDisconnectAndConnectWithUsernameAndPassword() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", String.format(":connect -u %s -p %s", USER, PASSWORD), ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :connect -u %s -p %s", USER, PASSWORD))), CoreMatchers.endsWith((String)String.format("%s@%s> %s", USER, USER, GOOD_BYE))});
    }

    @Test
    void shouldPromptForUsernameAndPasswordIfOnlyDBProvided() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", String.format(":connect -d %s", "system"), USER, PASSWORD, ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :connect -d %s", "system"))), CoreMatchers.containsString((String)(String.format("%nusername: %s", USER) + String.format("%npassword: ***", new Object[0]))), CoreMatchers.endsWith((String)String.format("%s@%s> %s", USER, "system", GOOD_BYE))});
    }

    @Test
    void shouldPromptForPasswordIfOnlyUserProvided() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", String.format(":connect -d %s", "system"), USER, PASSWORD, ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :connect -d %s", "system"))), CoreMatchers.containsString((String)(String.format("%nusername: %s", USER) + String.format("%npassword: ***", new Object[0]))), CoreMatchers.endsWith((String)String.format("%s@%s> %s", USER, "system", GOOD_BYE))});
    }

    @Test
    void shouldPromptForUsernameAndPasswordIfNoArgumentsProvided() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect ", ":connect", USER, PASSWORD, ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :disconnect " + String.format("%nDisconnected> :connect", new Object[0]))), CoreMatchers.containsString((String)(String.format("%nusername: %s", USER) + String.format("%npassword: ***", new Object[0]))), CoreMatchers.endsWith((String)GOOD_BYE)});
    }

    @Test
    void shouldReadMultipleCypherStatementsFromFileInteractively() throws Exception {
        String file = this.fileFromResource("multiple.cypher");
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":source " + file, ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :source " + file + String.format("%nresult%n42%nresult%n1337%nresult%n\"done\"", new Object[0]))), this.endsWithInteractiveExit});
    }

    @Test
    void shouldReadEmptyCypherStatementsFromFileInteractively() throws Exception {
        String file = this.fileFromResource("empty.cypher");
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":source " + file, ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :source " + file + newLine + "neo4j@")), this.endsWithInteractiveExit});
    }

    @Test
    void shouldHandleInvalidCypherStatementsFromFileInteractively() throws Exception {
        String file = this.fileFromResource("invalid.cypher");
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":source " + file, ":exit"}).run().assertSuccessAndConnected(false).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"Invalid input")}).assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :source " + file + String.format("%nresult%n42%n", new Object[0]) + "neo4j@")), this.endsWithInteractiveExit});
    }

    @Test
    void shouldFailIfInputFileDoesntExistInteractively() throws Exception {
        String file = "this-is-not-a-file";
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":source " + file, ":exit"}).run().assertSuccessAndConnected(false).assertThatErrorOutput(new Matcher[]{Matchers.is((Object)("Cannot find file: '" + file + "'" + newLine))}).assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)("> :source " + file + newLine + "neo4j@")), this.endsWithInteractiveExit});
    }

    @Test
    void doesNotStartWhenDefaultDatabaseUnavailableIfInteractive() {
        Assumptions.assumeTrue((this.serverVersion.major() >= 4 ? 1 : 0) != 0);
        this.withDefaultDatabaseStopped((ThrowingAction<Exception>)((ThrowingAction)() -> this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD}).run().assertFailure(new String[0]).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"database is unavailable")}).assertOutputLines(new String[0])));
    }

    @Test
    void startsAgainstSystemDatabaseWhenDefaultDatabaseUnavailableIfInteractive() {
        Assumptions.assumeTrue((this.serverVersion.major() >= 4 ? 1 : 0) != 0);
        this.withDefaultDatabaseStopped((ThrowingAction<Exception>)((ThrowingAction)() -> this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "-d", "system"}).userInputLines(new String[]{":exit"}).run().assertSuccessAndConnected()));
    }

    @Test
    void switchingToUnavailableDatabaseIfInteractive() {
        Assumptions.assumeTrue((this.serverVersion.major() >= 4 ? 1 : 0) != 0);
        this.withDefaultDatabaseStopped((ThrowingAction<Exception>)((ThrowingAction)() -> this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "-d", "system"}).userInputLines(new String[]{":use neo4j", ":exit"}).run().assertSuccessAndConnected(false).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"database is unavailable")}).assertThatOutput(new Matcher[]{this.endsWithInteractiveExit})));
    }

    @Test
    void switchingToUnavailableDefaultDatabaseIfInteractive() {
        Assumptions.assumeTrue((this.serverVersion.major() >= 4 ? 1 : 0) != 0);
        this.withDefaultDatabaseStopped((ThrowingAction<Exception>)((ThrowingAction)() -> this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "-d", "system"}).userInputLines(new String[]{":use", ":exit"}).run().assertSuccessAndConnected(false).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"database is unavailable")}).assertThatOutput(new Matcher[]{this.endsWithInteractiveExit})));
    }

    @Test
    void shouldChangePassword() throws Exception {
        this.testWithUser("kate", "bush", false).args("--change-password").userInputLines(new String[]{"kate", "bush", "betterpassword", "betterpassword"}).run().assertSuccess().assertOutputLines(new String[]{"username: kate", "password: ****", "new password: **************", "confirm password: **************"});
        this.assertUserCanConnectAndRunQuery("kate", "betterpassword");
    }

    @Test
    void shouldChangePasswordWhenRequired() throws Exception {
        this.testWithUser("paul", "simon", true).args("--change-password").userInputLines(new String[]{"paul", "simon", "newpassword", "newpassword"}).run().assertSuccess().assertOutputLines(new String[]{"username: paul", "password: *****", "new password: ***********", "confirm password: ***********"});
        this.assertUserCanConnectAndRunQuery("paul", "newpassword");
    }

    @Test
    void shouldChangePasswordWithUser() throws Exception {
        this.testWithUser("mike", "oldfield", false).args("-u mike --change-password").userInputLines(new String[]{"oldfield", "newfield", "newfield"}).run().assertSuccess().assertOutputLines(new String[]{"password: ********", "new password: ********", "confirm password: ********"});
        this.assertUserCanConnectAndRunQuery("mike", "newfield");
    }

    @Test
    void shouldFailToChangePassword() throws Exception {
        this.testWithUser("led", "zeppelin", false).args("-u led --change-password").userInputLines(new String[]{"FORGOT MY PASSWORD", "robert", "robert"}).run().assertFailure(new String[0]).assertThatErrorOutput(new Matcher[]{Matchers.startsWith((String)"Failed to change password")}).assertOutputLines(new String[]{"password: ******************", "new password: ******", "confirm password: ******"});
    }

    @Test
    void shouldHandleMultiLineHistory() throws Exception {
        String expected = "> :history\n 1  return\n    'hej' as greeting;\n 2  return\n    1\n    as\n    x\n    ;\n 3  :history\n";
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{"return", "'hej' as greeting;", "return", "1", "as", "x", ";", ":history", ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)expected), this.endsWithInteractiveExit});
    }

    @Test
    void clearHistory() throws ArgumentParserException, IOException {
        Path history = Files.createTempFile("temp-history", null, new FileAttribute[0]);
        this.buildTest().historyFile(history.toFile()).addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{"return 1;", "return 2;", ":exit"}).run().assertSuccessAndConnected();
        List<String> readHistory = Files.readAllLines(history);
        Assertions.assertEquals((int)3, (int)readHistory.size());
        MatcherAssert.assertThat((Object)readHistory.get(0), (Matcher)CoreMatchers.endsWith((String)"return 1;"));
        MatcherAssert.assertThat((Object)readHistory.get(1), (Matcher)CoreMatchers.endsWith((String)"return 2;"));
        MatcherAssert.assertThat((Object)readHistory.get(2), (Matcher)CoreMatchers.endsWith((String)":exit"));
        String expected1 = "> :history\n 1  return 1;\n 2  return 2;\n 3  :exit\n 4  return 3;\n 5  :history";
        String expected2 = "> :history\n 1  :history\n\n";
        this.buildTest().historyFile(history.toFile()).addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{"return 3;", ":history", ":history clear", ":history", ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)expected1), CoreMatchers.containsString((String)expected2)});
        List<String> readHistoryAfterClear = Files.readAllLines(history);
        Assertions.assertEquals((int)2, (int)readHistoryAfterClear.size());
        MatcherAssert.assertThat((Object)readHistoryAfterClear.get(0), (Matcher)CoreMatchers.endsWith((String)":history"));
        MatcherAssert.assertThat((Object)readHistoryAfterClear.get(1), (Matcher)CoreMatchers.endsWith((String)":exit"));
    }

    @Test
    void shouldDisconnectAndReconnectAsOtherUser() throws Exception {
        this.assumeAtLeastVersion("4.2.0");
        this.testWithUser("new_user", "new_password", false).addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect", ":connect -u new_user -p new_password -d neo4j", "show current user yield user;"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)"show current user yield user;\nuser\n\"new_user\"\nnew_user@neo4j>")});
    }

    @Test
    void shouldDisconnectAndFailToReconnect() throws Exception {
        this.testWithUser("new_user", "new_password", false).addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect", ":connect -u new_user -p neo -d neo4j", "show current user yield user;"}).run().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)"neo4j@neo4j> :disconnect\nDisconnected> :connect -u new_user -p neo -d neo4j\nDisconnected> show current user yield user;\nDisconnected>")}).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"The client is unauthorized due to authentication failure"), CoreMatchers.containsString((String)"Not connected")});
    }

    @Test
    void shouldDisconnectAndFailToReconnectInteractively() throws Exception {
        this.testWithUser("new_user", "new_password", false).outputInteractive(true).addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":disconnect", ":connect -u new_user -d neo4j", PASSWORD, "show current user yield user;"}).run().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)"neo4j@neo4j> :disconnect\nDisconnected> :connect -u new_user -d neo4j\npassword: ***\nDisconnected> show current user yield user;\nDisconnected>")}).assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"The client is unauthorized due to authentication failure"), CoreMatchers.containsString((String)"Not connected")});
    }

    @Test
    void shouldNotConnectIfAlreadyConnected() throws Exception {
        this.assumeAtLeastVersion("4.2.0");
        this.testWithUser("new_user", "new_password", false).addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":connect -u new_user -p new_password -d neo4j", "show current user yield user;"}).run().assertThatErrorOutput(new Matcher[]{CoreMatchers.containsString((String)"Already connected")}).assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)"neo4j@neo4j> :connect -u new_user -p new_password -d neo4j\nneo4j@neo4j> show current user yield user;\nuser\n\"neo4j\"\nneo4j@neo4j> ")});
    }

    @Test
    void shouldIndentLineContinuations() throws ArgumentParserException, IOException {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{"return", "1 as res", ";", ":exit"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)"neo4j@neo4j> return\n             1 as res\n             ;\nres\n1\nneo4j@neo4j> :exit")});
    }

    @Test
    void evaluatesParameterArguments() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).addArgs(new String[]{"--param", "purple => 'rain'"}).addArgs(new String[]{"--param", "advice => ['talk', 'less', 'smile', 'more']"}).addArgs(new String[]{"--param", "when => date('2021-01-12')"}).addArgs(new String[]{"--param", "repeatAfterMe => 'A' + 'B' + 'C'"}).addArgs(new String[]{"--param", "easyAs => 1 + 2 + 3"}).userInputLines(new String[]{":params", "return $purple, $advice, $when, $repeatAfterMe, $easyAs;"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)"> :params\n:param advice        => ['talk', 'less', 'smile', 'more']\n:param easyAs        => 1 + 2 + 3\n:param purple        => 'rain'\n:param repeatAfterMe => 'A' + 'B' + 'C'\n:param when          => date('2021-01-12')\n"), CoreMatchers.containsString((String)"> return $purple, $advice, $when, $repeatAfterMe, $easyAs;\n$purple, $advice, $when, $repeatAfterMe, $easyAs\n\"rain\", [\"talk\", \"less\", \"smile\", \"more\"], 2021-01-12, \"ABC\", 6\n")});
    }

    @Test
    void evaluatesArgumentsInteractive() throws Exception {
        this.buildTest().addArgs(new String[]{"-u", USER, "-p", PASSWORD, "--format", "plain"}).userInputLines(new String[]{":param purple => 'rain'", ":param advice => ['talk', 'less', 'smile', 'more']", ":param when => date('2021-01-12')", ":param repeatAfterMe => 'A' + 'B' + 'C'", ":param easyAs => 1 + 2 + 3", ":params", "return $purple, $advice, $when, $repeatAfterMe, $easyAs;"}).run().assertSuccessAndConnected().assertThatOutput(new Matcher[]{CoreMatchers.containsString((String)"> :params\n:param advice        => ['talk', 'less', 'smile', 'more']\n:param easyAs        => 1 + 2 + 3\n:param purple        => 'rain'\n:param repeatAfterMe => 'A' + 'B' + 'C'\n:param when          => date('2021-01-12')\n"), CoreMatchers.containsString((String)"> return $purple, $advice, $when, $repeatAfterMe, $easyAs;\n$purple, $advice, $when, $repeatAfterMe, $easyAs\n\"rain\", [\"talk\", \"less\", \"smile\", \"more\"], 2021-01-12, \"ABC\", 6\n")});
    }

    private void assertUserCanConnectAndRunQuery(String user, String password) throws Exception {
        this.buildTest().addArgs(new String[]{"-u", user, "-p", password, "--format", "plain", "return 42 as x;"}).run().assertSuccess();
    }

    private AssertableMain.AssertableMainBuilder buildTest() {
        return new TestBuilder().outputInteractive(true);
    }

    private AssertableMain.AssertableMainBuilder testWithUser(String name, String password, boolean requirePasswordChange) {
        this.runInSystemDb((ThrowingConsumer<CypherShell, Exception>)((ThrowingConsumer)shell -> MainIntegrationTest.createOrReplaceUser(shell, name, password, requirePasswordChange)));
        return this.buildTest();
    }

    private void runInSystemDb(ThrowingConsumer<CypherShell, Exception> systemDbConsumer) {
        this.runInSystemDbAndReturn(shell -> {
            systemDbConsumer.accept(shell);
            return null;
        });
    }

    private <T> T runInDbAndReturn(String database, ThrowingFunction<CypherShell, T, Exception> systemDbConsumer) {
        CypherShell shell = null;
        try {
            shell = new CypherShell((LinePrinter)new StringLinePrinter(), new PrettyConfig(Format.PLAIN, false, 100), true, (ParameterMap)new ShellParameterMap());
            shell.connect(new ConnectionConfig(USER, "localhost", 7687, USER, PASSWORD, Encryption.DEFAULT, database));
            Object object = systemDbConsumer.apply((Object)shell);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute statements during test setup: " + e.getMessage(), e);
        }
        finally {
            if (shell != null) {
                shell.disconnect();
            }
        }
    }

    private <T> T runInSystemDbAndReturn(ThrowingFunction<CypherShell, T, Exception> systemDbConsumer) {
        String systemDb = this.serverVersion.major() >= 4 ? "system" : "";
        return this.runInDbAndReturn(systemDb, systemDbConsumer);
    }

    private static void createOrReplaceUser(CypherShell shell, String name, String password, boolean requirePasswordChange) throws CommandException {
        block4: {
            if (Versions.majorVersion((String)shell.getServerVersion()) >= 4) {
                String changeString = requirePasswordChange ? "" : " CHANGE NOT REQUIRED";
                shell.execute("CREATE OR REPLACE USER " + name + " SET PASSWORD '" + password + "'" + changeString + ";");
                shell.execute("GRANT ROLE reader TO " + name + ";");
            } else {
                try {
                    shell.execute("CALL dbms.security.createUser('" + name + "', '" + password + "', " + requirePasswordChange + ")");
                }
                catch (ClientException e) {
                    if (!e.code().equalsIgnoreCase("Neo.ClientError.General.InvalidArguments") || !e.getMessage().contains("already exists")) break block4;
                    shell.execute("CALL dbms.security.deleteUser('" + name + "')");
                    shell.execute("CALL dbms.security.createUser('" + name + "', '" + password + "', " + requirePasswordChange + ")");
                }
            }
        }
    }

    private String return42Output() {
        return String.format("> return 42 as x;%n" + this.return42VerboseTable(), new Object[0]);
    }

    private String return42VerboseTable() {
        return String.format("+----+%n| x  |%n+----+%n| 42 |%n+----+%n%n1 row", new Object[0]);
    }

    private String fileFromResource(String filename) {
        return Objects.requireNonNull(this.getClass().getClassLoader().getResource(filename)).getFile();
    }

    private void withDefaultDatabaseStopped(ThrowingAction<Exception> test) {
        try {
            this.runInSystemDb((ThrowingConsumer<CypherShell, Exception>)((ThrowingConsumer)shell -> shell.execute("STOP DATABASE neo4j;")));
            test.apply();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.runInSystemDb((ThrowingConsumer<CypherShell, Exception>)((ThrowingConsumer)shell -> shell.execute("START DATABASE neo4j;")));
        }
    }

    private void assumeAtLeastVersion(String version) {
        Assumptions.assumeTrue((this.serverVersion.compareTo(Versions.version((String)version)) > 0 ? 1 : 0) != 0);
    }

    private static class TestBuilder
    extends AssertableMain.AssertableMainBuilder {
        private TestBuilder() {
        }

        public AssertableMain run() throws ArgumentParserException, IOException {
            Assertions.assertNull((Object)this.runnerFactory);
            Assertions.assertNull((Object)this.shell);
            CliArgs args = this.parseArgs();
            PrintStream outPrintStream = new PrintStream(this.out);
            PrintStream errPrintStream = new PrintStream(this.err);
            AnsiLogger logger = new AnsiLogger(false, Format.VERBOSE, outPrintStream, errPrintStream);
            CypherShellTerminal terminal = CypherShellTerminalBuilder.terminalBuilder().dumb().streams((InputStream)this.in, (OutputStream)outPrintStream).interactive(!args.getNonInteractive()).logger((Logger)logger).build();
            Main main = new Main(args, outPrintStream, errPrintStream, this.isOutputInteractive.booleanValue(), terminal);
            int exitCode = main.startShell();
            return new AssertableMain(exitCode, this.out, this.err, main.getCypherShell());
        }
    }
}

