/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.ShellParameterMap;
import org.neo4j.shell.StringLinePrinter;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.commands.CypherShellIntegrationTest;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyConfig;

class CypherShellFailureIntegrationTest
extends CypherShellIntegrationTest {
    private final StringLinePrinter linePrinter = new StringLinePrinter();

    CypherShellFailureIntegrationTest() {
    }

    @BeforeEach
    void setUp() {
        this.linePrinter.clear();
        this.shell = new CypherShell((LinePrinter)this.linePrinter, new PrettyConfig(Format.VERBOSE, true, 1000), false, (ParameterMap)new ShellParameterMap());
    }

    @AfterEach
    void cleanUp() {
        this.shell.disconnect();
    }

    @Test
    void cypherWithNoPasswordShouldReturnValidError() {
        AuthenticationException exception = (AuthenticationException)Assertions.assertThrows(AuthenticationException.class, () -> this.connect(""));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"The client is unauthorized due to authentication failure."));
    }
}

