/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.DatabaseManager;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.ShellParameterMap;
import org.neo4j.shell.StringLinePrinter;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.cli.Encryption;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.commands.Begin;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.Rollback;
import org.neo4j.shell.commands.Use;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.util.Versions;

class CypherShellMultiDatabaseIntegrationTest {
    private final StringLinePrinter linePrinter = new StringLinePrinter();
    private Command useCommand;
    private Command beginCommand;
    private Command rollbackCommand;
    private CypherShell shell;

    CypherShellMultiDatabaseIntegrationTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.linePrinter.clear();
        this.shell = new CypherShell((LinePrinter)this.linePrinter, new PrettyConfig(Format.PLAIN, true, 1000), false, (ParameterMap)new ShellParameterMap());
        this.useCommand = new Use((DatabaseManager)this.shell);
        this.beginCommand = new Begin((TransactionHandler)this.shell);
        this.rollbackCommand = new Rollback((TransactionHandler)this.shell);
        this.shell.connect(new ConnectionConfig("bolt", "localhost", 7687, "neo4j", "neo", Encryption.DEFAULT, ""));
        Assumptions.assumeTrue((Versions.majorVersion((String)this.shell.getServerVersion()) >= 4 ? 1 : 0) != 0);
    }

    @AfterEach
    void cleanUp() {
        this.shell.disconnect();
    }

    @Test
    void switchingToSystemDatabaseWorks() throws CommandException {
        this.useCommand.execute("system");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.is((Object)""));
        this.assertOnSystemDB();
    }

    @Test
    void switchingToSystemDatabaseIsNotCaseSensitive() throws CommandException {
        this.useCommand.execute("SyStEm");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.is((Object)""));
        this.assertOnSystemDB();
    }

    @Test
    void switchingToSystemDatabaseAndBackToNeo4jWorks() throws CommandException {
        this.useCommand.execute("system");
        this.useCommand.execute("neo4j");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.is((Object)""));
        this.assertOnRegularDB();
    }

    @Test
    void switchingToSystemDatabaseAndBackToDefaultWorks() throws CommandException {
        this.useCommand.execute("system");
        this.useCommand.execute("");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.is((Object)""));
        this.assertOnRegularDB();
    }

    @Test
    void switchingDatabaseInOpenTransactionShouldFail() throws CommandException {
        this.beginCommand.execute("");
        CommandException exception = (CommandException)Assertions.assertThrows(CommandException.class, () -> this.useCommand.execute("another_database"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"There is an open transaction."));
    }

    @Test
    void switchingDatabaseAfterRollbackTransactionWorks() throws CommandException {
        this.beginCommand.execute("");
        this.rollbackCommand.execute("");
        this.useCommand.execute("system");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.is((Object)""));
        this.assertOnSystemDB();
    }

    @Test
    void switchingToNonExistingDatabaseShouldGiveErrorResponseFromServer() throws CommandException {
        this.useCommand.execute("system");
        try {
            this.useCommand.execute("this_database_name_does_not_exist_in_test_container");
            Assertions.fail((String)"No ClientException thrown");
        }
        catch (ClientException e) {
            this.assertOnNoValidDB();
        }
    }

    @Test
    void switchingToNonExistingDatabaseShouldGiveErrorResponseFromServerInteractive() throws CommandException {
        this.shell = new CypherShell((LinePrinter)this.linePrinter, new PrettyConfig(Format.PLAIN, true, 1000), true, (ParameterMap)new ShellParameterMap());
        this.useCommand = new Use((DatabaseManager)this.shell);
        this.shell.connect(new ConnectionConfig("bolt", "localhost", 7687, "neo4j", "neo", Encryption.DEFAULT, ""));
        this.useCommand.execute("system");
        try {
            this.useCommand.execute("this_database_name_does_not_exist_in_test_container");
            Assertions.fail((String)"No ClientException thrown");
        }
        catch (ClientException e) {
            this.assertOnSystemDB();
        }
    }

    private void assertOnRegularDB() throws CommandException {
        this.shell.execute("RETURN 'toadstool'");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.containsString((String)"toadstool"));
    }

    private void assertOnSystemDB() throws CommandException {
        this.shell.execute("SHOW DATABASES");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.containsString((String)"neo4j"));
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.containsString((String)"system"));
    }

    private void assertOnNoValidDB() {
        Assertions.assertThrows(ClientException.class, () -> this.shell.execute("RETURN 1"));
    }
}

