/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.ShellParameterMap;
import org.neo4j.shell.StringLinePrinter;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.commands.CypherShellIntegrationTest;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyConfig;

class CypherShellPlainIntegrationTest
extends CypherShellIntegrationTest {
    private final StringLinePrinter linePrinter = new StringLinePrinter();

    CypherShellPlainIntegrationTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.linePrinter.clear();
        this.shell = new CypherShell((LinePrinter)this.linePrinter, new PrettyConfig(Format.PLAIN, true, 1000), false, (ParameterMap)new ShellParameterMap());
        this.connect("neo");
    }

    @AfterEach
    void tearDown() throws Exception {
        try {
            this.shell.execute("MATCH (n) DETACH DELETE (n)");
        }
        finally {
            this.shell.disconnect();
        }
    }

    @Test
    void cypherWithProfileStatements() throws CommandException {
        this.shell.execute("CYPHER RUNTIME=INTERPRETED PROFILE RETURN null");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Plan: \"PROFILE\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Statement: \"READ_ONLY\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Planner: \"COST\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Runtime: \"INTERPRETED\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"DbHits: 0"));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Rows: 1"));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"null"));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"NULL"));
    }

    @Test
    void cypherWithProfileWithMemory() throws CommandException {
        Assumptions.assumeTrue((boolean)this.runningAtLeast("4.1"));
        this.shell.execute("CYPHER RUNTIME=INTERPRETED PROFILE RETURN null");
        String actual = this.linePrinter.output();
        System.out.println(actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Memory (Bytes): "));
    }

    @Test
    void cypherWithExplainStatements() throws CommandException {
        this.shell.execute("CYPHER RUNTIME=INTERPRETED EXPLAIN RETURN null");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Plan: \"EXPLAIN\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Statement: \"READ_ONLY\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Planner: \"COST\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Runtime: \"INTERPRETED\""));
    }

    @Test
    void shouldUseParamFromCLIArgs() throws CommandException {
        ShellParameterMap parameterMap = new ShellParameterMap();
        parameterMap.setParameter("foo", "'bar'");
        this.shell = new CypherShell((LinePrinter)this.linePrinter, new PrettyConfig(Format.PLAIN, true, 1000), false, (ParameterMap)parameterMap);
        this.connect("neo");
        this.shell.execute("CYPHER RETURN $foo");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"$foo"));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"bar"));
    }
}

