/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.ShellParameterMap;
import org.neo4j.shell.StringLinePrinter;
import org.neo4j.shell.cli.Encryption;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.util.Versions;

class CypherShellProtocolIntegrationTest {
    CypherShellProtocolIntegrationTest() {
    }

    @Test
    void shouldConnectWithBoltProtocol() throws Exception {
        CypherShell shell = new CypherShell((LinePrinter)new StringLinePrinter(), new PrettyConfig(Format.PLAIN, true, 1000), false, (ParameterMap)new ShellParameterMap());
        try {
            shell.connect(new ConnectionConfig("bolt", "localhost", 7687, "neo4j", "neo", Encryption.DEFAULT, ""));
            Assertions.assertTrue((boolean)shell.isConnected());
        }
        finally {
            shell.disconnect();
        }
    }

    @Test
    void shouldConnectWithNeo4jProtocol() throws Exception {
        CypherShell shell = new CypherShell((LinePrinter)new StringLinePrinter(), new PrettyConfig(Format.PLAIN, true, 1000), false, (ParameterMap)new ShellParameterMap());
        try {
            shell.connect(new ConnectionConfig("neo4j", "localhost", 7687, "neo4j", "neo", Encryption.DEFAULT, ""));
            Assertions.assertTrue((boolean)shell.isConnected());
        }
        finally {
            shell.disconnect();
        }
    }

    @Test
    void shouldConnectWithBoltSSCProtocol() throws Exception {
        CypherShell shell = new CypherShell((LinePrinter)new StringLinePrinter(), new PrettyConfig(Format.PLAIN, true, 1000), false, (ParameterMap)new ShellParameterMap());
        try {
            CypherShellProtocolIntegrationTest.onlyIn3_2to3_6(shell);
            shell.connect(new ConnectionConfig("bolt+ssc", "localhost", 7687, "neo4j", "neo", Encryption.DEFAULT, ""));
            Assertions.assertTrue((boolean)shell.isConnected());
        }
        finally {
            shell.disconnect();
        }
    }

    @Test
    void shouldConnectWithNeo4jSSCProtocol() throws Exception {
        CypherShell shell = new CypherShell((LinePrinter)new StringLinePrinter(), new PrettyConfig(Format.PLAIN, true, 1000), false, (ParameterMap)new ShellParameterMap());
        try {
            CypherShellProtocolIntegrationTest.onlyIn3_2to3_6(shell);
            shell.connect(new ConnectionConfig("neo4j+ssc", "localhost", 7687, "neo4j", "neo", Encryption.DEFAULT, ""));
            Assertions.assertTrue((boolean)shell.isConnected());
        }
        finally {
            shell.disconnect();
        }
    }

    private static void onlyIn3_2to3_6(CypherShell shell) throws Exception {
        shell.connect(new ConnectionConfig("bolt", "localhost", 7687, "neo4j", "neo", Encryption.DEFAULT, ""));
        Assumptions.assumeTrue((Versions.majorVersion((String)shell.getServerVersion()) == 3 ? 1 : 0) != 0);
        Assumptions.assumeTrue((Versions.minorVersion((String)shell.getServerVersion()) > 1 ? 1 : 0) != 0);
        shell.disconnect();
    }
}

