/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.ShellParameterMap;
import org.neo4j.shell.StringLinePrinter;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.commands.Begin;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.Commit;
import org.neo4j.shell.commands.CypherShellIntegrationTest;
import org.neo4j.shell.commands.Rollback;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.state.ErrorWhileInTransactionException;

class CypherShellTransactionIntegrationTest
extends CypherShellIntegrationTest {
    private final StringLinePrinter linePrinter = new StringLinePrinter();
    private Command rollbackCommand;
    private Command commitCommand;
    private Command beginCommand;

    CypherShellTransactionIntegrationTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.shell = new CypherShell((LinePrinter)this.linePrinter, new PrettyConfig(Format.VERBOSE, true, 1000), false, (ParameterMap)new ShellParameterMap());
        this.rollbackCommand = new Rollback((TransactionHandler)this.shell);
        this.commitCommand = new Commit((TransactionHandler)this.shell);
        this.beginCommand = new Begin((TransactionHandler)this.shell);
        this.connect("neo");
        this.shell.execute("MATCH (n) DETACH DELETE (n)");
    }

    @AfterEach
    void cleanUp() {
        this.shell.disconnect();
        this.linePrinter.clear();
    }

    @Test
    void rollbackScenario() throws CommandException {
        this.shell.execute("CREATE (:TestPerson {name: \"Jane Smith\"})");
        this.beginCommand.execute("");
        this.shell.execute("CREATE (:NotCreated)");
        this.rollbackCommand.execute("");
        this.shell.execute("MATCH (n) RETURN n");
        String output = this.linePrinter.output();
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"| n "));
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"| (:TestPerson {name: \"Jane Smith\"}) |"));
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)":NotCreated")));
    }

    @Test
    void failureInTxScenario() throws CommandException {
        this.beginCommand.execute("");
        ErrorWhileInTransactionException exception = (ErrorWhileInTransactionException)Assertions.assertThrows(ErrorWhileInTransactionException.class, () -> this.shell.execute("RETURN 1/0"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"/ by zero"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"An error occurred while in an open transaction. The transaction will be rolled back and terminated."));
    }

    @Test
    void failureInTxScenarioWithCypherFollowing() throws CommandException {
        this.beginCommand.execute("");
        try {
            this.shell.execute("RETURN 1/0");
        }
        catch (ErrorWhileInTransactionException errorWhileInTransactionException) {
            // empty catch block
        }
        this.shell.execute("RETURN 42");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.containsString((String)"42"));
    }

    @Test
    void failureInTxScenarioWithCommitFollowing() throws CommandException {
        this.beginCommand.execute("");
        try {
            this.shell.execute("RETURN 1/0");
        }
        catch (ErrorWhileInTransactionException errorWhileInTransactionException) {
            // empty catch block
        }
        CommandException exception = (CommandException)Assertions.assertThrows(CommandException.class, () -> this.commitCommand.execute(""));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"There is no open transaction to commit"));
    }

    @Test
    void failureInTxScenarioWithRollbackFollowing() throws CommandException {
        this.beginCommand.execute("");
        try {
            this.shell.execute("RETURN 1/0");
        }
        catch (ErrorWhileInTransactionException errorWhileInTransactionException) {
            // empty catch block
        }
        CommandException exception = (CommandException)Assertions.assertThrows(CommandException.class, () -> this.rollbackCommand.execute(""));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"There is no open transaction to rollback"));
    }

    @Test
    void resetInFailedTxScenario() throws CommandException {
        this.beginCommand.execute("");
        try {
            this.shell.execute("RETURN 1/0");
        }
        catch (ErrorWhileInTransactionException errorWhileInTransactionException) {
            // empty catch block
        }
        this.shell.reset();
        this.shell.execute("CREATE (:TestPerson {name: \"Jane Smith\"})");
        this.shell.execute("MATCH (n) RETURN n");
        String result = this.linePrinter.output();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"| (:TestPerson {name: \"Jane Smith\"}) |"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)":NotCreated")));
    }

    @Test
    void resetInTxScenario() throws CommandException {
        this.beginCommand.execute("");
        this.shell.execute("CREATE (:NotCreated)");
        this.shell.reset();
        this.shell.execute("CREATE (:TestPerson {name: \"Jane Smith\"})");
        this.shell.execute("MATCH (n) RETURN n");
        String result = this.linePrinter.output();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"| (:TestPerson {name: \"Jane Smith\"}) |"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)":NotCreated")));
    }

    @Test
    void commitScenario() throws CommandException {
        this.beginCommand.execute("");
        this.shell.execute("CREATE (:TestPerson {name: \"Joe Smith\"})");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.containsString((String)"0 rows\n"));
        this.linePrinter.clear();
        this.shell.execute("CREATE (:TestPerson {name: \"Jane Smith\"})");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.containsString((String)"0 rows\n"));
        this.linePrinter.clear();
        this.shell.execute("MATCH (n:TestPerson) RETURN n ORDER BY n.name");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.containsString((String)"\n| (:TestPerson {name: \"Jane Smith\"}) |\n| (:TestPerson {name: \"Joe Smith\"})  |\n"));
        this.commitCommand.execute("");
    }
}

