/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.ShellParameterMap;
import org.neo4j.shell.StringLinePrinter;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.commands.CypherShellIntegrationTest;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.util.Versions;

class CypherShellVerboseIntegrationTest
extends CypherShellIntegrationTest {
    private final StringLinePrinter linePrinter = new StringLinePrinter();

    CypherShellVerboseIntegrationTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.linePrinter.clear();
        this.shell = new CypherShell((LinePrinter)this.linePrinter, new PrettyConfig(Format.VERBOSE, true, 1000), false, (ParameterMap)new ShellParameterMap());
        this.connect("neo");
    }

    @AfterEach
    void tearDown() throws Exception {
        try {
            this.shell.execute("MATCH (n) DETACH DELETE (n)");
        }
        finally {
            this.shell.disconnect();
        }
    }

    @Test
    void parseDuration() throws CommandException {
        this.shell.execute("RETURN duration({months:0.75})");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.containsString((String)"P22DT19H51M49.5S"));
    }

    @Test
    void cypherWithNoReturnStatements() throws CommandException {
        this.shell.execute("CREATE (:TestPerson {name: \"Jane Smith\"})");
        MatcherAssert.assertThat((Object)this.linePrinter.output(), (Matcher)CoreMatchers.containsString((String)"Added 1 nodes, Set 1 properties, Added 1 labels"));
    }

    @Test
    void cypherWithReturnStatements() throws CommandException {
        this.shell.execute("CREATE (jane :TestPerson {name: \"Jane Smith\"}) RETURN jane");
        String output = this.linePrinter.output();
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"| jane "));
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"| (:TestPerson {name: \"Jane Smith\"}) |"));
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Added 1 nodes, Set 1 properties, Added 1 labels"));
    }

    @Test
    void connectTwiceThrows() {
        Assertions.assertTrue((boolean)this.shell.isConnected(), (String)"Shell should already be connected");
        CommandException exception = (CommandException)Assertions.assertThrows(CommandException.class, () -> this.connect("neo"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Already connected"));
    }

    @Test
    void resetOutOfTxScenario() throws CommandException {
        this.shell.execute("CREATE (:TestPerson {name: \"Jane Smith\"})");
        this.shell.reset();
        this.shell.execute("CREATE (:TestPerson {name: \"Jane Smith\"})");
        this.shell.execute("MATCH (n:TestPerson) RETURN n ORDER BY n.name");
        String result = this.linePrinter.output();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"| (:TestPerson {name: \"Jane Smith\"}) |\n| (:TestPerson {name: \"Jane Smith\"}) |"));
    }

    @Test
    void paramsAndListVariables() throws CommandException {
        Assertions.assertTrue((boolean)this.shell.getParameterMap().allParameterValues().isEmpty());
        long randomLong = System.currentTimeMillis();
        String stringInput = "\"randomString\"";
        this.shell.getParameterMap().setParameter("string", stringInput);
        Object paramValue = this.shell.getParameterMap().setParameter("bob", String.valueOf(randomLong));
        Assertions.assertEquals((Object)randomLong, (Object)paramValue);
        this.shell.execute("RETURN $bob, $string");
        String result = this.linePrinter.output();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"| $bob"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)("| " + randomLong + " | " + stringInput + " |")));
        Assertions.assertEquals((Object)randomLong, this.shell.getParameterMap().allParameterValues().get("bob"));
        Assertions.assertEquals((Object)"randomString", this.shell.getParameterMap().allParameterValues().get("string"));
    }

    @Test
    void paramsAndListVariablesWithSpecialCharacters() throws CommandException {
        Assertions.assertTrue((boolean)this.shell.getParameterMap().allParameterValues().isEmpty());
        long randomLong = System.currentTimeMillis();
        Object paramValue = this.shell.getParameterMap().setParameter("`bob`", String.valueOf(randomLong));
        Assertions.assertEquals((Object)randomLong, (Object)paramValue);
        this.shell.execute("RETURN $`bob`");
        String result = this.linePrinter.output();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"| $`bob`"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)("\n| " + randomLong + " |\n")));
        Assertions.assertEquals((Object)randomLong, this.shell.getParameterMap().allParameterValues().get("bob"));
    }

    @Test
    void cypherWithOrder() throws CommandException {
        Assumptions.assumeTrue((boolean)this.runningAtLeast("3.6"));
        try {
            this.shell.execute("DROP INDEX ON :Person(age)");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shell.execute("CREATE INDEX ON :Person(age)");
        this.shell.execute("CALL db.awaitIndexes()");
        this.shell.execute("CYPHER RUNTIME=INTERPRETED EXPLAIN MATCH (n:Person) WHERE n.age >= 18 RETURN n.name, n.age ORDER BY n.age");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Order"));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"n.age ASC"));
    }

    @Test
    void cypherWithQueryDetails() throws CommandException {
        Assumptions.assumeTrue((boolean)this.runningAtLeast("4.1"));
        this.shell.execute("EXPLAIN MATCH (n) with n.age AS age RETURN age");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Details"));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"n.age AS age"));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Identifiers")));
    }

    @Test
    void cypherWithoutQueryDetails() throws CommandException {
        Assumptions.assumeTrue((!this.runningAtLeast("4.1") ? 1 : 0) != 0);
        this.shell.execute("EXPLAIN MATCH (n) with n.age AS age RETURN age");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Details")));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"Identifiers"));
    }

    @Test
    void cypherWithExplainAndRulePlanner() throws CommandException {
        Assumptions.assumeTrue((Versions.majorVersion((String)this.shell.getServerVersion()) < 4 ? 1 : 0) != 0);
        this.shell.execute("CYPHER planner=rule EXPLAIN MATCH (e:E) WHERE e.bucket='Live' and e.id = 23253473 RETURN count(e)");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"\"EXPLAIN\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"\"READ_ONLY\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"\"RULE\""));
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"\"INTERPRETED\""));
    }

    @Test
    void cypherWithProfileWithMemory() throws CommandException {
        Assumptions.assumeTrue((boolean)this.runningAtLeast("4.1"));
        this.shell.execute("CYPHER RUNTIME=INTERPRETED PROFILE WITH 1 AS x RETURN DISTINCT x");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual.replace(" ", ""), (Matcher)CoreMatchers.containsString((String)"|Plan|Statement|Version|Planner|Runtime|Time|DbHits|Rows|Memory(Bytes)|"));
        MatcherAssert.assertThat((Object)actual.replace(" ", ""), (Matcher)CoreMatchers.containsString((String)"|Operator|Details|EstimatedRows|Rows|DBHits|Memory(Bytes)|PageCacheHits/Misses|"));
    }

    @Test
    void shouldShowTheNumberOfRows() throws CommandException {
        this.shell.execute("UNWIND [1,2,3] AS row RETURN row");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"3 rows\n"));
    }

    @Test
    void shouldNotContainUnnecessaryNewLines() throws CommandException {
        this.shell.execute("UNWIND [1,2,3] AS row RETURN row");
        String actual = this.linePrinter.output();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)String.format("+-----+%n| row |%n+-----+%n| 1   |%n| 2   |%n| 3   |%n+-----+%n%n3 rows%nready to start consuming query after", new Object[0])));
    }
}

