/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocatorMetric;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocatorMetricProvider;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocatorTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.SimpleLeakAwareByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledDirectByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledHeapByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public abstract class AbstractByteBufAllocatorTest<T extends AbstractByteBufAllocator>
extends ByteBufAllocatorTest {
    protected abstract T newAllocator(boolean var1);

    protected abstract T newUnpooledAllocator();

    @Override
    protected boolean isDirectExpected(boolean preferDirect) {
        return preferDirect && PlatformDependent.hasUnsafe();
    }

    @Override
    protected final int defaultMaxCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected final int defaultMaxComponents() {
        return 16;
    }

    @Test
    public void testCalculateNewCapacity() {
        this.testCalculateNewCapacity(true);
        this.testCalculateNewCapacity(false);
    }

    private void testCalculateNewCapacity(boolean preferDirect) {
        T allocator = this.newAllocator(preferDirect);
        Assertions.assertEquals((int)8, (int)allocator.calculateNewCapacity(1, 8));
        Assertions.assertEquals((int)7, (int)allocator.calculateNewCapacity(1, 7));
        Assertions.assertEquals((int)64, (int)allocator.calculateNewCapacity(1, 129));
        Assertions.assertEquals((int)0x400000, (int)allocator.calculateNewCapacity(0x400000, 0x400001));
        Assertions.assertEquals((int)0x800000, (int)allocator.calculateNewCapacity(0x400001, 0x1000000));
        try {
            allocator.calculateNewCapacity(8, 7);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            allocator.calculateNewCapacity(-1, 8);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnsafeHeapBufferAndUnsafeDirectBuffer() {
        T allocator = this.newUnpooledAllocator();
        ByteBuf directBuffer = allocator.directBuffer();
        AbstractByteBufAllocatorTest.assertInstanceOf(directBuffer, PlatformDependent.hasUnsafe() ? UnpooledUnsafeDirectByteBuf.class : UnpooledDirectByteBuf.class);
        directBuffer.release();
        ByteBuf heapBuffer = allocator.heapBuffer();
        AbstractByteBufAllocatorTest.assertInstanceOf(heapBuffer, PlatformDependent.hasUnsafe() ? UnpooledUnsafeHeapByteBuf.class : UnpooledHeapByteBuf.class);
        heapBuffer.release();
    }

    protected static void assertInstanceOf(ByteBuf buffer, Class<? extends ByteBuf> clazz) {
        Assertions.assertTrue((boolean)clazz.isInstance(buffer instanceof SimpleLeakAwareByteBuf ? buffer.unwrap() : buffer));
    }

    @Test
    public void testUsedDirectMemory() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        Assertions.assertEquals((long)0L, (long)metric.usedDirectMemory());
        ByteBuf buffer = allocator.directBuffer(1024, 4096);
        int capacity = buffer.capacity();
        Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory(), (String)buffer.toString());
        buffer.release();
        Assertions.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedDirectMemory());
    }

    @Test
    public void testUsedHeapMemory() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        Assertions.assertEquals((long)0L, (long)metric.usedHeapMemory());
        ByteBuf buffer = allocator.heapBuffer(1024, 4096);
        int capacity = buffer.capacity();
        Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        buffer.release();
        Assertions.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedHeapMemory());
    }

    protected long expectedUsedMemory(T allocator, int capacity) {
        return capacity;
    }

    protected long expectedUsedMemoryAfterRelease(T allocator, int capacity) {
        return 0L;
    }

    protected void trimCaches(T allocator) {
    }
}

