/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.util.IllegalReferenceCountException;

public class AbstractReferenceCountedByteBufTest {
    @Test
    public void testRetainOverflow() {
        final AbstractReferenceCountedByteBuf referenceCounted = AbstractReferenceCountedByteBufTest.newReferenceCounted();
        referenceCounted.setRefCnt(Integer.MAX_VALUE);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.retain();
            }
        });
    }

    @Test
    public void testRetainOverflow2() {
        final AbstractReferenceCountedByteBuf referenceCounted = AbstractReferenceCountedByteBufTest.newReferenceCounted();
        Assertions.assertEquals((int)1, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.retain(Integer.MAX_VALUE);
            }
        });
    }

    @Test
    public void testReleaseOverflow() {
        final AbstractReferenceCountedByteBuf referenceCounted = AbstractReferenceCountedByteBufTest.newReferenceCounted();
        referenceCounted.setRefCnt(0);
        Assertions.assertEquals((int)0, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.release(Integer.MAX_VALUE);
            }
        });
    }

    @Test
    public void testReleaseErrorMessage() {
        AbstractReferenceCountedByteBuf referenceCounted = AbstractReferenceCountedByteBufTest.newReferenceCounted();
        Assertions.assertTrue((boolean)referenceCounted.release());
        try {
            referenceCounted.release(1);
            Assertions.fail((String)"IllegalReferenceCountException didn't occur");
        }
        catch (IllegalReferenceCountException e) {
            Assertions.assertEquals((Object)"refCnt: 0, decrement: 1", (Object)e.getMessage());
        }
    }

    @Test
    public void testRetainResurrect() {
        final AbstractReferenceCountedByteBuf referenceCounted = AbstractReferenceCountedByteBufTest.newReferenceCounted();
        Assertions.assertTrue((boolean)referenceCounted.release());
        Assertions.assertEquals((int)0, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.retain();
            }
        });
    }

    @Test
    public void testRetainResurrect2() {
        final AbstractReferenceCountedByteBuf referenceCounted = AbstractReferenceCountedByteBufTest.newReferenceCounted();
        Assertions.assertTrue((boolean)referenceCounted.release());
        Assertions.assertEquals((int)0, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.retain(2);
            }
        });
    }

    private static AbstractReferenceCountedByteBuf newReferenceCounted() {
        return new AbstractReferenceCountedByteBuf(Integer.MAX_VALUE){

            protected byte _getByte(int index) {
                throw new UnsupportedOperationException();
            }

            protected short _getShort(int index) {
                throw new UnsupportedOperationException();
            }

            protected short _getShortLE(int index) {
                throw new UnsupportedOperationException();
            }

            protected int _getUnsignedMedium(int index) {
                throw new UnsupportedOperationException();
            }

            protected int _getUnsignedMediumLE(int index) {
                throw new UnsupportedOperationException();
            }

            protected int _getInt(int index) {
                throw new UnsupportedOperationException();
            }

            protected int _getIntLE(int index) {
                throw new UnsupportedOperationException();
            }

            protected long _getLong(int index) {
                throw new UnsupportedOperationException();
            }

            protected long _getLongLE(int index) {
                throw new UnsupportedOperationException();
            }

            protected void _setByte(int index, int value) {
                throw new UnsupportedOperationException();
            }

            protected void _setShort(int index, int value) {
                throw new UnsupportedOperationException();
            }

            protected void _setShortLE(int index, int value) {
                throw new UnsupportedOperationException();
            }

            protected void _setMedium(int index, int value) {
                throw new UnsupportedOperationException();
            }

            protected void _setMediumLE(int index, int value) {
                throw new UnsupportedOperationException();
            }

            protected void _setInt(int index, int value) {
                throw new UnsupportedOperationException();
            }

            protected void _setIntLE(int index, int value) {
                throw new UnsupportedOperationException();
            }

            protected void _setLong(int index, long value) {
                throw new UnsupportedOperationException();
            }

            protected void _setLongLE(int index, long value) {
                throw new UnsupportedOperationException();
            }

            public int capacity() {
                throw new UnsupportedOperationException();
            }

            public ByteBuf capacity(int newCapacity) {
                throw new UnsupportedOperationException();
            }

            public ByteBufAllocator alloc() {
                throw new UnsupportedOperationException();
            }

            public ByteOrder order() {
                throw new UnsupportedOperationException();
            }

            public ByteBuf unwrap() {
                throw new UnsupportedOperationException();
            }

            public boolean isDirect() {
                throw new UnsupportedOperationException();
            }

            public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
                throw new UnsupportedOperationException();
            }

            public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
                throw new UnsupportedOperationException();
            }

            public ByteBuf getBytes(int index, ByteBuffer dst) {
                throw new UnsupportedOperationException();
            }

            public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
                throw new UnsupportedOperationException();
            }

            public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
                throw new UnsupportedOperationException();
            }

            public ByteBuf setBytes(int index, ByteBuffer src) {
                throw new UnsupportedOperationException();
            }

            public int setBytes(int index, InputStream in, int length) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ByteBuf copy(int index, int length) {
                throw new UnsupportedOperationException();
            }

            public int nioBufferCount() {
                throw new UnsupportedOperationException();
            }

            public ByteBuffer nioBuffer(int index, int length) {
                throw new UnsupportedOperationException();
            }

            public ByteBuffer internalNioBuffer(int index, int length) {
                throw new UnsupportedOperationException();
            }

            public ByteBuffer[] nioBuffers(int index, int length) {
                throw new UnsupportedOperationException();
            }

            public boolean hasArray() {
                throw new UnsupportedOperationException();
            }

            public byte[] array() {
                throw new UnsupportedOperationException();
            }

            public int arrayOffset() {
                throw new UnsupportedOperationException();
            }

            public boolean hasMemoryAddress() {
                throw new UnsupportedOperationException();
            }

            public long memoryAddress() {
                throw new UnsupportedOperationException();
            }

            protected void deallocate() {
            }

            public AbstractReferenceCountedByteBuf touch(Object hint) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

