/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PooledByteBufAllocatorTest;

public class AlignedPooledByteBufAllocatorTest
extends PooledByteBufAllocatorTest {
    @Override
    protected PooledByteBufAllocator newAllocator(boolean preferDirect) {
        int directMemoryCacheAlignment = 1;
        return new PooledByteBufAllocator(preferDirect, PooledByteBufAllocator.defaultNumHeapArena(), PooledByteBufAllocator.defaultNumDirectArena(), PooledByteBufAllocator.defaultPageSize(), 11, PooledByteBufAllocator.defaultSmallCacheSize(), 64, PooledByteBufAllocator.defaultUseCacheForAllThreads(), directMemoryCacheAlignment);
    }

    @Test
    public void testCorrectElementSize() {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, PooledByteBufAllocator.defaultNumHeapArena(), PooledByteBufAllocator.defaultNumDirectArena(), PooledByteBufAllocator.defaultPageSize(), 11, PooledByteBufAllocator.defaultSmallCacheSize(), 64, PooledByteBufAllocator.defaultUseCacheForAllThreads(), 64);
        ByteBuf a = allocator.directBuffer(0, 16384);
        ByteBuf b = allocator.directBuffer(0, 16384);
        a.capacity(16);
        Assertions.assertEquals((int)16, (int)a.capacity());
        b.capacity(16);
        Assertions.assertEquals((int)16, (int)b.capacity());
        a.capacity(17);
        Assertions.assertEquals((int)17, (int)a.capacity());
        b.capacity(18);
        Assertions.assertEquals((int)18, (int)b.capacity());
        Assertions.assertTrue((boolean)a.release());
        Assertions.assertTrue((boolean)b.release());
    }
}

