/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.nio.ByteOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractByteBufTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledDirectByteBuf;

public class BigEndianDirectByteBufTest
extends AbstractByteBufTest {
    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        ByteBuf buffer = this.newDirectBuffer(length, maxCapacity);
        Assertions.assertSame((Object)ByteOrder.BIG_ENDIAN, (Object)buffer.order());
        Assertions.assertEquals((int)0, (int)buffer.writerIndex());
        return buffer;
    }

    protected ByteBuf newDirectBuffer(int length, int maxCapacity) {
        return new UnpooledDirectByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, length, maxCapacity);
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assertions.assertTrue((boolean)buf.isContiguous());
        buf.release();
    }
}

